/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import com.arizotaz.lotus.utils.FileDownload;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class PostFileDownload
extends FileDownload {
    private HashMap<String, String> args = new HashMap();

    public PostFileDownload(String url, File location, HashMap<String, String> args) {
        super(url, location);
        this.args = args;
    }

    public PostFileDownload(String url, File location, File tempLocation, HashMap<String, String> args) {
        super(url, location, tempLocation);
        this.args = args;
    }

    protected void Download() throws IOException {
        int numBytesRead;
        float fileSize;
        URL url = new URL(this.url);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        HashMap<String, String> arguments = this.args;
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry entry : arguments.entrySet()) {
            sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        http.setFixedLengthStreamingMode(length);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        http.connect();
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        if (this.useTempFile) {
            this.CreateTempFile();
        } else {
            this.tempFile = new File(this.location.getAbsolutePath());
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(http.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
        this.totalSize = fileSize = (float)http.getContentLength();
        byte[] bucket = new byte[2048];
        while ((numBytesRead = bufferedInputStream.read(bucket, 0, bucket.length)) != -1) {
            fileOutputStream.write(bucket, 0, numBytesRead);
            this.downloadedBytes += (float)numBytesRead;
        }
        fileOutputStream.close();
        bufferedInputStream.close();
    }
}

