/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TextShorts {
    public static String UppercaseWords(String dat) {
        Object built = "";
        String[] broken = dat.split(" ");
        for (int i = 0; i < broken.length; ++i) {
            String word = broken[i];
            built = (String)built + TextShorts.UppercaseWord(word) + " ";
        }
        return ((String)built).substring(0, ((String)built).length() - 1);
    }

    public static String UppercaseWord(String dat) {
        if (!dat.equals("")) {
            if (dat.length() > 1) {
                String letter = dat.substring(0, 1).toUpperCase();
                String rest = dat.substring(1).toLowerCase();
                return letter + rest;
            }
            return dat.toUpperCase();
        }
        return dat;
    }

    public static String SizeToText(long size) {
        String suffix = " Bytes";
        if (size > 1000L) {
            size = Math.round(size / 1000L);
            suffix = " KBs";
            if (size > 1000L) {
                size = Math.round(size / 1000L);
                suffix = " MBs";
                if (size > 1000L) {
                    size = Math.round(size / 1000L);
                    suffix = " GBs";
                }
            }
        }
        return size + suffix;
    }

    public static String SizeToTextFrac(double size) {
        String text;
        String suffix = " Bytes";
        if (size > 1000.0) {
            size = (double)Math.round(size / 100.0) / 10.0;
            suffix = " KBs";
            if (size > 1000.0) {
                size = (double)Math.round(size / 100.0) / 10.0;
                suffix = " MBs";
                if (size > 1000.0) {
                    size = (double)Math.round(size / 10.0) / 10.0;
                    suffix = " GBs";
                }
            }
        }
        if ((text = String.valueOf(size)).endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        return text + suffix;
    }

    public static String MSToDate(long ms) {
        return TextShorts.MSToDate(ms, "MM-dd-yyyy");
    }

    public static String MSToRegDate(long ms) {
        return TextShorts.MSToDate(ms, "dd-MM-yyyy");
    }

    public static String MSToDate(long ms, String pattern) {
        LocalDateTime dateObj = Instant.ofEpochMilli(ms).atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return dateObj.format(formatter);
    }

    public static String NumberToString(double number) {
        String dat = String.valueOf(number);
        if (dat.endsWith(".0")) {
            dat = dat.substring(0, dat.length() - 2);
        }
        return dat;
    }

    public static String RemoveWhiteSpaceTail(String string) {
        return string.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
    }

    public static String StrictCleanUp(String string) {
        String str = string.replaceAll("\n", "");
        str = str.replaceAll("\r", "");
        str = str.replaceAll("\t", "");
        str = TextShorts.RemoveWhiteSpaceTail(str);
        return str;
    }

    public static String StackTraceToString(Throwable exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static String ClassID(Class<?> c) {
        return c.getClass().getCanonicalName();
    }
}

