/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.RenderObjects;
import com.arizotaz.lotus.Time;
import com.arizotaz.lotus.audio.AudioManager;
import com.arizotaz.lotus.gamepad.ControllerCallBack;
import com.arizotaz.lotus.gamepad.ControllerManager;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.utils.BufferUtilities;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.window.KeyboardInput;
import com.arizotaz.lotus.window.KeyboardTextInput;
import com.arizotaz.lotus.window.Mouse;
import com.arizotaz.lotus.window.MouseScroll;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.WindowTheme;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Window {
    public volatile long window;
    private String windowTitle;
    private int width;
    private int height;
    private int fwidth;
    private int fheight;
    private int lastWidth;
    private int lastHeight;
    private float renderPercentage = 1.0f;
    private int monitorIndex = 0;
    private long currentMonitor;
    private float contentScale = 0.0f;
    private boolean takeFocus = true;
    private boolean hideEvent = false;
    private boolean showEvent = false;
    private boolean isWindowHidden = false;
    private boolean windowWantsToClose = false;
    public int drawToWindow = 10;
    private boolean vsyncState = true;
    private boolean lastVSyncState = false;
    private boolean windowSizeChanged = false;
    private boolean scaleChanged = false;
    private float lastRenderUnitScale = 0.0f;
    private boolean resizeWindow = false;
    private boolean resizable = true;
    private int viewPortWidth = 0;
    private int viewPortHeight = 0;
    private boolean renderedOnLastCycle = false;
    public String identifier = "";
    private Lotus lotusInstance;
    private int parentProcessID;
    private TextureEngine textureEngine;
    private AudioManager audioManager;
    private Mouse mouse;
    private KeyboardInput kbi;
    private KeyboardTextInput kbti;
    private MouseScroll ms;
    private ControllerManager controllerManager;
    private WindowTheme setTheme;
    private WindowTheme theme;
    private boolean themeChanged = false;
    private Vector2 canvasSize;
    private Vector2 translate;
    private Vector2 renderOffset;
    private Time time;
    private RenderObjects renderObjects;
    private float renderUnitScale = 1.0f;
    private volatile boolean inited = false;
    private int frameBuff;
    private int drawBuff;
    private int readBuff;
    private float renderFPS = 0.0f;
    private float idleFPS = 60.0f;
    private float SPS = this.renderFPS;
    public boolean resetCanvas = false;
    private long lastFPSCalc = 0L;
    private boolean inFullscreen = false;
    private int beforeFullscreenWidth = 0;
    private int beforeFullscreenHeight = 0;
    private int beforeFullscreenX = 0;
    private int beforeFullscreenY = 0;
    private boolean inBorderLess = false;
    private int beforeBorderLessWidth = 0;
    private int beforeBorderLessHeight = 0;
    private int beforeBorderLessX = 0;
    private int beforeBorderLessY = 0;
    private boolean frameBorder = false;
    private String iconPath = "";
    private float FPS = 0.0f;
    private float FPS_AVERAGE = 0.0f;
    private float FPS_HIGH = 0.0f;
    private float FPS_LOW = 0.0f;
    private float _FPS = 0.0f;
    private float _FPS_AVERAGE = 0.0f;
    private float _FPS_HIGH = 0.0f;
    private float _FPS_LOW = 0.0f;
    private double previousTime = GLFW.glfwGetTime();
    private int frameCount = 60;
    private long frameTime = 0L;
    private double loopStartTime;
    private boolean maximized = false;
    int colorTexture;
    int fbo;
    int multisampledColorRenderBuffer;
    int multisampledDepthRenderBuffer;
    int multisampledFbo;
    int samples = 0;

    public boolean Inited() {
        return this.inited;
    }

    public Window(String title, int width, int height, Lotus lotus, int processID) {
        this.identifier = String.valueOf(Math.round(Math.random() * 100000.0));
        this.lotusInstance = lotus;
        this.parentProcessID = processID;
        this.windowTitle = title;
        this.width = width;
        this.height = height;
        this.theme = this.setTheme = new StandardWindowTheme(this);
    }

    public long Init() {
        return this.Init(false, false);
    }

    public long Init(boolean startHidden) {
        return this.Init(startHidden, false);
    }

    public long Init(boolean startHidden, boolean transparentFrameBuffer) {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        this.lastWidth = 0;
        this.lastHeight = 0;
        this.fwidth = 0;
        this.fheight = 0;
        this.canvasSize = new Vector2(this.width, this.height);
        this.CreateWindow(transparentFrameBuffer);
        this.SetupGL();
        GLFW.glfwSwapInterval(0);
        this.CreateFBOs();
        this.CreateRenderObjects();
        this.textureEngine = new TextureEngine(Lotus.singleton, this);
        this.audioManager = new AudioManager(Lotus.singleton, this);
        this.mouse = new Mouse(Lotus.singleton, this);
        this.translate = new Vector2(0.0, 0.0);
        this.renderOffset = new Vector2(0.0, 0.0);
        this.time = new Time();
        this.SetupInputs();
        if (!startHidden) {
            GLFW.glfwShowWindow(this.window);
        }
        GLFW.glfwMakeContextCurrent(this.window);
        this.Process();
        this.theme.Init();
        this.inited = true;
        return this.window;
    }

    private void CreateWindow(boolean transparentFrameBuffer) {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 1);
        if (Lotus.singleton.Platform().IsMac()) {
            GLFW.glfwWindowHint(139266, 2);
            GLFW.glfwWindowHint(139267, 1);
            GLFW.glfwWindowHint(139270, 0);
        } else {
            GLFW.glfwWindowHint(139266, 3);
            GLFW.glfwWindowHint(139267, 1);
        }
        GLFW.glfwWindowHint(139276, 1);
        if (transparentFrameBuffer) {
            GLFW.glfwWindowHint(131082, 1);
        }
        this.window = GLFW.glfwCreateWindow(this.width, this.height, "Window", 0L, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.window);
    }

    private void SetupGL() {
        GL.createCapabilities();
        this.SetTitle(this.windowTitle);
        GL11.glEnable(3553);
    }

    private void SetupInputs() {
        this.kbi = new KeyboardInput();
        GLFW.glfwSetKeyCallback(this.window, this.kbi);
        this.kbti = new KeyboardTextInput();
        GLFW.glfwSetCharCallback(this.window, this.kbti);
        this.ms = new MouseScroll(this.mouse);
        GLFW.glfwSetScrollCallback(this.window, this.ms);
        this.controllerManager = new ControllerManager();
        ControllerCallBack callback = new ControllerCallBack(this.controllerManager);
        GLFW.glfwSetJoystickCallback(callback);
    }

    public void SetTitle(String string) {
        this.windowTitle = string;
        GLFW.glfwSetWindowTitle(this.window, string);
    }

    public String GetTitle() {
        return this.windowTitle;
    }

    public void CreateRenderObjects() {
        this.renderObjects = new RenderObjects(this);
    }

    public RenderObjects RenderObjects() {
        return this.renderObjects;
    }

    public void Process() {
        this.CalculateFPS();
        this.kbti.Reset();
        this.kbi.TickKeyUpdate();
        GLFW.glfwPollEvents();
        this.controllerManager.Poll();
        this.CanvasTick();
        this.time.Update();
        this.renderObjects.ClearMetrics();
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.currentMonitor = GLFW.glfwGetPrimaryMonitor();
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowPos(this.window, pWidth, pHeight);
            int cx = pWidth.get(0);
            int cy = pHeight.get(0);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            int cw = pWidth.get(0);
            int ch = pHeight.get(0);
            cx += Math.round((float)cw / 2.0f);
            cy += Math.round((float)ch / 2.0f);
            PointerBuffer glfwMonitors = GLFW.glfwGetMonitors();
            for (int i = 0; i < glfwMonitors.limit(); ++i) {
                IntBuffer v1 = stack.mallocInt(1);
                IntBuffer v2 = stack.mallocInt(1);
                GLFW.glfwGetMonitorPos(glfwMonitors.get(i), v1, v2);
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode(glfwMonitors.get(i));
                int tx = v1.get(0);
                int ty = v2.get(0);
                int tw = vidmode.width();
                int th = vidmode.height();
                if (cx <= tx || cx >= tx + tw || cy <= ty || cy >= ty + th) continue;
                this.monitorIndex = i;
                this.currentMonitor = glfwMonitors.get(i);
            }
            if (this.resizeWindow) {
                this.resizeWindow = false;
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode(this.currentMonitor);
                GLFW.glfwGetWindowPos(this.window, pWidth, pHeight);
                int oldX = pWidth.get(0);
                int oldY = pHeight.get(0);
                GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
                int oldWidth = pWidth.get(0);
                int oldHeight = pHeight.get(0);
                GLFWVidMode v = GLFW.glfwGetVideoMode(this.currentMonitor);
                int twidth = Math.round(Tools.ClampVar(this.width, 0.0f, v.width()));
                int theight = Math.round(Tools.ClampVar(this.height, 0.0f, v.height()));
                int posX = oldX - (twidth - oldWidth) / 2;
                int posY = oldY - (theight - oldHeight) / 2;
                boolean m = false;
                if (this.width > v.width() || this.height > v.height()) {
                    posX = 0;
                    posY = 10;
                    theight -= 50;
                    m = true;
                }
                this.width = twidth;
                this.height = theight;
                GLFW.glfwSetWindowSize(this.window, this.width, this.height);
                GLFW.glfwSetWindowPos(this.window, posX, posY);
                if (m) {
                    this.Maximize();
                }
            }
            GLFW.glfwGetFramebufferSize(this.window, pWidth, pHeight);
            this.fwidth = pWidth.get(0);
            this.fheight = pHeight.get(0);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            this.width = pWidth.get(0);
            this.height = pHeight.get(0);
            if (this.takeFocus) {
                this.takeFocus = false;
                GLFW.glfwFocusWindow(this.window);
            }
            if (this.hideEvent) {
                this.hideEvent = !this.hideEvent;
                GLFW.glfwHideWindow(this.window);
                this.isWindowHidden = true;
            }
            if (this.showEvent) {
                this.showEvent = !this.showEvent;
                GLFW.glfwShowWindow(this.window);
                this.isWindowHidden = false;
            }
            FloatBuffer scaleX = stack.mallocFloat(1);
            FloatBuffer scaleY = stack.mallocFloat(1);
            GLFW.glfwGetMonitorContentScale(this.currentMonitor, scaleX, scaleY);
            this.contentScale = scaleX.get(0);
            IntBuffer buffFboId = stack.mallocInt(1);
            IntBuffer drawFboId = stack.mallocInt(1);
            IntBuffer readFboId = stack.mallocInt(1);
            GL11.glGetIntegerv(36006, drawFboId);
            GL11.glGetIntegerv(36010, readFboId);
            GL11.glGetIntegerv(36006, buffFboId);
            this.frameBuff = buffFboId.get(0);
            this.drawBuff = drawFboId.get(0);
            this.readBuff = readFboId.get(0);
        }
        this.windowSizeChanged = false;
        if (this.lastWidth != this.width || this.lastHeight != this.height) {
            this.windowSizeChanged = true;
            this.lastWidth = this.width;
            this.lastHeight = this.height;
            this.viewPortWidth = this.fwidth;
            this.viewPortHeight = this.fheight;
            this.resetCanvas = true;
        }
        this.scaleChanged = false;
        if (this.renderUnitScale != this.lastRenderUnitScale) {
            this.lastRenderUnitScale = this.renderUnitScale;
            this.scaleChanged = true;
        }
        if (this.resetCanvas) {
            this.UpdateCanvas();
        }
        this.windowWantsToClose = false;
        if (GLFW.glfwWindowShouldClose(this.window)) {
            this.windowWantsToClose = true;
        }
        if (this.lastVSyncState != this.vsyncState) {
            this.lastVSyncState = this.vsyncState;
            GLFW.glfwSwapInterval(this.vsyncState ? 1 : 0);
        }
        this.translate.Set(0.0, 0.0);
        this.mouse.CheckIfInWindow();
        this.themeChanged = false;
        if (this.setTheme != this.theme) {
            this.theme = this.setTheme;
            this.theme.Init();
            this.themeChanged = true;
        }
        this.theme.SetupSpace();
        GL30.glBindFramebuffer(36160, this.multisampledFbo);
        GL11.glClear(this.multisampledFbo);
        GL11.glViewport(0, 0, this.viewPortWidth, this.viewPortHeight);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.viewPortWidth, 0.0, this.viewPortHeight, 0.0, 1.0);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glTranslatef(this.viewPortWidth / 2, this.viewPortHeight / 2, 0.0f);
        this.mouse.Tick(this.GetCursorPosX(this.window) / (double)this.width * (double)this.fwidth, this.GetCursorPosY(this.window) / (double)this.height * (double)this.fheight, GLFW.glfwGetMouseButton(this.window, 0), GLFW.glfwGetMouseButton(this.window, 1));
        if (this.drawToWindow >= 1) {
            this.theme.RenderBackground();
        }
        this.mouse.CheckIfInRenderCanvas();
    }

    public void Render(boolean updateScreen) {
        long time;
        if (!this.renderedOnLastCycle && (updateScreen || this.drawToWindow > 0)) {
            System.gc();
        }
        this.renderedOnLastCycle = false;
        GL11.glColor3d(1.0, 1.0, 1.0);
        if (this.drawToWindow > 0) {
            this.theme.RenderForeground();
            GL30.glBindFramebuffer(36160, 0);
            GL30.glBindFramebuffer(36008, this.multisampledFbo);
            GL30.glBindFramebuffer(36009, this.fbo);
            GL30.glBlitFramebuffer(0, 0, this.viewPortWidth, this.viewPortHeight, 0, 0, this.viewPortWidth, this.viewPortHeight, 16384, 9728);
            GL30.glBindFramebuffer(36160, 0);
            GL11.glEnable(3553);
            GL11.glBindTexture(3553, this.colorTexture);
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            GL11.glBegin(7);
            GL11.glTexCoord2f(0.0f, 0.0f);
            GL11.glVertex2f(-1.0f, -1.0f);
            GL11.glTexCoord2f(1.0f, 0.0f);
            GL11.glVertex2f(1.0f, -1.0f);
            GL11.glTexCoord2f(1.0f, 1.0f);
            GL11.glVertex2f(1.0f, 1.0f);
            GL11.glTexCoord2f(0.0f, 1.0f);
            GL11.glVertex2f(-1.0f, 1.0f);
            GL11.glEnd();
            this.renderedOnLastCycle = true;
        }
        int _fw = this.fwidth;
        int _fh = this.fheight;
        this.fwidth = this.width;
        this.fheight = this.height;
        this.mouse.Set(this.GetCursorPosX(this.window) / (double)this.width * (double)this.fwidth, this.GetCursorPosY(this.window) / (double)this.height * (double)this.fheight);
        GL11.glViewport(0, 0, this.viewPortWidth, this.viewPortHeight);
        GL30.glMatrixMode(5889);
        GL30.glLoadIdentity();
        GL30.glOrtho(0.0, this.width, 0.0, this.height, 0.0, 1.0);
        GL11.glTranslatef(this.width / 2, this.height / 2, 0.0f);
        this.theme.Restore();
        this.mouse.Update();
        this.fwidth = _fw;
        this.fheight = _fh;
        if (this.SPS > 0.0f && (time = (long)((this.loopStartTime - GLFW.glfwGetTime() + (double)(1.0f / this.SPS)) * 1000.0)) > 0L) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.Swap();
        if (this.drawToWindow > 0) {
            --this.drawToWindow;
            this.SPS = this.renderFPS;
        } else {
            this.SPS = this.idleFPS;
        }
        if (updateScreen) {
            this.drawToWindow = 2;
        }
    }

    public void Swap() {
        GLFW.glfwSwapBuffers(this.window);
        this.frameTime = System.nanoTime() - this.lastFPSCalc;
        this.lastFPSCalc = System.nanoTime();
    }

    public void ForceWindowDraw() {
        this.drawToWindow = 4;
    }

    public void SetFullScreen(boolean value) {
        this.inBorderLess = value;
        if (this.inBorderLess) {
            this.beforeFullscreenWidth = Math.round(this.width);
            this.beforeFullscreenHeight = Math.round(this.height);
            try (MemoryStack stack = MemoryStack.stackPush();){
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode(this.currentMonitor);
                GLFW.glfwSetWindowMonitor(this.window, this.currentMonitor, 0, 0, vidmode.width(), vidmode.height(), -1);
            }
        }
        if (this.beforeFullscreenWidth == 0 || this.beforeFullscreenHeight == 0) {
            this.beforeFullscreenWidth = 960;
            this.beforeFullscreenHeight = 540;
        }
        GLFW.glfwSetWindowMonitor(this.window, 0L, 0, 0, this.beforeFullscreenWidth, this.beforeFullscreenHeight, -1);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            this.Border(true);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(this.currentMonitor);
            GLFW.glfwSetWindowPos(this.window, this.beforeFullscreenX, this.beforeFullscreenY);
        }
    }

    public void SetBorderLessWindowed(boolean value) {
        this.inBorderLess = value;
        if (this.inBorderLess) {
            this.beforeBorderLessWidth = Math.round(this.width);
            this.beforeBorderLessHeight = Math.round(this.height);
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pWidth = stack.mallocInt(1);
                IntBuffer pHeight = stack.mallocInt(1);
                IntBuffer x = stack.mallocInt(1);
                IntBuffer y = stack.mallocInt(1);
                IntBuffer cwx = stack.mallocInt(1);
                IntBuffer cwy = stack.mallocInt(1);
                GLFW.glfwGetWindowPos(this.window, cwx, cwy);
                this.beforeBorderLessX = cwx.get(0);
                this.beforeBorderLessY = cwy.get(0);
                this.Border(false);
                IntBuffer mpx = stack.mallocInt(1);
                IntBuffer mpy = stack.mallocInt(1);
                GLFW.glfwGetMonitorPos(this.currentMonitor, mpx, mpy);
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode(this.currentMonitor);
                GLFW.glfwSetWindowPos(this.window, (vidmode.width() - pWidth.get(0)) / 2 + mpx.get(0), (vidmode.height() - pHeight.get(0)) / 2 + mpy.get(0));
                this.SetWindowSize(vidmode.width(), vidmode.height());
            }
        }
        if (this.beforeBorderLessWidth == 0 || this.beforeBorderLessHeight == 0) {
            this.beforeBorderLessWidth = 960;
            this.beforeBorderLessHeight = 540;
        }
        GLFW.glfwSetWindowMonitor(this.window, 0L, 0, 0, this.beforeBorderLessWidth, this.beforeBorderLessHeight, -1);
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.window, pWidth, pHeight);
            this.Border(true);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(this.currentMonitor);
            GLFW.glfwSetWindowPos(this.window, this.beforeBorderLessX, this.beforeBorderLessY);
        }
    }

    public boolean InFullScreen() {
        return this.inFullscreen;
    }

    public boolean InBorderLess() {
        return this.inBorderLess;
    }

    public boolean NotWindowed() {
        return this.inBorderLess || this.inFullscreen;
    }

    public boolean IsHidden() {
        return this.isWindowHidden;
    }

    public void Show() {
        this.showEvent = true;
    }

    public void Hide() {
        this.hideEvent = true;
    }

    public void SetWindowSize(int w, int h) {
        this.resizeWindow = true;
        this.width = w;
        this.height = h;
    }

    public void SetPosition(int x, int y) {
        GLFW.glfwSetWindowPos(this.window, x, y);
    }

    public Vector2 Position() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowPos(this.window, pWidth, pHeight);
            int cx = pWidth.get(0);
            int cy = pHeight.get(0);
            Vector2 vector2 = new Vector2(cx, cy);
            return vector2;
        }
    }

    public void Border(boolean on) {
        if (on) {
            GLFW.glfwSetWindowAttrib(this.window, 131077, 1);
            this.frameBorder = true;
        } else {
            GLFW.glfwSetWindowAttrib(this.window, 131077, 0);
            this.frameBorder = false;
        }
    }

    public boolean Border() {
        return this.frameBorder;
    }

    public void SetResizable(boolean val) {
        GLFW.glfwSetWindowAttrib(this.window, 131075, val ? 1 : 0);
    }

    public boolean Resizable() {
        return this.resizable;
    }

    public boolean WantsToClose() {
        return this.windowWantsToClose;
    }

    public void Refresh() {
        this.lastWidth = 1;
        this.lastHeight = 1;
        this.UpdateCanvas();
    }

    public static void SetDockIcon(String path) throws IOException {
        Taskbar taskbar;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        System.out.println((String)path);
        BufferedImage newIcon = ImageIO.read(Lotus.class.getResource((String)path));
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
            taskbar.setIconImage(newIcon);
        }
    }

    public void SetIcon(String path) throws Exception {
        this.iconPath = path;
        IntBuffer w = MemoryUtil.memAllocInt(1);
        IntBuffer h = MemoryUtil.memAllocInt(1);
        IntBuffer comp = MemoryUtil.memAllocInt(1);
        ByteBuffer icon16 = null;
        ByteBuffer icon32 = null;
        try {
            icon16 = this.ioResourceToByteBuffer(path, 2048);
            icon32 = this.ioResourceToByteBuffer(path, 4096);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try (GLFWImage.Buffer icons = GLFWImage.malloc(2);){
            ByteBuffer pixels16 = STBImage.stbi_load_from_memory(icon16, w, h, comp, 4);
            ((GLFWImage.Buffer)icons.position(0)).width(w.get(0)).height(h.get(0)).pixels(pixels16);
            ByteBuffer pixels32 = STBImage.stbi_load_from_memory(icon32, w, h, comp, 4);
            ((GLFWImage.Buffer)icons.position(1)).width(w.get(0)).height(h.get(0)).pixels(pixels32);
            icons.position(0);
            GLFW.glfwSetWindowIcon(this.window, icons);
            STBImage.stbi_image_free(pixels32);
            STBImage.stbi_image_free(pixels16);
        }
        MemoryUtil.memFree(comp);
        MemoryUtil.memFree(h);
        MemoryUtil.memFree(w);
    }

    ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        Path path = Paths.get(resource, new String[0]);
        if (Files.isReadable(path)) {
            try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                buffer = BufferUtils.createByteBuffer((int)fc.size() + 1);
                while (fc.read(buffer) != -1) {
                }
            }
        }
        try (InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
             ReadableByteChannel rbc = Channels.newChannel(source);){
            int bytes;
            buffer = BufferUtils.createByteBuffer(bufferSize);
            while ((bytes = rbc.read(buffer)) != -1) {
                if (buffer.remaining() != 0) continue;
                buffer = BufferUtilities.resizeBuffer(buffer, buffer.capacity() * 2);
            }
        }
        buffer.flip();
        return buffer;
    }

    public void CleanUp() {
        Callbacks.glfwFreeCallbacks(this.window);
        GLFW.glfwDestroyWindow(this.window);
    }

    public boolean RenderedOnLastCycle() {
        return this.renderedOnLastCycle;
    }

    public double GetCursorPosX(long windowID) {
        DoubleBuffer posX = BufferUtils.createDoubleBuffer(1);
        GLFW.glfwGetCursorPos(windowID, posX, null);
        return posX.get(0);
    }

    public double GetCursorPosY(long windowID) {
        DoubleBuffer posY = BufferUtils.createDoubleBuffer(1);
        GLFW.glfwGetCursorPos(windowID, null, posY);
        return posY.get(0);
    }

    private void CalculateFPS() {
        if (this.frameTime > 0L) {
            this.FPS = Math.round(1000.0f / ((float)this.frameTime / 1000000.0f));
        }
        if (this.FPS > this._FPS_HIGH) {
            this._FPS_HIGH = this.FPS;
        }
        if (this.FPS < this._FPS_LOW) {
            this._FPS_LOW = this.FPS;
        }
        this.loopStartTime = GLFW.glfwGetTime();
        double currentTime = GLFW.glfwGetTime();
        ++this.frameCount;
        if (currentTime - this.previousTime >= 1.0) {
            this.FPS_AVERAGE = this.frameCount;
            this.FPS_HIGH = this._FPS_HIGH;
            this.FPS_LOW = this._FPS_LOW;
            this._FPS_LOW = 1.0E7f;
            this._FPS_HIGH = 0.0f;
            this.frameCount = 0;
            this.previousTime = currentTime;
        }
    }

    private void CanvasTick() {
    }

    public void Minimize() {
        GLFW.glfwIconifyWindow(this.window);
    }

    public void Maximize() {
        this.maximized = true;
        GLFW.glfwMaximizeWindow(this.window);
    }

    public boolean Maximized() {
        return this.maximized;
    }

    public void RestoreWindow() {
        this.maximized = false;
        GLFW.glfwRestoreWindow(this.window);
    }

    public void ShouldClose(boolean val) {
        GLFW.glfwSetWindowShouldClose(this.window, val);
    }

    void UpdateCanvas() {
        this.resetCanvas = false;
        this.fwidth = Math.round((float)this.viewPortWidth * this.renderPercentage);
        this.fheight = Math.round((float)this.height / (float)this.width * (float)this.viewPortWidth);
        this.canvasSize.Set(this.fwidth, this.fheight);
        this.ResizeFBOs();
    }

    public int MultisampledFbo() {
        return this.multisampledFbo;
    }

    void CreateFBOs() {
        this.multisampledColorRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledDepthRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.multisampledFbo);
        GL30.glBindRenderbuffer(36161, this.multisampledColorRenderBuffer);
        GL30.glRenderbufferStorageMultisample(36161, this.samples, 32856, this.fwidth, this.fheight);
        GL30.glFramebufferRenderbuffer(36160, 36064, 36161, this.multisampledColorRenderBuffer);
        GL30.glBindRenderbuffer(36161, this.multisampledDepthRenderBuffer);
        GL30.glRenderbufferStorageMultisample(36161, this.samples, 35056, this.fwidth, this.fheight);
        GL30.glFramebufferRenderbuffer(36160, 36096, 36161, this.multisampledDepthRenderBuffer);
        int fboStatus = GL30.glCheckFramebufferStatus(36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer(36161, 0);
        GL30.glBindFramebuffer(36160, 0);
        this.colorTexture = GL11.glGenTextures();
        this.fbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.fbo);
        GL11.glBindTexture(3553, this.colorTexture);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 32856, this.fwidth, this.fheight, 0, 6408, 5121, (ByteBuffer)null);
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexture, 0);
        fboStatus = GL30.glCheckFramebufferStatus(36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer(36161, 0);
        GL30.glBindFramebuffer(36160, 0);
    }

    void ResizeFBOs() {
        GL30.glDeleteRenderbuffers(this.multisampledDepthRenderBuffer);
        GL30.glDeleteRenderbuffers(this.multisampledColorRenderBuffer);
        GL30.glDeleteFramebuffers(this.multisampledFbo);
        GL11.glDeleteTextures(this.colorTexture);
        GL30.glDeleteFramebuffers(this.fbo);
        this.CreateFBOs();
    }

    public float ContentScale() {
        return this.contentScale;
    }

    public TextureEngine TextureEngine() {
        return this.textureEngine;
    }

    public AudioManager AudioManager() {
        return this.audioManager;
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public void SetCanvasSize(Vector2 size) {
        this.canvasSize.Set(size.x(), size.y());
    }

    public boolean SizeChanged() {
        return this.windowSizeChanged || this.scaleChanged;
    }

    public float CanvasWidth() {
        return (float)this.canvasSize.x();
    }

    public float CanvasHeight() {
        return (float)this.canvasSize.y();
    }

    public float FrameWidth() {
        return this.fwidth;
    }

    public float FrameHeight() {
        return this.fheight;
    }

    public KeyboardInput KeyboardInput() {
        return this.kbi;
    }

    public ControllerManager ControllerManager() {
        return this.controllerManager;
    }

    public KeyboardTextInput KeyboardTextInput() {
        return this.kbti;
    }

    public Vector2 Translate() {
        return this.translate;
    }

    public Vector2 RenderOffset() {
        return this.renderOffset;
    }

    public Time Time() {
        return this.time;
    }

    public Lotus Lotus() {
        return this.lotusInstance;
    }

    public int ParentProcessID() {
        return this.parentProcessID;
    }

    public void SetRenderUnitScale(float val) {
        this.renderUnitScale = val;
    }

    public float RawRenderUnitScale() {
        return this.renderUnitScale;
    }

    public float RenderScale() {
        return this.renderUnitScale * this.contentScale;
    }

    public void SetRenderPercentage(float val) {
        this.renderPercentage = val;
        this.resetCanvas = true;
    }

    public float RenderPercentage() {
        return this.renderPercentage;
    }

    public String IconPath() {
        return this.iconPath;
    }

    public long Monitor() {
        return this.currentMonitor;
    }

    public void SetTheme(WindowTheme theme) {
        if (this.inited) {
            this.setTheme = theme;
        } else {
            System.err.println("You may not apply a theme until the window has initialized");
        }
    }

    public WindowTheme GetTheme() {
        return this.theme;
    }

    public boolean ThemeChanged() {
        return this.themeChanged;
    }

    public void Vsync(boolean val) {
        this.vsyncState = val;
    }

    public boolean VsyncState() {
        return this.vsyncState;
    }

    public void LimitFPS(int FPS) {
        this.renderFPS = FPS;
    }

    public void IdleFps(int FPS) {
        this.idleFPS = FPS;
    }

    public float FPS() {
        return this.FPS;
    }

    public float FPS_LOW() {
        return this.FPS_LOW;
    }

    public float FPS_HIGH() {
        return this.FPS_HIGH;
    }

    public float FPS_AVERAGE() {
        return this.FPS_AVERAGE;
    }

    public Mouse Mouse() {
        return this.mouse;
    }
}

