/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.window.diologs;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.StandardWindowTheme;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import java.lang.reflect.InvocationTargetException;

public class Diolog3ButtonBox
extends Process {
    private Window window;
    private WindowTheme theme = null;
    private String title = "";
    private String message = "";
    private ElementRenderer elm;
    private String buttonText1 = "Yes";
    private String buttonText2 = "No";
    private String buttonText3 = "Cancel";
    private Button button1;
    private Button button2;
    private Button button3;
    private String image = "";

    public Diolog3ButtonBox(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public Diolog3ButtonBox(String title, String message, String buttonText1, String buttonText2, String buttonText3) {
        this.title = title;
        this.message = message;
        this.buttonText1 = buttonText1;
        this.buttonText2 = buttonText2;
        this.buttonText3 = buttonText3;
    }

    public Diolog3ButtonBox(String title, String message, String texture, WindowTheme theme) {
        this.title = title;
        this.message = message;
        this.image = texture;
        this.theme = theme;
    }

    public Diolog3ButtonBox(String title, String message, String texture, WindowTheme theme, String buttonText1, String buttonText2, String buttonText3) {
        this.title = title;
        this.message = message;
        this.image = texture;
        this.theme = theme;
        this.buttonText1 = buttonText1;
        this.buttonText2 = buttonText2;
        this.buttonText3 = buttonText3;
    }

    @Override
    public void Start() {
        this.window = Lotus.singleton.WindowManager().GetWindow(Lotus.singleton.WindowManager().CreateWindow(this.title, 600, 150, this.ID()));
        this.window.Init();
        this.window.Process();
        this.window.Render(true);
        this.processReturn = 0;
        Element.CreateWindowParms();
        if (this.theme == null) {
            this.theme = new StandardWindowTheme(this.window);
        }
        try {
            this.window.SetTheme((WindowTheme)this.theme.getClass().getDeclaredConstructor(Window.class).newInstance(this.window));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.window.SetResizable(false);
        this.elm = new ElementRenderer();
        this.CreateElements();
        this.CreatePage();
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.Process();
        if (this.window.SizeChanged() || this.window.ThemeChanged()) {
            this.CreateElements();
            this.CreatePage();
        }
        this.elm.Update();
        this.elm.Interact();
        if (this.elm.HasChanged() || this.window.RenderedOnLastCycle()) {
            this.elm.Render();
        }
        if (this.button1.Clicked()) {
            this.processReturn = 1;
            this.QuitProcess();
        }
        if (this.button2.Clicked()) {
            this.processReturn = 2;
            this.QuitProcess();
        }
        if (this.button3.Clicked()) {
            this.processReturn = 0;
            this.QuitProcess();
        }
        this.window.Render(this.elm.HasChanged());
        if (this.window.WantsToClose()) {
            this.processReturn = 0;
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.window.CleanUp();
    }

    public void CreateElements() {
        this.button1 = Element.Button();
        this.button2 = Element.Button();
        this.button3 = Element.Button();
    }

    public void CreatePage() {
        this.elm.ClearCycle();
        float padding = 20.0f * this.window.RenderScale();
        float buttonWidth = 100.0f * this.window.RenderScale();
        float buttonHeight = 25.0f * this.window.RenderScale();
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().Background()));
        this.button3.Set(this.buttonText3, this.window.CanvasWidth() / 2.0f - padding - buttonWidth / 2.0f, -this.window.CanvasHeight() / 2.0f + padding + buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.elm.AddElement(this.button3);
        this.button2.Set(this.buttonText2, this.window.CanvasWidth() / 2.0f - padding - buttonWidth / 2.0f - buttonWidth - buttonWidth / 6.0f, -this.window.CanvasHeight() / 2.0f + padding + buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.elm.AddElement(this.button2);
        this.button1.Set(this.buttonText1, this.window.CanvasWidth() / 2.0f - padding - buttonWidth / 2.0f - buttonWidth - buttonWidth / 6.0f - buttonWidth - buttonWidth / 6.0f, -this.window.CanvasHeight() / 2.0f + padding + buttonHeight / 2.0f, buttonWidth, buttonHeight);
        this.elm.AddElement(this.button1);
        float iconSize = 50.0f * this.window.RenderScale();
        padding = 40.0f * this.window.RenderScale();
        float fontSize = iconSize / 3.0f;
        float xIndex = -this.window.CanvasWidth() / 2.0f + padding;
        float yIndex = 0.0f;
        Text text = new Text(this.message);
        text.MaxWidth(this.window.CanvasWidth() - padding * 2.0f);
        if (!this.image.equals("")) {
            this.elm.AddElement(new Image(this.image, xIndex += iconSize / 2.0f, yIndex, iconSize, iconSize, 0.0f, 255, true));
            text.MaxWidth(this.window.CanvasWidth() - padding * 2.0f - iconSize - padding * 2.0f);
            xIndex += iconSize / 2.0f + iconSize / 8.0f;
        }
        text.SetSpaceWidth(0.5f);
        text.TabSize(6);
        text.Align(0, 0);
        text.SetFont(this.window.GetTheme().Font());
        text.SetSpaceWidth(0.5f);
        text.FontSize(fontSize);
        text.Calculate();
        if (text.Height() > this.window.CanvasHeight() - buttonHeight * 2.0f) {
            this.window.SetWindowSize((int)this.window.Width(), (int)(this.window.Height() + (text.Height() - (this.window.CanvasHeight() - buttonHeight * 2.0f))));
        }
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex += text.Height() / 2.0f));
    }
}

