/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.tablebases.containers;

import com.arizotaz.tablebases.containers.Cell;
import com.arizotaz.tablebases.containers.Row;

public class Table {
    private String name;
    private Cell[] headers;
    private Row[] rows;
    private int usedsize = 0;
    private int[] sizes;
    private String topleft = "|";
    private String topright = "|";
    private String botleft = "|";
    private String botright = "|";
    private String vwall = "|";
    private String hwall = "-";
    private String inter = "+";
    private String intertop = "-";
    private String interbottom = "-";
    private String interleft = "|";
    private String interright = "|";

    public Table(String name) {
        this.name = name;
        this.rows = new Row[this.usedsize];
    }

    public void SetHeaders(String[] data) {
        Cell[] cells = new Cell[data.length];
        int i = 0;
        while (i < cells.length) {
            cells[i] = new Cell(data[i]);
            ++i;
        }
        this.headers = cells;
    }

    public Cell GetHeaderObject(int i) {
        return this.headers[i];
    }

    public String[] GetHeaders() {
        String[] headers = new String[this.headers.length];
        int i = 0;
        while (i < headers.length) {
            headers[i] = this.headers.toString();
            ++i;
        }
        return headers;
    }

    public long AddRow(Cell[] cells) {
        return this.AddRow(this.usedsize, cells);
    }

    public long AddRow(int index, Cell[] cells) {
        Row r;
        long time = System.nanoTime();
        if (++this.usedsize >= this.rows.length) {
            this.ResizeRows(this.rows.length + 2);
        }
        int i = this.usedsize - 1;
        while (i >= index + 1) {
            this.rows[i] = this.rows[i - 1];
            --i;
        }
        this.rows[index] = r = new Row(cells, this);
        time = System.nanoTime() - time;
        return time;
    }

    public int Rows() {
        return this.usedsize;
    }

    private void ResizeRows(int newSize) {
        Row[] nrows = new Row[newSize];
        int i = 0;
        while (i < this.rows.length) {
            nrows[i] = this.rows[i];
            ++i;
        }
        this.rows = nrows;
    }

    public Row GetRow(int i) {
        return this.rows[i];
    }

    public int GetHeaderIndex(String columnName) {
        int index = -1;
        int i = 0;
        while (i < this.headers.length) {
            if (this.headers[i].toString().equals(columnName)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public String Name() {
        return this.name;
    }

    public int[] ColumnSizes() {
        return this.sizes;
    }

    public void AutoSizeColumn(int index) {
        this.SetColumnSize(index, -1);
    }

    public void SetColumnSize(int[] sizes) {
        int i = 0;
        while (i < sizes.length) {
            this.SetColumnSize(i, sizes[i]);
            ++i;
        }
    }

    public void SetColumnSize(int index, int value) {
        if (this.sizes == null || index >= this.sizes.length) {
            int[] sizes = new int[index + 1];
            int i = 0;
            while (i < sizes.length) {
                sizes[i] = 0;
                ++i;
            }
            if (this.sizes != null) {
                i = 0;
                while (i < this.sizes.length) {
                    sizes[i] = this.sizes[i];
                    ++i;
                }
            }
            this.sizes = sizes;
        }
        this.sizes[index] = value;
    }

    public void SetCoolCharacters() {
        this.topleft = "\u2554";
        this.topright = "\u2557";
        this.botleft = "\u255a";
        this.botright = "\u255d";
        this.vwall = "\u2551";
        this.hwall = "\u2550";
        this.inter = "\u256c";
        this.intertop = "\u2566";
        this.interbottom = "\u2569";
        this.interleft = "\u2560";
        this.interright = "\u2563";
    }

    public String Print(int width) {
        return this.Print(width, -1);
    }

    public String Print(int width, int mshow) {
        String data = "";
        int sizePerBox = width - 1;
        width = (sizePerBox /= this.headers.length) * this.headers.length;
        data = String.valueOf(data) + this.PrintHeaders(++width);
        int max = this.rows.length;
        if (mshow >= 0 && max > mshow) {
            max = mshow;
        }
        int i = 0;
        while (i < max) {
            data = String.valueOf(data) + this.PrintLineData(this.rows[i], width);
            data = String.valueOf(data) + this.PrintLineType(this.rows[i], width);
            data = String.valueOf(data) + this.interleft;
            int j = 1;
            while (j < width - 1) {
                data = j % sizePerBox == 0 ? String.valueOf(data) + this.inter : String.valueOf(data) + this.hwall;
                ++j;
            }
            data = String.valueOf(data) + this.interright;
            data = String.valueOf(data) + "\n";
            ++i;
        }
        data = String.valueOf(data) + this.PrintFooter(width);
        return data;
    }

    private String PrintFooter(int width) {
        String data = "";
        int sizePerBox = width - 1;
        sizePerBox /= this.headers.length;
        sizePerBox = sizePerBox - 2 - 1;
        String title = this.botleft;
        data = String.valueOf(data) + title;
        int i = title.length();
        while (i < width - 1) {
            data = i % (sizePerBox + 2 + 1) == 0 ? String.valueOf(data) + this.interbottom : String.valueOf(data) + this.hwall;
            ++i;
        }
        data = String.valueOf(data) + this.botright + "\n";
        return data;
    }

    private String PrintHeaders(int width) {
        String data = "";
        int sizePerBox = width - 1;
        sizePerBox /= this.headers.length;
        sizePerBox = sizePerBox - 2 - 1;
        String title = String.valueOf(this.topleft) + this.hwall + "[ " + this.name + " ]";
        data = String.valueOf(data) + title;
        int i = title.length();
        while (i < width - 1) {
            data = i % (sizePerBox + 2 + 1) == 0 ? String.valueOf(data) + this.intertop : String.valueOf(data) + this.hwall;
            ++i;
        }
        data = String.valueOf(data) + this.topright + "\n";
        data = String.valueOf(data) + this.vwall;
        i = 0;
        while (i < this.headers.length) {
            data = String.valueOf(data) + " ";
            String header = this.headers[i].toString();
            int extraSpace = sizePerBox - header.length();
            if (extraSpace < 0) {
                extraSpace = 0;
            }
            header = header.substring(0, sizePerBox - extraSpace);
            data = String.valueOf(data) + header;
            int s = 0;
            while (s < extraSpace) {
                data = String.valueOf(data) + " ";
                ++s;
            }
            data = String.valueOf(data) + " ";
            data = String.valueOf(data) + this.vwall;
            ++i;
        }
        data = String.valueOf(data) + "\n";
        data = String.valueOf(data) + this.interleft;
        i = 1;
        while (i < width - 1) {
            data = i % (sizePerBox + 2 + 1) == 0 ? String.valueOf(data) + this.inter : String.valueOf(data) + this.hwall;
            ++i;
        }
        data = String.valueOf(data) + this.interright;
        data = String.valueOf(data) + "\n";
        return data;
    }

    private String PrintLineData(Row row, int width) {
        String data = "";
        data = String.valueOf(data) + this.vwall;
        int sizePerBox = width - 1;
        sizePerBox /= this.headers.length;
        sizePerBox = sizePerBox - 2 - 1;
        if (row == null) {
            int i = 0;
            while (i < width - 2) {
                data = String.valueOf(data) + " ";
                ++i;
            }
            data = String.valueOf(data) + this.vwall;
            data = String.valueOf(data) + "\n";
            return data;
        }
        int i = 0;
        while (i < row.Size()) {
            data = String.valueOf(data) + " ";
            String header = row.GetColumn(i).toString();
            int extraSpace = sizePerBox - header.length();
            if (extraSpace < 0) {
                extraSpace = 0;
            }
            header = header.substring(0, sizePerBox - extraSpace);
            data = String.valueOf(data) + header;
            int s = 0;
            while (s < extraSpace) {
                data = String.valueOf(data) + " ";
                ++s;
            }
            data = String.valueOf(data) + " ";
            data = String.valueOf(data) + this.vwall;
            ++i;
        }
        data = String.valueOf(data) + "\n";
        return data;
    }

    private String PrintLineType(Row row, int width) {
        String data = "";
        data = String.valueOf(data) + this.vwall;
        int sizePerBox = width - 1;
        sizePerBox /= this.headers.length;
        sizePerBox = sizePerBox - 2 - 1;
        if (row == null) {
            int i = 0;
            while (i < width - 2) {
                data = String.valueOf(data) + " ";
                ++i;
            }
            data = String.valueOf(data) + this.vwall;
            data = String.valueOf(data) + "\n";
            return data;
        }
        int i = 0;
        while (i < row.Size()) {
            data = String.valueOf(data) + " ";
            String header = row.GetColumn(i).TypeString();
            int extraSpace = sizePerBox - header.length();
            if (extraSpace < 0) {
                extraSpace = 0;
            }
            header = header.substring(0, sizePerBox - extraSpace);
            data = String.valueOf(data) + header;
            int s = 0;
            while (s < extraSpace) {
                data = String.valueOf(data) + " ";
                ++s;
            }
            data = String.valueOf(data) + " ";
            data = String.valueOf(data) + this.vwall;
            ++i;
        }
        data = String.valueOf(data) + "\n";
        return data;
    }
}

