/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.tablebases.processors;

import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.tablebases.containers.Cell;
import com.arizotaz.tablebases.containers.DataBase;
import com.arizotaz.tablebases.containers.Row;
import com.arizotaz.tablebases.containers.Table;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSXWriter {
    private DataBase database;
    private File save;
    private HashMap<String, CellStyle> styles;
    private XSSFWorkbook workbook;

    public XLSXWriter(DataBase database, File file) {
        this.database = database;
        this.save = file;
    }

    public void Write() throws IOException {
        this.styles = new HashMap();
        this.workbook = new XSSFWorkbook();
        int t = 0;
        while (t < this.database.Size()) {
            Table table = this.database.GetTable(t);
            XSSFSheet sheet = this.workbook.createSheet(table.Name());
            XSSFRow excelRow = sheet.createRow(0);
            int i = 0;
            while (i < table.GetHeaders().length) {
                org.apache.poi.ss.usermodel.Cell excelcell = excelRow.createCell(i);
                Cell cell = table.GetHeaderObject(i);
                this.CreateCell(cell, excelcell);
                ++i;
            }
            int r = 1;
            while (r < table.Rows()) {
                Row row = table.GetRow(r);
                XSSFRow excelRow2 = sheet.createRow(r);
                int i2 = 0;
                while (i2 < row.Size()) {
                    org.apache.poi.ss.usermodel.Cell excelcell = excelRow2.createCell(i2);
                    Cell cell = row.GetColumn(i2);
                    this.CreateCell(cell, excelcell);
                    ++i2;
                }
                ++r;
            }
            this.SetSheetOptions(table, sheet);
            ++t;
        }
        FileOutputStream out = new FileOutputStream(this.save);
        this.workbook.write((OutputStream)out);
        out.close();
    }

    private void SetSheetOptions(Table table, XSSFSheet sheet) {
        if (table.ColumnSizes() != null) {
            int i = 0;
            while (i < table.ColumnSizes().length) {
                int s = table.ColumnSizes()[i];
                if (s < 0) {
                    sheet.autoSizeColumn(i);
                }
                if (s > 0) {
                    sheet.setColumnWidth(i, s * 256);
                }
                ++i;
            }
        }
    }

    private void CreateCell(Cell cell, org.apache.poi.ss.usermodel.Cell excelcell) {
        if (cell.GetType() == 0) {
            excelcell.setCellValue(cell.toString());
        }
        if (cell.GetType() == 6) {
            excelcell.setCellValue((double)((Long)cell.GetData()).longValue());
        }
        if (cell.GetType() == 3) {
            excelcell.setCellValue((double)((Float)cell.GetData()).floatValue());
        }
        if (cell.GetType() == 4) {
            excelcell.setCellValue(((Double)cell.GetData()).doubleValue());
        }
        if (cell.GetType() == 1) {
            excelcell.setCellValue(cell.toString());
        }
        if (cell.GetType() == 5) {
            excelcell.setCellValue((double)((Integer)cell.GetData()).intValue());
        }
        if (cell.GetType() == 2) {
            excelcell.setCellValue(((Boolean)cell.GetData()).booleanValue());
        }
        if (cell.TextColor() != null || cell.BackgoundColor() != null || cell.Border() != null) {
            String key = String.valueOf(this.ColorToString(cell.TextColor())) + "-" + this.ColorToString(cell.BackgoundColor());
            if (cell.Border() != null) {
                int i = 0;
                while (i < cell.Border().length) {
                    key = String.valueOf(key) + cell.Border()[i];
                    ++i;
                }
            }
            if (!this.styles.containsKey(key)) {
                this.CreateStyle(key, cell);
            }
            excelcell.setCellStyle(this.styles.get(key));
        }
    }

    private void CreateStyle(String key, Cell cell) {
        XSSFColor c;
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        if (cell.TextColor() != null) {
            c = new XSSFColor(new Color(cell.TextColor().IntX(), cell.TextColor().IntY(), cell.TextColor().IntZ()), null);
            font.setColor(c);
        }
        if (cell.BackgoundColor() != null) {
            c = new XSSFColor(new Color(cell.BackgoundColor().IntX(), cell.BackgoundColor().IntY(), cell.BackgoundColor().IntZ()), null);
            style.setFillForegroundColor(c);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        style = this.SetBorder(style, cell);
        style.setFont((Font)font);
        this.styles.put(key, (CellStyle)style);
    }

    private XSSFCellStyle SetBorder(XSSFCellStyle style, Cell cell) {
        if (cell.Border() == null || cell.Border().length < 7) {
            return style;
        }
        XSSFColor c = new XSSFColor(new Color(cell.Border()[4], cell.Border()[5], cell.Border()[6]), null);
        style.setLeftBorderColor(c);
        style.setBorderLeft(this.GetBorderStyle(cell.Border()[0]));
        c = new XSSFColor(new Color(cell.Border()[4], cell.Border()[5], cell.Border()[6]), null);
        style.setRightBorderColor(c);
        style.setBorderRight(this.GetBorderStyle(cell.Border()[0]));
        c = new XSSFColor(new Color(cell.Border()[4], cell.Border()[5], cell.Border()[6]), null);
        style.setTopBorderColor(c);
        style.setBorderTop(this.GetBorderStyle(cell.Border()[0]));
        c = new XSSFColor(new Color(cell.Border()[4], cell.Border()[5], cell.Border()[6]), null);
        style.setBottomBorderColor(c);
        style.setBorderBottom(this.GetBorderStyle(cell.Border()[0]));
        return style;
    }

    private BorderStyle GetBorderStyle(int type) {
        switch (type) {
            case 1: {
                return BorderStyle.THIN;
            }
            case 2: {
                return BorderStyle.DOTTED;
            }
            case 3: {
                return BorderStyle.MEDIUM;
            }
            case 4: {
                return BorderStyle.DASHED;
            }
            case 5: {
                return BorderStyle.THICK;
            }
        }
        return BorderStyle.NONE;
    }

    private String ColorToString(Vector3 color) {
        if (color == null) {
            return "default";
        }
        return String.valueOf(color.IntX()) + "_" + color.IntY() + "_" + color.IntZ();
    }
}

