/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;

public class Streams {
    public static BufferedInputStream bufferedInputStream(InputStream is) {
        return new BufferedInputStream(is, 65536);
    }

    public static BufferedOutputStream bufferedOutputStream(OutputStream os) {
        return new BufferedOutputStream(os, 65536);
    }

    public static byte[] cacheBuffer() {
        return new byte[8192];
    }

    public static FileInputStream fileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static FileInputStream fileInputStream(File file, String operation) throws ArchiverException {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new ArchiverException("Problem reading input file for " + operation + " " + file.getParent() + ", " + e.getMessage());
        }
    }

    public static FileOutputStream fileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public static FileOutputStream fileOutputStream(File file, String operation) throws ArchiverException {
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new ArchiverException("Problem creating output file for " + operation + " " + file.getParent() + ", " + e.getMessage());
        }
    }

    public static void copyFully(@WillClose InputStream zIn, @WillClose OutputStream out, String gzip) throws ArchiverException {
        try {
            Streams.copyFullyDontCloseOutput(zIn, out, gzip);
            out.close();
            out = null;
        }
        catch (IOException e) {
            throw new ArchiverException("Failure copying.", e);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static void copyFullyDontCloseOutput(@WillClose InputStream zIn, @WillNotClose OutputStream out, String gzip) throws ArchiverException {
        try {
            byte[] buffer = Streams.cacheBuffer();
            int count = 0;
            do {
                try {
                    out.write(buffer, 0, count);
                }
                catch (IOException e) {
                    throw new ArchiverException("Problem writing to output in " + gzip + " operation " + e.getMessage());
                }
            } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            zIn.close();
            zIn = null;
        }
        catch (IOException e) {
            throw new ArchiverException("Problem reading from source file in " + gzip + " operation " + e.getMessage());
        }
        finally {
            IOUtil.close(zIn);
        }
    }
}

