/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFace")
public class AIFace
extends Struct<AIFace>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNUMINDICES;
    public static final int MINDICES;

    protected AIFace(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIFace create(long address, @Nullable ByteBuffer container) {
        return new AIFace(address, container);
    }

    public AIFace(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIFace.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int mNumIndices() {
        return AIFace.nmNumIndices(this.address());
    }

    @NativeType(value="unsigned int *")
    public IntBuffer mIndices() {
        return AIFace.nmIndices(this.address());
    }

    public AIFace mIndices(@NativeType(value="unsigned int *") IntBuffer value) {
        AIFace.nmIndices(this.address(), value);
        return this;
    }

    public AIFace set(AIFace src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIFace malloc() {
        return new AIFace(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIFace calloc() {
        return new AIFace(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIFace create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIFace(MemoryUtil.memAddress(container), container);
    }

    public static AIFace create(long address) {
        return new AIFace(address, null);
    }

    public static @Nullable AIFace createSafe(long address) {
        return address == 0L ? null : new AIFace(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIFace.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIFace.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIFace mallocStack() {
        return AIFace.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFace callocStack() {
        return AIFace.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFace mallocStack(MemoryStack stack) {
        return AIFace.malloc(stack);
    }

    @Deprecated
    public static AIFace callocStack(MemoryStack stack) {
        return AIFace.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIFace.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIFace.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFace.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFace.calloc(capacity, stack);
    }

    public static AIFace malloc(MemoryStack stack) {
        return new AIFace(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIFace calloc(MemoryStack stack) {
        return new AIFace(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmNumIndices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMINDICES);
    }

    public static IntBuffer nmIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)MINDICES), AIFace.nmNumIndices(struct));
    }

    public static void nmNumIndices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMINDICES, value);
    }

    public static void nmIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MINDICES, MemoryUtil.memAddress(value));
        AIFace.nmNumIndices(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MINDICES));
    }

    static {
        Struct.Layout layout = AIFace.__struct(AIFace.__member(4), AIFace.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNUMINDICES = layout.offsetof(0);
        MINDICES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIFace, Buffer>
    implements NativeResource {
        private static final AIFace ELEMENT_FACTORY = AIFace.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected AIFace getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int mNumIndices() {
            return AIFace.nmNumIndices(this.address());
        }

        @NativeType(value="unsigned int *")
        public IntBuffer mIndices() {
            return AIFace.nmIndices(this.address());
        }

        public Buffer mIndices(@NativeType(value="unsigned int *") IntBuffer value) {
            AIFace.nmIndices(this.address(), value);
            return this;
        }
    }
}

