/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIFileCloseProc;
import org.lwjgl.assimp.AIFileCloseProcI;
import org.lwjgl.assimp.AIFileOpenProc;
import org.lwjgl.assimp.AIFileOpenProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiFileIO")
public class AIFileIO
extends Struct<AIFileIO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPENPROC;
    public static final int CLOSEPROC;
    public static final int USERDATA;

    protected AIFileIO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIFileIO create(long address, @Nullable ByteBuffer container) {
        return new AIFileIO(address, container);
    }

    public AIFileIO(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIFileIO.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiFileOpenProc")
    public AIFileOpenProc OpenProc() {
        return AIFileIO.nOpenProc(this.address());
    }

    @NativeType(value="aiFileCloseProc")
    public AIFileCloseProc CloseProc() {
        return AIFileIO.nCloseProc(this.address());
    }

    @NativeType(value="aiUserData")
    public long UserData() {
        return AIFileIO.nUserData(this.address());
    }

    public AIFileIO OpenProc(@NativeType(value="aiFileOpenProc") AIFileOpenProcI value) {
        AIFileIO.nOpenProc(this.address(), value);
        return this;
    }

    public AIFileIO CloseProc(@NativeType(value="aiFileCloseProc") AIFileCloseProcI value) {
        AIFileIO.nCloseProc(this.address(), value);
        return this;
    }

    public AIFileIO UserData(@NativeType(value="aiUserData") long value) {
        AIFileIO.nUserData(this.address(), value);
        return this;
    }

    public AIFileIO set(AIFileOpenProcI OpenProc, AIFileCloseProcI CloseProc, long UserData) {
        this.OpenProc(OpenProc);
        this.CloseProc(CloseProc);
        this.UserData(UserData);
        return this;
    }

    public AIFileIO set(AIFileIO src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIFileIO malloc() {
        return new AIFileIO(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIFileIO calloc() {
        return new AIFileIO(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIFileIO create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIFileIO(MemoryUtil.memAddress(container), container);
    }

    public static AIFileIO create(long address) {
        return new AIFileIO(address, null);
    }

    public static @Nullable AIFileIO createSafe(long address) {
        return address == 0L ? null : new AIFileIO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIFileIO.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIFileIO.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIFileIO mallocStack() {
        return AIFileIO.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFileIO callocStack() {
        return AIFileIO.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIFileIO mallocStack(MemoryStack stack) {
        return AIFileIO.malloc(stack);
    }

    @Deprecated
    public static AIFileIO callocStack(MemoryStack stack) {
        return AIFileIO.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIFileIO.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIFileIO.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFileIO.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFileIO.calloc(capacity, stack);
    }

    public static AIFileIO malloc(MemoryStack stack) {
        return new AIFileIO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIFileIO calloc(MemoryStack stack) {
        return new AIFileIO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIFileOpenProc nOpenProc(long struct) {
        return AIFileOpenProc.create(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
    }

    public static AIFileCloseProc nCloseProc(long struct) {
        return AIFileCloseProc.create(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static void nOpenProc(long struct, AIFileOpenProcI value) {
        MemoryUtil.memPutAddress(struct + (long)OPENPROC, value.address());
    }

    public static void nCloseProc(long struct, AIFileCloseProcI value) {
        MemoryUtil.memPutAddress(struct + (long)CLOSEPROC, value.address());
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)OPENPROC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CLOSEPROC));
    }

    static {
        Struct.Layout layout = AIFileIO.__struct(AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE), AIFileIO.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPENPROC = layout.offsetof(0);
        CLOSEPROC = layout.offsetof(1);
        USERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIFileIO, Buffer>
    implements NativeResource {
        private static final AIFileIO ELEMENT_FACTORY = AIFileIO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected AIFileIO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiFileOpenProc")
        public AIFileOpenProc OpenProc() {
            return AIFileIO.nOpenProc(this.address());
        }

        @NativeType(value="aiFileCloseProc")
        public AIFileCloseProc CloseProc() {
            return AIFileIO.nCloseProc(this.address());
        }

        @NativeType(value="aiUserData")
        public long UserData() {
            return AIFileIO.nUserData(this.address());
        }

        public Buffer OpenProc(@NativeType(value="aiFileOpenProc") AIFileOpenProcI value) {
            AIFileIO.nOpenProc(this.address(), value);
            return this;
        }

        public Buffer CloseProc(@NativeType(value="aiFileCloseProc") AIFileCloseProcI value) {
            AIFileIO.nCloseProc(this.address(), value);
            return this;
        }

        public Buffer UserData(@NativeType(value="aiUserData") long value) {
            AIFileIO.nUserData(this.address(), value);
            return this;
        }
    }
}

