/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMeshMorphKey;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshMorphAnim")
public class AIMeshMorphAnim
extends Struct<AIMeshMorphAnim>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMKEYS;
    public static final int MKEYS;

    protected AIMeshMorphAnim(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIMeshMorphAnim create(long address, @Nullable ByteBuffer container) {
        return new AIMeshMorphAnim(address, container);
    }

    public AIMeshMorphAnim(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMeshMorphAnim.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIMeshMorphAnim.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumKeys() {
        return AIMeshMorphAnim.nmNumKeys(this.address());
    }

    @NativeType(value="struct aiMeshMorphKey *")
    public AIMeshMorphKey.Buffer mKeys() {
        return AIMeshMorphAnim.nmKeys(this.address());
    }

    public AIMeshMorphAnim mName(@NativeType(value="struct aiString") AIString value) {
        AIMeshMorphAnim.nmName(this.address(), value);
        return this;
    }

    public AIMeshMorphAnim mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIMeshMorphAnim mKeys(@NativeType(value="struct aiMeshMorphKey *") AIMeshMorphKey.Buffer value) {
        AIMeshMorphAnim.nmKeys(this.address(), value);
        return this;
    }

    public AIMeshMorphAnim set(AIString mName, AIMeshMorphKey.Buffer mKeys) {
        this.mName(mName);
        this.mKeys(mKeys);
        return this;
    }

    public AIMeshMorphAnim set(AIMeshMorphAnim src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMeshMorphAnim malloc() {
        return new AIMeshMorphAnim(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIMeshMorphAnim calloc() {
        return new AIMeshMorphAnim(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIMeshMorphAnim create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIMeshMorphAnim(MemoryUtil.memAddress(container), container);
    }

    public static AIMeshMorphAnim create(long address) {
        return new AIMeshMorphAnim(address, null);
    }

    public static @Nullable AIMeshMorphAnim createSafe(long address) {
        return address == 0L ? null : new AIMeshMorphAnim(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIMeshMorphAnim.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshMorphAnim.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIMeshMorphAnim mallocStack() {
        return AIMeshMorphAnim.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMeshMorphAnim callocStack() {
        return AIMeshMorphAnim.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMeshMorphAnim mallocStack(MemoryStack stack) {
        return AIMeshMorphAnim.malloc(stack);
    }

    @Deprecated
    public static AIMeshMorphAnim callocStack(MemoryStack stack) {
        return AIMeshMorphAnim.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMeshMorphAnim.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMeshMorphAnim.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphAnim.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshMorphAnim.calloc(capacity, stack);
    }

    public static AIMeshMorphAnim malloc(MemoryStack stack) {
        return new AIMeshMorphAnim(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIMeshMorphAnim calloc(MemoryStack stack) {
        return new AIMeshMorphAnim(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumKeys(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMKEYS);
    }

    public static AIMeshMorphKey.Buffer nmKeys(long struct) {
        return AIMeshMorphKey.create(MemoryUtil.memGetAddress(struct + (long)MKEYS), AIMeshMorphAnim.nmNumKeys(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmNumKeys(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMKEYS, value);
    }

    public static void nmKeys(long struct, AIMeshMorphKey.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MKEYS, value.address());
        AIMeshMorphAnim.nmNumKeys(struct, value.remaining());
    }

    public static void validate(long struct) {
        int mNumKeys = AIMeshMorphAnim.nmNumKeys(struct);
        long mKeys = MemoryUtil.memGetAddress(struct + (long)MKEYS);
        Checks.check(mKeys);
        AIMeshMorphAnim.validate(mKeys, mNumKeys, AIMeshMorphKey.SIZEOF, AIMeshMorphKey::validate);
    }

    static {
        Struct.Layout layout = AIMeshMorphAnim.__struct(AIMeshMorphAnim.__member(AIString.SIZEOF, AIString.ALIGNOF), AIMeshMorphAnim.__member(4), AIMeshMorphAnim.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMKEYS = layout.offsetof(1);
        MKEYS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMeshMorphAnim, Buffer>
    implements NativeResource {
        private static final AIMeshMorphAnim ELEMENT_FACTORY = AIMeshMorphAnim.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected AIMeshMorphAnim getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIMeshMorphAnim.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumKeys() {
            return AIMeshMorphAnim.nmNumKeys(this.address());
        }

        @NativeType(value="struct aiMeshMorphKey *")
        public AIMeshMorphKey.Buffer mKeys() {
            return AIMeshMorphAnim.nmKeys(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIMeshMorphAnim.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mKeys(@NativeType(value="struct aiMeshMorphKey *") AIMeshMorphKey.Buffer value) {
            AIMeshMorphAnim.nmKeys(this.address(), value);
            return this;
        }
    }
}

