/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIQuaternion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiQuatKey")
public class AIQuatKey
extends Struct<AIQuatKey>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;
    public static final int MINTERPOLATION;

    protected AIQuatKey(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIQuatKey create(long address, @Nullable ByteBuffer container) {
        return new AIQuatKey(address, container);
    }

    public AIQuatKey(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIQuatKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIQuatKey.nmTime(this.address());
    }

    @NativeType(value="struct aiQuaternion")
    public AIQuaternion mValue() {
        return AIQuatKey.nmValue(this.address());
    }

    @NativeType(value="aiAnimInterpolation")
    public int mInterpolation() {
        return AIQuatKey.nmInterpolation(this.address());
    }

    public AIQuatKey mTime(double value) {
        AIQuatKey.nmTime(this.address(), value);
        return this;
    }

    public AIQuatKey mValue(@NativeType(value="struct aiQuaternion") AIQuaternion value) {
        AIQuatKey.nmValue(this.address(), value);
        return this;
    }

    public AIQuatKey mValue(Consumer<AIQuaternion> consumer) {
        consumer.accept(this.mValue());
        return this;
    }

    public AIQuatKey mInterpolation(@NativeType(value="aiAnimInterpolation") int value) {
        AIQuatKey.nmInterpolation(this.address(), value);
        return this;
    }

    public AIQuatKey set(double mTime, AIQuaternion mValue, int mInterpolation) {
        this.mTime(mTime);
        this.mValue(mValue);
        this.mInterpolation(mInterpolation);
        return this;
    }

    public AIQuatKey set(AIQuatKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIQuatKey malloc() {
        return new AIQuatKey(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIQuatKey calloc() {
        return new AIQuatKey(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIQuatKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIQuatKey(MemoryUtil.memAddress(container), container);
    }

    public static AIQuatKey create(long address) {
        return new AIQuatKey(address, null);
    }

    public static @Nullable AIQuatKey createSafe(long address) {
        return address == 0L ? null : new AIQuatKey(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIQuatKey.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIQuatKey.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIQuatKey mallocStack() {
        return AIQuatKey.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIQuatKey callocStack() {
        return AIQuatKey.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIQuatKey mallocStack(MemoryStack stack) {
        return AIQuatKey.malloc(stack);
    }

    @Deprecated
    public static AIQuatKey callocStack(MemoryStack stack) {
        return AIQuatKey.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIQuatKey.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIQuatKey.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIQuatKey.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIQuatKey.calloc(capacity, stack);
    }

    public static AIQuatKey malloc(MemoryStack stack) {
        return new AIQuatKey(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIQuatKey calloc(MemoryStack stack) {
        return new AIQuatKey(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTIME);
    }

    public static AIQuaternion nmValue(long struct) {
        return AIQuaternion.create(struct + (long)MVALUE);
    }

    public static int nmInterpolation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINTERPOLATION);
    }

    public static void nmTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, AIQuaternion value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MVALUE, AIQuaternion.SIZEOF);
    }

    public static void nmInterpolation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINTERPOLATION, value);
    }

    static {
        Struct.Layout layout = AIQuatKey.__struct(AIQuatKey.__member(8), AIQuatKey.__member(AIQuaternion.SIZEOF, AIQuaternion.ALIGNOF), AIQuatKey.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
        MINTERPOLATION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIQuatKey, Buffer>
    implements NativeResource {
        private static final AIQuatKey ELEMENT_FACTORY = AIQuatKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected AIQuatKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIQuatKey.nmTime(this.address());
        }

        @NativeType(value="struct aiQuaternion")
        public AIQuaternion mValue() {
            return AIQuatKey.nmValue(this.address());
        }

        @NativeType(value="aiAnimInterpolation")
        public int mInterpolation() {
            return AIQuatKey.nmInterpolation(this.address());
        }

        public Buffer mTime(double value) {
            AIQuatKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="struct aiQuaternion") AIQuaternion value) {
            AIQuatKey.nmValue(this.address(), value);
            return this;
        }

        public Buffer mValue(Consumer<AIQuaternion> consumer) {
            consumer.accept(this.mValue());
            return this;
        }

        public Buffer mInterpolation(@NativeType(value="aiAnimInterpolation") int value) {
            AIQuatKey.nmInterpolation(this.address(), value);
            return this;
        }
    }
}

