/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_vertex_layout_t")
public class BGFXVertexLayout
extends Struct<BGFXVertexLayout>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASH;
    public static final int STRIDE;
    public static final int OFFSET;
    public static final int ATTRIBUTES;

    protected BGFXVertexLayout(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected BGFXVertexLayout create(long address, @Nullable ByteBuffer container) {
        return new BGFXVertexLayout(address, container);
    }

    public BGFXVertexLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXVertexLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int hash() {
        return BGFXVertexLayout.nhash(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXVertexLayout.nstride(this.address());
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer offset() {
        return BGFXVertexLayout.noffset(this.address());
    }

    @NativeType(value="uint16_t")
    public short offset(int index) {
        return BGFXVertexLayout.noffset(this.address(), index);
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer attributes() {
        return BGFXVertexLayout.nattributes(this.address());
    }

    @NativeType(value="uint16_t")
    public short attributes(int index) {
        return BGFXVertexLayout.nattributes(this.address(), index);
    }

    public BGFXVertexLayout hash(@NativeType(value="uint32_t") int value) {
        BGFXVertexLayout.nhash(this.address(), value);
        return this;
    }

    public BGFXVertexLayout stride(@NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.nstride(this.address(), value);
        return this;
    }

    public BGFXVertexLayout offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexLayout.noffset(this.address(), value);
        return this;
    }

    public BGFXVertexLayout offset(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.noffset(this.address(), index, value);
        return this;
    }

    public BGFXVertexLayout attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexLayout.nattributes(this.address(), value);
        return this;
    }

    public BGFXVertexLayout attributes(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.nattributes(this.address(), index, value);
        return this;
    }

    public BGFXVertexLayout set(int hash, short stride, ShortBuffer offset, ShortBuffer attributes) {
        this.hash(hash);
        this.stride(stride);
        this.offset(offset);
        this.attributes(attributes);
        return this;
    }

    public BGFXVertexLayout set(BGFXVertexLayout src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXVertexLayout malloc() {
        return new BGFXVertexLayout(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static BGFXVertexLayout calloc() {
        return new BGFXVertexLayout(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static BGFXVertexLayout create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new BGFXVertexLayout(MemoryUtil.memAddress(container), container);
    }

    public static BGFXVertexLayout create(long address) {
        return new BGFXVertexLayout(address, null);
    }

    public static @Nullable BGFXVertexLayout createSafe(long address) {
        return address == 0L ? null : new BGFXVertexLayout(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(BGFXVertexLayout.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXVertexLayout.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static BGFXVertexLayout mallocStack() {
        return BGFXVertexLayout.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXVertexLayout callocStack() {
        return BGFXVertexLayout.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXVertexLayout mallocStack(MemoryStack stack) {
        return BGFXVertexLayout.malloc(stack);
    }

    @Deprecated
    public static BGFXVertexLayout callocStack(MemoryStack stack) {
        return BGFXVertexLayout.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXVertexLayout.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXVertexLayout.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.calloc(capacity, stack);
    }

    public static BGFXVertexLayout malloc(MemoryStack stack) {
        return new BGFXVertexLayout(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXVertexLayout calloc(MemoryStack stack) {
        return new BGFXVertexLayout(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhash(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HASH);
    }

    public static short nstride(long struct) {
        return MemoryUtil.memGetShort(struct + (long)STRIDE);
    }

    public static ShortBuffer noffset(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)OFFSET, 18);
    }

    public static short noffset(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)OFFSET + Checks.check(index, 18) * 2L);
    }

    public static ShortBuffer nattributes(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ATTRIBUTES, 18);
    }

    public static short nattributes(long struct, int index) {
        return MemoryUtil.memGetShort(struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L);
    }

    public static void nhash(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HASH, value);
    }

    public static void nstride(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)STRIDE, value);
    }

    public static void noffset(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)OFFSET, value.remaining() * 2);
    }

    public static void noffset(long struct, int index, short value) {
        MemoryUtil.memPutShort(struct + (long)OFFSET + Checks.check(index, 18) * 2L, value);
    }

    public static void nattributes(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ATTRIBUTES, value.remaining() * 2);
    }

    public static void nattributes(long struct, int index, short value) {
        MemoryUtil.memPutShort(struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L, value);
    }

    static {
        Struct.Layout layout = BGFXVertexLayout.__struct(BGFXVertexLayout.__member(4), BGFXVertexLayout.__member(2), BGFXVertexLayout.__array(2, 18), BGFXVertexLayout.__array(2, 18));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASH = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        ATTRIBUTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXVertexLayout, Buffer>
    implements NativeResource {
        private static final BGFXVertexLayout ELEMENT_FACTORY = BGFXVertexLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected BGFXVertexLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int hash() {
            return BGFXVertexLayout.nhash(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXVertexLayout.nstride(this.address());
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer offset() {
            return BGFXVertexLayout.noffset(this.address());
        }

        @NativeType(value="uint16_t")
        public short offset(int index) {
            return BGFXVertexLayout.noffset(this.address(), index);
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer attributes() {
            return BGFXVertexLayout.nattributes(this.address());
        }

        @NativeType(value="uint16_t")
        public short attributes(int index) {
            return BGFXVertexLayout.nattributes(this.address(), index);
        }

        public Buffer hash(@NativeType(value="uint32_t") int value) {
            BGFXVertexLayout.nhash(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.nstride(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexLayout.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.noffset(this.address(), index, value);
            return this;
        }

        public Buffer attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexLayout.nattributes(this.address(), value);
            return this;
        }

        public Buffer attributes(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.nattributes(this.address(), index, value);
            return this;
        }
    }
}

