/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_KERNEL_NODE_PARAMS_v2
extends Struct<CUDA_KERNEL_NODE_PARAMS_v2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FUNC;
    public static final int GRIDDIMX;
    public static final int GRIDDIMY;
    public static final int GRIDDIMZ;
    public static final int BLOCKDIMX;
    public static final int BLOCKDIMY;
    public static final int BLOCKDIMZ;
    public static final int SHAREDMEMBYTES;
    public static final int KERNELPARAMS;
    public static final int EXTRA;
    public static final int KERN;
    public static final int CTX;

    protected CUDA_KERNEL_NODE_PARAMS_v2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_KERNEL_NODE_PARAMS_v2 create(long address, @Nullable ByteBuffer container) {
        return new CUDA_KERNEL_NODE_PARAMS_v2(address, container);
    }

    public CUDA_KERNEL_NODE_PARAMS_v2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_KERNEL_NODE_PARAMS_v2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUfunction")
    public long func() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nfunc(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimX() {
        return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimY() {
        return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int gridDimZ() {
        return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimX() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimX(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimY() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimY(this.address());
    }

    @NativeType(value="unsigned int")
    public int blockDimZ() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimZ(this.address());
    }

    @NativeType(value="unsigned int")
    public int sharedMemBytes() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nsharedMemBytes(this.address());
    }

    @NativeType(value="void **")
    public @Nullable PointerBuffer kernelParams(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS_v2.nkernelParams(this.address(), capacity);
    }

    @NativeType(value="void **")
    public @Nullable PointerBuffer extra(int capacity) {
        return CUDA_KERNEL_NODE_PARAMS_v2.nextra(this.address(), capacity);
    }

    @NativeType(value="CUkernel")
    public long kern() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nkern(this.address());
    }

    @NativeType(value="CUcontext")
    public long ctx() {
        return CUDA_KERNEL_NODE_PARAMS_v2.nctx(this.address());
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 func(@NativeType(value="CUfunction") long value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nfunc(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 gridDimX(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.ngridDimX(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 gridDimY(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.ngridDimY(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 gridDimZ(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.ngridDimZ(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 blockDimX(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nblockDimX(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 blockDimY(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nblockDimY(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 blockDimZ(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nblockDimZ(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 sharedMemBytes(@NativeType(value="unsigned int") int value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nsharedMemBytes(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 kernelParams(@NativeType(value="void **") @Nullable PointerBuffer value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nkernelParams(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 extra(@NativeType(value="void **") @Nullable PointerBuffer value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nextra(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 kern(@NativeType(value="CUkernel") long value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nkern(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 ctx(@NativeType(value="CUcontext") long value) {
        CUDA_KERNEL_NODE_PARAMS_v2.nctx(this.address(), value);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 set(long func, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ, int sharedMemBytes, @Nullable PointerBuffer kernelParams, @Nullable PointerBuffer extra, long kern, long ctx) {
        this.func(func);
        this.gridDimX(gridDimX);
        this.gridDimY(gridDimY);
        this.gridDimZ(gridDimZ);
        this.blockDimX(blockDimX);
        this.blockDimY(blockDimY);
        this.blockDimZ(blockDimZ);
        this.sharedMemBytes(sharedMemBytes);
        this.kernelParams(kernelParams);
        this.extra(extra);
        this.kern(kern);
        this.ctx(ctx);
        return this;
    }

    public CUDA_KERNEL_NODE_PARAMS_v2 set(CUDA_KERNEL_NODE_PARAMS_v2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 malloc() {
        return new CUDA_KERNEL_NODE_PARAMS_v2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 calloc() {
        return new CUDA_KERNEL_NODE_PARAMS_v2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_KERNEL_NODE_PARAMS_v2(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 create(long address) {
        return new CUDA_KERNEL_NODE_PARAMS_v2(address, null);
    }

    public static @Nullable CUDA_KERNEL_NODE_PARAMS_v2 createSafe(long address) {
        return address == 0L ? null : new CUDA_KERNEL_NODE_PARAMS_v2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_KERNEL_NODE_PARAMS_v2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_KERNEL_NODE_PARAMS_v2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 malloc(MemoryStack stack) {
        return new CUDA_KERNEL_NODE_PARAMS_v2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_KERNEL_NODE_PARAMS_v2 calloc(MemoryStack stack) {
        return new CUDA_KERNEL_NODE_PARAMS_v2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nfunc(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FUNC);
    }

    public static int ngridDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMX);
    }

    public static int ngridDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMY);
    }

    public static int ngridDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GRIDDIMZ);
    }

    public static int nblockDimX(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMX);
    }

    public static int nblockDimY(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMY);
    }

    public static int nblockDimZ(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLOCKDIMZ);
    }

    public static int nsharedMemBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAREDMEMBYTES);
    }

    public static @Nullable PointerBuffer nkernelParams(long struct, int capacity) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)KERNELPARAMS), capacity);
    }

    public static @Nullable PointerBuffer nextra(long struct, int capacity) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)EXTRA), capacity);
    }

    public static long nkern(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)KERN);
    }

    public static long nctx(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CTX);
    }

    public static void nfunc(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)FUNC, value);
    }

    public static void ngridDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMX, value);
    }

    public static void ngridDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMY, value);
    }

    public static void ngridDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GRIDDIMZ, value);
    }

    public static void nblockDimX(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMX, value);
    }

    public static void nblockDimY(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMY, value);
    }

    public static void nblockDimZ(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BLOCKDIMZ, value);
    }

    public static void nsharedMemBytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAREDMEMBYTES, value);
    }

    public static void nkernelParams(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)KERNELPARAMS, MemoryUtil.memAddressSafe(value));
    }

    public static void nextra(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)EXTRA, MemoryUtil.memAddressSafe(value));
    }

    public static void nkern(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)KERN, value);
    }

    public static void nctx(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CTX, value);
    }

    static {
        Struct.Layout layout = CUDA_KERNEL_NODE_PARAMS_v2.__struct(CUDA_KERNEL_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(4), CUDA_KERNEL_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS_v2.__member(POINTER_SIZE), CUDA_KERNEL_NODE_PARAMS_v2.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FUNC = layout.offsetof(0);
        GRIDDIMX = layout.offsetof(1);
        GRIDDIMY = layout.offsetof(2);
        GRIDDIMZ = layout.offsetof(3);
        BLOCKDIMX = layout.offsetof(4);
        BLOCKDIMY = layout.offsetof(5);
        BLOCKDIMZ = layout.offsetof(6);
        SHAREDMEMBYTES = layout.offsetof(7);
        KERNELPARAMS = layout.offsetof(8);
        EXTRA = layout.offsetof(9);
        KERN = layout.offsetof(10);
        CTX = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<CUDA_KERNEL_NODE_PARAMS_v2, Buffer>
    implements NativeResource {
        private static final CUDA_KERNEL_NODE_PARAMS_v2 ELEMENT_FACTORY = CUDA_KERNEL_NODE_PARAMS_v2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_KERNEL_NODE_PARAMS_v2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUfunction")
        public long func() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nfunc(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimX() {
            return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimY() {
            return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int gridDimZ() {
            return CUDA_KERNEL_NODE_PARAMS_v2.ngridDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimX() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimX(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimY() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimY(this.address());
        }

        @NativeType(value="unsigned int")
        public int blockDimZ() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nblockDimZ(this.address());
        }

        @NativeType(value="unsigned int")
        public int sharedMemBytes() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nsharedMemBytes(this.address());
        }

        @NativeType(value="void **")
        public @Nullable PointerBuffer kernelParams(int capacity) {
            return CUDA_KERNEL_NODE_PARAMS_v2.nkernelParams(this.address(), capacity);
        }

        @NativeType(value="void **")
        public @Nullable PointerBuffer extra(int capacity) {
            return CUDA_KERNEL_NODE_PARAMS_v2.nextra(this.address(), capacity);
        }

        @NativeType(value="CUkernel")
        public long kern() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nkern(this.address());
        }

        @NativeType(value="CUcontext")
        public long ctx() {
            return CUDA_KERNEL_NODE_PARAMS_v2.nctx(this.address());
        }

        public Buffer func(@NativeType(value="CUfunction") long value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nfunc(this.address(), value);
            return this;
        }

        public Buffer gridDimX(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.ngridDimX(this.address(), value);
            return this;
        }

        public Buffer gridDimY(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.ngridDimY(this.address(), value);
            return this;
        }

        public Buffer gridDimZ(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.ngridDimZ(this.address(), value);
            return this;
        }

        public Buffer blockDimX(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nblockDimX(this.address(), value);
            return this;
        }

        public Buffer blockDimY(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nblockDimY(this.address(), value);
            return this;
        }

        public Buffer blockDimZ(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nblockDimZ(this.address(), value);
            return this;
        }

        public Buffer sharedMemBytes(@NativeType(value="unsigned int") int value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nsharedMemBytes(this.address(), value);
            return this;
        }

        public Buffer kernelParams(@NativeType(value="void **") @Nullable PointerBuffer value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nkernelParams(this.address(), value);
            return this;
        }

        public Buffer extra(@NativeType(value="void **") @Nullable PointerBuffer value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nextra(this.address(), value);
            return this;
        }

        public Buffer kern(@NativeType(value="CUkernel") long value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nkern(this.address(), value);
            return this;
        }

        public Buffer ctx(@NativeType(value="CUcontext") long value) {
            CUDA_KERNEL_NODE_PARAMS_v2.nctx(this.address(), value);
            return this;
        }
    }
}

