/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUmemAccessDesc;
import org.lwjgl.cuda.CUmemPoolProps;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEM_ALLOC_NODE_PARAMS
extends Struct<CUDA_MEM_ALLOC_NODE_PARAMS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POOLPROPS;
    public static final int ACCESSDESCS;
    public static final int ACCESSDESCCOUNT;
    public static final int BYTESIZE;
    public static final int DPTR;

    protected CUDA_MEM_ALLOC_NODE_PARAMS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_MEM_ALLOC_NODE_PARAMS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(address, container);
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_MEM_ALLOC_NODE_PARAMS.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public CUmemPoolProps poolProps() {
        return CUDA_MEM_ALLOC_NODE_PARAMS.npoolProps(this.address());
    }

    @NativeType(value="CUmemAccessDesc const *")
    public CUmemAccessDesc.Buffer accessDescs() {
        return CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescs(this.address());
    }

    @NativeType(value="size_t")
    public long accessDescCount() {
        return CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescCount(this.address());
    }

    @NativeType(value="size_t")
    public long bytesize() {
        return CUDA_MEM_ALLOC_NODE_PARAMS.nbytesize(this.address());
    }

    @NativeType(value="CUdeviceptr")
    public long dptr() {
        return CUDA_MEM_ALLOC_NODE_PARAMS.ndptr(this.address());
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS poolProps(CUmemPoolProps value) {
        CUDA_MEM_ALLOC_NODE_PARAMS.npoolProps(this.address(), value);
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS poolProps(Consumer<CUmemPoolProps> consumer) {
        consumer.accept(this.poolProps());
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS accessDescs(@NativeType(value="CUmemAccessDesc const *") CUmemAccessDesc.Buffer value) {
        CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescs(this.address(), value);
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS bytesize(@NativeType(value="size_t") long value) {
        CUDA_MEM_ALLOC_NODE_PARAMS.nbytesize(this.address(), value);
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS dptr(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEM_ALLOC_NODE_PARAMS.ndptr(this.address(), value);
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS set(CUmemPoolProps poolProps, CUmemAccessDesc.Buffer accessDescs, long bytesize, long dptr) {
        this.poolProps(poolProps);
        this.accessDescs(accessDescs);
        this.bytesize(bytesize);
        this.dptr(dptr);
        return this;
    }

    public CUDA_MEM_ALLOC_NODE_PARAMS set(CUDA_MEM_ALLOC_NODE_PARAMS src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS malloc() {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS calloc() {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_MEM_ALLOC_NODE_PARAMS(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS create(long address) {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(address, null);
    }

    public static @Nullable CUDA_MEM_ALLOC_NODE_PARAMS createSafe(long address) {
        return address == 0L ? null : new CUDA_MEM_ALLOC_NODE_PARAMS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_MEM_ALLOC_NODE_PARAMS.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEM_ALLOC_NODE_PARAMS.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS malloc(MemoryStack stack) {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_MEM_ALLOC_NODE_PARAMS calloc(MemoryStack stack) {
        return new CUDA_MEM_ALLOC_NODE_PARAMS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUmemPoolProps npoolProps(long struct) {
        return CUmemPoolProps.create(struct + (long)POOLPROPS);
    }

    public static CUmemAccessDesc.Buffer naccessDescs(long struct) {
        return CUmemAccessDesc.create(MemoryUtil.memGetAddress(struct + (long)ACCESSDESCS), (int)CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescCount(struct));
    }

    public static long naccessDescCount(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACCESSDESCCOUNT);
    }

    public static long nbytesize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BYTESIZE);
    }

    public static long ndptr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DPTR);
    }

    public static void npoolProps(long struct, CUmemPoolProps value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POOLPROPS, CUmemPoolProps.SIZEOF);
    }

    public static void naccessDescs(long struct, CUmemAccessDesc.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)ACCESSDESCS, value.address());
        CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescCount(struct, value.remaining());
    }

    public static void naccessDescCount(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ACCESSDESCCOUNT, value);
    }

    public static void nbytesize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BYTESIZE, value);
    }

    public static void ndptr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DPTR, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACCESSDESCS));
    }

    static {
        Struct.Layout layout = CUDA_MEM_ALLOC_NODE_PARAMS.__struct(CUDA_MEM_ALLOC_NODE_PARAMS.__member(CUmemPoolProps.SIZEOF, CUmemPoolProps.ALIGNOF), CUDA_MEM_ALLOC_NODE_PARAMS.__member(POINTER_SIZE), CUDA_MEM_ALLOC_NODE_PARAMS.__member(POINTER_SIZE), CUDA_MEM_ALLOC_NODE_PARAMS.__member(POINTER_SIZE), CUDA_MEM_ALLOC_NODE_PARAMS.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POOLPROPS = layout.offsetof(0);
        ACCESSDESCS = layout.offsetof(1);
        ACCESSDESCCOUNT = layout.offsetof(2);
        BYTESIZE = layout.offsetof(3);
        DPTR = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEM_ALLOC_NODE_PARAMS, Buffer>
    implements NativeResource {
        private static final CUDA_MEM_ALLOC_NODE_PARAMS ELEMENT_FACTORY = CUDA_MEM_ALLOC_NODE_PARAMS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_MEM_ALLOC_NODE_PARAMS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUmemPoolProps poolProps() {
            return CUDA_MEM_ALLOC_NODE_PARAMS.npoolProps(this.address());
        }

        @NativeType(value="CUmemAccessDesc const *")
        public CUmemAccessDesc.Buffer accessDescs() {
            return CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescs(this.address());
        }

        @NativeType(value="size_t")
        public long accessDescCount() {
            return CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescCount(this.address());
        }

        @NativeType(value="size_t")
        public long bytesize() {
            return CUDA_MEM_ALLOC_NODE_PARAMS.nbytesize(this.address());
        }

        @NativeType(value="CUdeviceptr")
        public long dptr() {
            return CUDA_MEM_ALLOC_NODE_PARAMS.ndptr(this.address());
        }

        public Buffer poolProps(CUmemPoolProps value) {
            CUDA_MEM_ALLOC_NODE_PARAMS.npoolProps(this.address(), value);
            return this;
        }

        public Buffer poolProps(Consumer<CUmemPoolProps> consumer) {
            consumer.accept(this.poolProps());
            return this;
        }

        public Buffer accessDescs(@NativeType(value="CUmemAccessDesc const *") CUmemAccessDesc.Buffer value) {
            CUDA_MEM_ALLOC_NODE_PARAMS.naccessDescs(this.address(), value);
            return this;
        }

        public Buffer bytesize(@NativeType(value="size_t") long value) {
            CUDA_MEM_ALLOC_NODE_PARAMS.nbytesize(this.address(), value);
            return this;
        }

        public Buffer dptr(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEM_ALLOC_NODE_PARAMS.ndptr(this.address(), value);
            return this;
        }
    }
}

