/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_POINTER_ATTRIBUTE_P2P_TOKENS
extends Struct<CUDA_POINTER_ATTRIBUTE_P2P_TOKENS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int P2PTOKEN;
    public static final int VASPACETOKEN;

    protected CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUDA_POINTER_ATTRIBUTE_P2P_TOKENS create(long address, @Nullable ByteBuffer container) {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(address, container);
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned long long")
    public long p2pToken() {
        return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address());
    }

    @NativeType(value="unsigned int")
    public int vaSpaceToken() {
        return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address());
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS p2pToken(@NativeType(value="unsigned long long") long value) {
        CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address(), value);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS vaSpaceToken(@NativeType(value="unsigned int") int value) {
        CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address(), value);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS set(long p2pToken, int vaSpaceToken) {
        this.p2pToken(p2pToken);
        this.vaSpaceToken(vaSpaceToken);
        return this;
    }

    public CUDA_POINTER_ATTRIBUTE_P2P_TOKENS set(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS malloc() {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS calloc() {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(MemoryUtil.memAddress(container), container);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS create(long address) {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(address, null);
    }

    public static @Nullable CUDA_POINTER_ATTRIBUTE_P2P_TOKENS createSafe(long address) {
        return address == 0L ? null : new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS malloc(MemoryStack stack) {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUDA_POINTER_ATTRIBUTE_P2P_TOKENS calloc(MemoryStack stack) {
        return new CUDA_POINTER_ATTRIBUTE_P2P_TOKENS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long np2pToken(long struct) {
        return MemoryUtil.memGetLong(struct + (long)P2PTOKEN);
    }

    public static int nvaSpaceToken(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VASPACETOKEN);
    }

    public static void np2pToken(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)P2PTOKEN, value);
    }

    public static void nvaSpaceToken(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VASPACETOKEN, value);
    }

    static {
        Struct.Layout layout = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__struct(CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__member(8), CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        P2PTOKEN = layout.offsetof(0);
        VASPACETOKEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUDA_POINTER_ATTRIBUTE_P2P_TOKENS, Buffer>
    implements NativeResource {
        private static final CUDA_POINTER_ATTRIBUTE_P2P_TOKENS ELEMENT_FACTORY = CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUDA_POINTER_ATTRIBUTE_P2P_TOKENS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned long long")
        public long p2pToken() {
            return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address());
        }

        @NativeType(value="unsigned int")
        public int vaSpaceToken() {
            return CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address());
        }

        public Buffer p2pToken(@NativeType(value="unsigned long long") long value) {
            CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.np2pToken(this.address(), value);
            return this;
        }

        public Buffer vaSpaceToken(@NativeType(value="unsigned int") int value) {
            CUDA_POINTER_ATTRIBUTE_P2P_TOKENS.nvaSpaceToken(this.address(), value);
            return this;
        }
    }
}

