/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CUWGL {
    protected CUWGL() {
        throw new UnsupportedOperationException();
    }

    public static int ncuWGLGetDevice(long pDevice, long hGpu) {
        long __functionAddress = Functions.WGLGetDevice;
        if (Checks.CHECKS) {
            Checks.check(hGpu);
        }
        return JNI.callPPI(pDevice, hGpu, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuWGLGetDevice(@NativeType(value="CUdevice *") IntBuffer pDevice, @NativeType(value="HGPUNV") long hGpu) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pDevice, 1);
        }
        return CUWGL.ncuWGLGetDevice(MemoryUtil.memAddress(pDevice), hGpu);
    }

    public static final class Functions {
        public static final long WGLGetDevice = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuWGLGetDevice");

        private Functions() {
        }
    }
}

