/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUctxCigParam
extends Struct<CUctxCigParam>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SHAREDDATATYPE;
    public static final int SHAREDDATA;

    protected CUctxCigParam(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUctxCigParam create(long address, @Nullable ByteBuffer container) {
        return new CUctxCigParam(address, container);
    }

    public CUctxCigParam(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUctxCigParam.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUtensorMapDataType")
    public int sharedDataType() {
        return CUctxCigParam.nsharedDataType(this.address());
    }

    @NativeType(value="void *")
    public long sharedData() {
        return CUctxCigParam.nsharedData(this.address());
    }

    public CUctxCigParam sharedDataType(@NativeType(value="CUtensorMapDataType") int value) {
        CUctxCigParam.nsharedDataType(this.address(), value);
        return this;
    }

    public CUctxCigParam sharedData(@NativeType(value="void *") long value) {
        CUctxCigParam.nsharedData(this.address(), value);
        return this;
    }

    public CUctxCigParam set(int sharedDataType, long sharedData) {
        this.sharedDataType(sharedDataType);
        this.sharedData(sharedData);
        return this;
    }

    public CUctxCigParam set(CUctxCigParam src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUctxCigParam malloc() {
        return new CUctxCigParam(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUctxCigParam calloc() {
        return new CUctxCigParam(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUctxCigParam create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUctxCigParam(MemoryUtil.memAddress(container), container);
    }

    public static CUctxCigParam create(long address) {
        return new CUctxCigParam(address, null);
    }

    public static @Nullable CUctxCigParam createSafe(long address) {
        return address == 0L ? null : new CUctxCigParam(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUctxCigParam.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUctxCigParam.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUctxCigParam malloc(MemoryStack stack) {
        return new CUctxCigParam(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUctxCigParam calloc(MemoryStack stack) {
        return new CUctxCigParam(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsharedDataType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHAREDDATATYPE);
    }

    public static long nsharedData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SHAREDDATA);
    }

    public static void nsharedDataType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHAREDDATATYPE, value);
    }

    public static void nsharedData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SHAREDDATA, value);
    }

    static {
        Struct.Layout layout = CUctxCigParam.__struct(CUctxCigParam.__member(4), CUctxCigParam.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SHAREDDATATYPE = layout.offsetof(0);
        SHAREDDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUctxCigParam, Buffer>
    implements NativeResource {
        private static final CUctxCigParam ELEMENT_FACTORY = CUctxCigParam.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUctxCigParam getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUtensorMapDataType")
        public int sharedDataType() {
            return CUctxCigParam.nsharedDataType(this.address());
        }

        @NativeType(value="void *")
        public long sharedData() {
            return CUctxCigParam.nsharedData(this.address());
        }

        public Buffer sharedDataType(@NativeType(value="CUtensorMapDataType") int value) {
            CUctxCigParam.nsharedDataType(this.address(), value);
            return this;
        }

        public Buffer sharedData(@NativeType(value="void *") long value) {
            CUctxCigParam.nsharedData(this.address(), value);
            return this;
        }
    }
}

