/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUdevSmResource;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUdevResource
extends Struct<CUdevResource>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int _INTERNAL_PADDING;
    public static final int RESOURCE;
    public static final int RESOURCE_SM;
    public static final int RESOURCE__OVERSIZE;

    protected CUdevResource(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUdevResource create(long address, @Nullable ByteBuffer container) {
        return new CUdevResource(address, container);
    }

    public CUdevResource(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUdevResource.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUdevResourceType")
    public int type() {
        return CUdevResource.ntype(this.address());
    }

    public CUdevSmResource resource_sm() {
        return CUdevResource.nresource_sm(this.address());
    }

    @NativeType(value="unsigned char[48]")
    public ByteBuffer resource__oversize() {
        return CUdevResource.nresource__oversize(this.address());
    }

    @NativeType(value="unsigned char")
    public byte resource__oversize(int index) {
        return CUdevResource.nresource__oversize(this.address(), index);
    }

    public static CUdevResource malloc() {
        return new CUdevResource(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUdevResource calloc() {
        return new CUdevResource(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUdevResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUdevResource(MemoryUtil.memAddress(container), container);
    }

    public static CUdevResource create(long address) {
        return new CUdevResource(address, null);
    }

    public static @Nullable CUdevResource createSafe(long address) {
        return address == 0L ? null : new CUdevResource(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUdevResource.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUdevResource.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUdevResource malloc(MemoryStack stack) {
        return new CUdevResource(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUdevResource calloc(MemoryStack stack) {
        return new CUdevResource(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static ByteBuffer n_internal_padding(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)_INTERNAL_PADDING, 92);
    }

    public static byte n_internal_padding(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)_INTERNAL_PADDING + Checks.check(index, 92) * 1L);
    }

    public static CUdevSmResource nresource_sm(long struct) {
        return CUdevSmResource.create(struct + (long)RESOURCE_SM);
    }

    public static ByteBuffer nresource__oversize(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESOURCE__OVERSIZE, 48);
    }

    public static byte nresource__oversize(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESOURCE__OVERSIZE + Checks.check(index, 48) * 1L);
    }

    static {
        Struct.Layout layout = CUdevResource.__struct(CUdevResource.__member(4), CUdevResource.__array(1, 92), CUdevResource.__union(CUdevResource.__member(CUdevSmResource.SIZEOF, CUdevSmResource.ALIGNOF), CUdevResource.__array(1, 48)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        _INTERNAL_PADDING = layout.offsetof(1);
        RESOURCE = layout.offsetof(2);
        RESOURCE_SM = layout.offsetof(3);
        RESOURCE__OVERSIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUdevResource, Buffer>
    implements NativeResource {
        private static final CUdevResource ELEMENT_FACTORY = CUdevResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUdevResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUdevResourceType")
        public int type() {
            return CUdevResource.ntype(this.address());
        }

        public CUdevSmResource resource_sm() {
            return CUdevResource.nresource_sm(this.address());
        }

        @NativeType(value="unsigned char[48]")
        public ByteBuffer resource__oversize() {
            return CUdevResource.nresource__oversize(this.address());
        }

        @NativeType(value="unsigned char")
        public byte resource__oversize(int index) {
            return CUdevResource.nresource__oversize(this.address(), index);
        }
    }
}

