/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUgraphEdgeData
extends Struct<CUgraphEdgeData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FROM_PORT;
    public static final int TO_PORT;
    public static final int TYPE;
    public static final int RESERVED;

    protected CUgraphEdgeData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUgraphEdgeData create(long address, @Nullable ByteBuffer container) {
        return new CUgraphEdgeData(address, container);
    }

    public CUgraphEdgeData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUgraphEdgeData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char")
    public byte from_port() {
        return CUgraphEdgeData.nfrom_port(this.address());
    }

    @NativeType(value="unsigned char")
    public byte to_port() {
        return CUgraphEdgeData.nto_port(this.address());
    }

    @NativeType(value="unsigned char")
    public byte type() {
        return CUgraphEdgeData.ntype(this.address());
    }

    public CUgraphEdgeData from_port(@NativeType(value="unsigned char") byte value) {
        CUgraphEdgeData.nfrom_port(this.address(), value);
        return this;
    }

    public CUgraphEdgeData to_port(@NativeType(value="unsigned char") byte value) {
        CUgraphEdgeData.nto_port(this.address(), value);
        return this;
    }

    public CUgraphEdgeData type(@NativeType(value="unsigned char") byte value) {
        CUgraphEdgeData.ntype(this.address(), value);
        return this;
    }

    public CUgraphEdgeData set(byte from_port, byte to_port, byte type) {
        this.from_port(from_port);
        this.to_port(to_port);
        this.type(type);
        return this;
    }

    public CUgraphEdgeData set(CUgraphEdgeData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUgraphEdgeData malloc() {
        return new CUgraphEdgeData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUgraphEdgeData calloc() {
        return new CUgraphEdgeData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUgraphEdgeData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUgraphEdgeData(MemoryUtil.memAddress(container), container);
    }

    public static CUgraphEdgeData create(long address) {
        return new CUgraphEdgeData(address, null);
    }

    public static @Nullable CUgraphEdgeData createSafe(long address) {
        return address == 0L ? null : new CUgraphEdgeData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUgraphEdgeData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUgraphEdgeData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUgraphEdgeData malloc(MemoryStack stack) {
        return new CUgraphEdgeData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUgraphEdgeData calloc(MemoryStack stack) {
        return new CUgraphEdgeData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nfrom_port(long struct) {
        return MemoryUtil.memGetByte(struct + (long)FROM_PORT);
    }

    public static byte nto_port(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TO_PORT);
    }

    public static byte ntype(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TYPE);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 5);
    }

    public static byte nreserved(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED + Checks.check(index, 5) * 1L);
    }

    public static void nfrom_port(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)FROM_PORT, value);
    }

    public static void nto_port(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)TO_PORT, value);
    }

    public static void ntype(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)TYPE, value);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 5);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)RESERVED + Checks.check(index, 5) * 1L, value);
    }

    static {
        Struct.Layout layout = CUgraphEdgeData.__struct(CUgraphEdgeData.__member(1), CUgraphEdgeData.__member(1), CUgraphEdgeData.__member(1), CUgraphEdgeData.__array(1, 5));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FROM_PORT = layout.offsetof(0);
        TO_PORT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        RESERVED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CUgraphEdgeData, Buffer>
    implements NativeResource {
        private static final CUgraphEdgeData ELEMENT_FACTORY = CUgraphEdgeData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUgraphEdgeData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char")
        public byte from_port() {
            return CUgraphEdgeData.nfrom_port(this.address());
        }

        @NativeType(value="unsigned char")
        public byte to_port() {
            return CUgraphEdgeData.nto_port(this.address());
        }

        @NativeType(value="unsigned char")
        public byte type() {
            return CUgraphEdgeData.ntype(this.address());
        }

        public Buffer from_port(@NativeType(value="unsigned char") byte value) {
            CUgraphEdgeData.nfrom_port(this.address(), value);
            return this;
        }

        public Buffer to_port(@NativeType(value="unsigned char") byte value) {
            CUgraphEdgeData.nto_port(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="unsigned char") byte value) {
            CUgraphEdgeData.ntype(this.address(), value);
            return this;
        }
    }
}

