/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUlaunchMemSyncDomainMap
extends Struct<CUlaunchMemSyncDomainMap>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DEFAULT_;
    public static final int REMOTE;

    protected CUlaunchMemSyncDomainMap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUlaunchMemSyncDomainMap create(long address, @Nullable ByteBuffer container) {
        return new CUlaunchMemSyncDomainMap(address, container);
    }

    public CUlaunchMemSyncDomainMap(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUlaunchMemSyncDomainMap.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char")
    public byte default_() {
        return CUlaunchMemSyncDomainMap.ndefault_(this.address());
    }

    @NativeType(value="unsigned char")
    public byte remote() {
        return CUlaunchMemSyncDomainMap.nremote(this.address());
    }

    public CUlaunchMemSyncDomainMap default_(@NativeType(value="unsigned char") byte value) {
        CUlaunchMemSyncDomainMap.ndefault_(this.address(), value);
        return this;
    }

    public CUlaunchMemSyncDomainMap remote(@NativeType(value="unsigned char") byte value) {
        CUlaunchMemSyncDomainMap.nremote(this.address(), value);
        return this;
    }

    public CUlaunchMemSyncDomainMap set(byte default_, byte remote) {
        this.default_(default_);
        this.remote(remote);
        return this;
    }

    public CUlaunchMemSyncDomainMap set(CUlaunchMemSyncDomainMap src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUlaunchMemSyncDomainMap malloc() {
        return new CUlaunchMemSyncDomainMap(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUlaunchMemSyncDomainMap calloc() {
        return new CUlaunchMemSyncDomainMap(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUlaunchMemSyncDomainMap create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUlaunchMemSyncDomainMap(MemoryUtil.memAddress(container), container);
    }

    public static CUlaunchMemSyncDomainMap create(long address) {
        return new CUlaunchMemSyncDomainMap(address, null);
    }

    public static @Nullable CUlaunchMemSyncDomainMap createSafe(long address) {
        return address == 0L ? null : new CUlaunchMemSyncDomainMap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUlaunchMemSyncDomainMap.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUlaunchMemSyncDomainMap.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUlaunchMemSyncDomainMap malloc(MemoryStack stack) {
        return new CUlaunchMemSyncDomainMap(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUlaunchMemSyncDomainMap calloc(MemoryStack stack) {
        return new CUlaunchMemSyncDomainMap(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte ndefault_(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DEFAULT_);
    }

    public static byte nremote(long struct) {
        return MemoryUtil.memGetByte(struct + (long)REMOTE);
    }

    public static void ndefault_(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DEFAULT_, value);
    }

    public static void nremote(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)REMOTE, value);
    }

    static {
        Struct.Layout layout = CUlaunchMemSyncDomainMap.__struct(CUlaunchMemSyncDomainMap.__member(1), CUlaunchMemSyncDomainMap.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DEFAULT_ = layout.offsetof(0);
        REMOTE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUlaunchMemSyncDomainMap, Buffer>
    implements NativeResource {
        private static final CUlaunchMemSyncDomainMap ELEMENT_FACTORY = CUlaunchMemSyncDomainMap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUlaunchMemSyncDomainMap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char")
        public byte default_() {
            return CUlaunchMemSyncDomainMap.ndefault_(this.address());
        }

        @NativeType(value="unsigned char")
        public byte remote() {
            return CUlaunchMemSyncDomainMap.nremote(this.address());
        }

        public Buffer default_(@NativeType(value="unsigned char") byte value) {
            CUlaunchMemSyncDomainMap.ndefault_(this.address(), value);
            return this;
        }

        public Buffer remote(@NativeType(value="unsigned char") byte value) {
            CUlaunchMemSyncDomainMap.nremote(this.address(), value);
            return this;
        }
    }
}

