/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemPoolPtrExportData
extends Struct<CUmemPoolPtrExportData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    protected CUmemPoolPtrExportData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CUmemPoolPtrExportData create(long address, @Nullable ByteBuffer container) {
        return new CUmemPoolPtrExportData(address, container);
    }

    public CUmemPoolPtrExportData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmemPoolPtrExportData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[64]")
    public ByteBuffer reserved() {
        return CUmemPoolPtrExportData.nreserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte reserved(int index) {
        return CUmemPoolPtrExportData.nreserved(this.address(), index);
    }

    public CUmemPoolPtrExportData reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
        CUmemPoolPtrExportData.nreserved(this.address(), value);
        return this;
    }

    public CUmemPoolPtrExportData reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemPoolPtrExportData.nreserved(this.address(), index, value);
        return this;
    }

    public CUmemPoolPtrExportData set(CUmemPoolPtrExportData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmemPoolPtrExportData malloc() {
        return new CUmemPoolPtrExportData(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CUmemPoolPtrExportData calloc() {
        return new CUmemPoolPtrExportData(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CUmemPoolPtrExportData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CUmemPoolPtrExportData(MemoryUtil.memAddress(container), container);
    }

    public static CUmemPoolPtrExportData create(long address) {
        return new CUmemPoolPtrExportData(address, null);
    }

    public static @Nullable CUmemPoolPtrExportData createSafe(long address) {
        return address == 0L ? null : new CUmemPoolPtrExportData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CUmemPoolPtrExportData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemPoolPtrExportData.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CUmemPoolPtrExportData malloc(MemoryStack stack) {
        return new CUmemPoolPtrExportData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CUmemPoolPtrExportData calloc(MemoryStack stack) {
        return new CUmemPoolPtrExportData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 64);
    }

    public static byte nreserved(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)RESERVED + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUmemPoolPtrExportData.__struct(CUmemPoolPtrExportData.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUmemPoolPtrExportData, Buffer>
    implements NativeResource {
        private static final CUmemPoolPtrExportData ELEMENT_FACTORY = CUmemPoolPtrExportData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CUmemPoolPtrExportData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[64]")
        public ByteBuffer reserved() {
            return CUmemPoolPtrExportData.nreserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte reserved(int index) {
            return CUmemPoolPtrExportData.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
            CUmemPoolPtrExportData.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemPoolPtrExportData.nreserved(this.address(), index, value);
            return this;
        }
    }
}

