/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_VECTOR;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_3D_ATTRIBUTES
extends Struct<FMOD_3D_ATTRIBUTES>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITION;
    public static final int VELOCITY;
    public static final int FORWARD;
    public static final int UP;

    protected FMOD_3D_ATTRIBUTES(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_3D_ATTRIBUTES create(long address, @Nullable ByteBuffer container) {
        return new FMOD_3D_ATTRIBUTES(address, container);
    }

    public FMOD_3D_ATTRIBUTES(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_3D_ATTRIBUTES.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FMOD_VECTOR position$() {
        return FMOD_3D_ATTRIBUTES.nposition$(this.address());
    }

    public FMOD_VECTOR velocity() {
        return FMOD_3D_ATTRIBUTES.nvelocity(this.address());
    }

    public FMOD_VECTOR forward() {
        return FMOD_3D_ATTRIBUTES.nforward(this.address());
    }

    public FMOD_VECTOR up() {
        return FMOD_3D_ATTRIBUTES.nup(this.address());
    }

    public FMOD_3D_ATTRIBUTES position$(FMOD_VECTOR value) {
        FMOD_3D_ATTRIBUTES.nposition$(this.address(), value);
        return this;
    }

    public FMOD_3D_ATTRIBUTES position$(Consumer<FMOD_VECTOR> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public FMOD_3D_ATTRIBUTES velocity(FMOD_VECTOR value) {
        FMOD_3D_ATTRIBUTES.nvelocity(this.address(), value);
        return this;
    }

    public FMOD_3D_ATTRIBUTES velocity(Consumer<FMOD_VECTOR> consumer) {
        consumer.accept(this.velocity());
        return this;
    }

    public FMOD_3D_ATTRIBUTES forward(FMOD_VECTOR value) {
        FMOD_3D_ATTRIBUTES.nforward(this.address(), value);
        return this;
    }

    public FMOD_3D_ATTRIBUTES forward(Consumer<FMOD_VECTOR> consumer) {
        consumer.accept(this.forward());
        return this;
    }

    public FMOD_3D_ATTRIBUTES up(FMOD_VECTOR value) {
        FMOD_3D_ATTRIBUTES.nup(this.address(), value);
        return this;
    }

    public FMOD_3D_ATTRIBUTES up(Consumer<FMOD_VECTOR> consumer) {
        consumer.accept(this.up());
        return this;
    }

    public FMOD_3D_ATTRIBUTES set(FMOD_VECTOR position$, FMOD_VECTOR velocity, FMOD_VECTOR forward, FMOD_VECTOR up) {
        this.position$(position$);
        this.velocity(velocity);
        this.forward(forward);
        this.up(up);
        return this;
    }

    public FMOD_3D_ATTRIBUTES set(FMOD_3D_ATTRIBUTES src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_3D_ATTRIBUTES malloc() {
        return new FMOD_3D_ATTRIBUTES(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_3D_ATTRIBUTES calloc() {
        return new FMOD_3D_ATTRIBUTES(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_3D_ATTRIBUTES create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_3D_ATTRIBUTES(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_3D_ATTRIBUTES create(long address) {
        return new FMOD_3D_ATTRIBUTES(address, null);
    }

    public static @Nullable FMOD_3D_ATTRIBUTES createSafe(long address) {
        return address == 0L ? null : new FMOD_3D_ATTRIBUTES(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_3D_ATTRIBUTES.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_3D_ATTRIBUTES.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_3D_ATTRIBUTES malloc(MemoryStack stack) {
        return new FMOD_3D_ATTRIBUTES(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_3D_ATTRIBUTES calloc(MemoryStack stack) {
        return new FMOD_3D_ATTRIBUTES(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FMOD_VECTOR nposition$(long struct) {
        return FMOD_VECTOR.create(struct + (long)POSITION);
    }

    public static FMOD_VECTOR nvelocity(long struct) {
        return FMOD_VECTOR.create(struct + (long)VELOCITY);
    }

    public static FMOD_VECTOR nforward(long struct) {
        return FMOD_VECTOR.create(struct + (long)FORWARD);
    }

    public static FMOD_VECTOR nup(long struct) {
        return FMOD_VECTOR.create(struct + (long)UP);
    }

    public static void nposition$(long struct, FMOD_VECTOR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, FMOD_VECTOR.SIZEOF);
    }

    public static void nvelocity(long struct, FMOD_VECTOR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VELOCITY, FMOD_VECTOR.SIZEOF);
    }

    public static void nforward(long struct, FMOD_VECTOR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FORWARD, FMOD_VECTOR.SIZEOF);
    }

    public static void nup(long struct, FMOD_VECTOR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)UP, FMOD_VECTOR.SIZEOF);
    }

    static {
        Struct.Layout layout = FMOD_3D_ATTRIBUTES.__struct(FMOD_3D_ATTRIBUTES.__member(FMOD_VECTOR.SIZEOF, FMOD_VECTOR.ALIGNOF), FMOD_3D_ATTRIBUTES.__member(FMOD_VECTOR.SIZEOF, FMOD_VECTOR.ALIGNOF), FMOD_3D_ATTRIBUTES.__member(FMOD_VECTOR.SIZEOF, FMOD_VECTOR.ALIGNOF), FMOD_3D_ATTRIBUTES.__member(FMOD_VECTOR.SIZEOF, FMOD_VECTOR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITION = layout.offsetof(0);
        VELOCITY = layout.offsetof(1);
        FORWARD = layout.offsetof(2);
        UP = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FMOD_3D_ATTRIBUTES, Buffer>
    implements NativeResource {
        private static final FMOD_3D_ATTRIBUTES ELEMENT_FACTORY = FMOD_3D_ATTRIBUTES.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_3D_ATTRIBUTES getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public FMOD_VECTOR position$() {
            return FMOD_3D_ATTRIBUTES.nposition$(this.address());
        }

        public FMOD_VECTOR velocity() {
            return FMOD_3D_ATTRIBUTES.nvelocity(this.address());
        }

        public FMOD_VECTOR forward() {
            return FMOD_3D_ATTRIBUTES.nforward(this.address());
        }

        public FMOD_VECTOR up() {
            return FMOD_3D_ATTRIBUTES.nup(this.address());
        }

        public Buffer position$(FMOD_VECTOR value) {
            FMOD_3D_ATTRIBUTES.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<FMOD_VECTOR> consumer) {
            consumer.accept(this.position$());
            return this;
        }

        public Buffer velocity(FMOD_VECTOR value) {
            FMOD_3D_ATTRIBUTES.nvelocity(this.address(), value);
            return this;
        }

        public Buffer velocity(Consumer<FMOD_VECTOR> consumer) {
            consumer.accept(this.velocity());
            return this;
        }

        public Buffer forward(FMOD_VECTOR value) {
            FMOD_3D_ATTRIBUTES.nforward(this.address(), value);
            return this;
        }

        public Buffer forward(Consumer<FMOD_VECTOR> consumer) {
            consumer.accept(this.forward());
            return this;
        }

        public Buffer up(FMOD_VECTOR value) {
            FMOD_3D_ATTRIBUTES.nup(this.address(), value);
            return this;
        }

        public Buffer up(Consumer<FMOD_VECTOR> consumer) {
            consumer.accept(this.up());
            return this;
        }
    }
}

