/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_3D_ATTRIBUTES;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI
extends Struct<FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMLISTENERS;
    public static final int RELATIVE;
    public static final int WEIGHT;
    public static final int ABSOLUTE;

    protected FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI create(long address, @Nullable ByteBuffer container) {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(address, container);
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int numlisteners() {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nnumlisteners(this.address());
    }

    @NativeType(value="FMOD_3D_ATTRIBUTES[8]")
    public FMOD_3D_ATTRIBUTES.Buffer relative() {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address());
    }

    public FMOD_3D_ATTRIBUTES relative(int index) {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), index);
    }

    @NativeType(value="float[8]")
    public FloatBuffer weight() {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address());
    }

    public float weight(int index) {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), index);
    }

    public FMOD_3D_ATTRIBUTES absolute() {
        return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nabsolute(this.address());
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI numlisteners(int value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nnumlisteners(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI relative(@NativeType(value="FMOD_3D_ATTRIBUTES[8]") FMOD_3D_ATTRIBUTES.Buffer value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI relative(int index, FMOD_3D_ATTRIBUTES value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), index, value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI relative(Consumer<FMOD_3D_ATTRIBUTES.Buffer> consumer) {
        consumer.accept(this.relative());
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI relative(int index, Consumer<FMOD_3D_ATTRIBUTES> consumer) {
        consumer.accept(this.relative(index));
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI weight(@NativeType(value="float[8]") FloatBuffer value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI weight(int index, float value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), index, value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI absolute(FMOD_3D_ATTRIBUTES value) {
        FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nabsolute(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI absolute(Consumer<FMOD_3D_ATTRIBUTES> consumer) {
        consumer.accept(this.absolute());
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI set(int numlisteners, FMOD_3D_ATTRIBUTES.Buffer relative, FloatBuffer weight, FMOD_3D_ATTRIBUTES absolute) {
        this.numlisteners(numlisteners);
        this.relative(relative);
        this.weight(weight);
        this.absolute(absolute);
        return this;
    }

    public FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI set(FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI malloc() {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI calloc() {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI create(long address) {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(address, null);
    }

    public static @Nullable FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI createSafe(long address) {
        return address == 0L ? null : new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI malloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI calloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnumlisteners(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMLISTENERS);
    }

    public static FMOD_3D_ATTRIBUTES.Buffer nrelative(long struct) {
        return FMOD_3D_ATTRIBUTES.create(struct + (long)RELATIVE, 8);
    }

    public static FMOD_3D_ATTRIBUTES nrelative(long struct, int index) {
        return FMOD_3D_ATTRIBUTES.create(struct + (long)RELATIVE + Checks.check(index, 8) * (long)FMOD_3D_ATTRIBUTES.SIZEOF);
    }

    public static FloatBuffer nweight(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)WEIGHT, 8);
    }

    public static float nweight(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)WEIGHT + Checks.check(index, 8) * 4L);
    }

    public static FMOD_3D_ATTRIBUTES nabsolute(long struct) {
        return FMOD_3D_ATTRIBUTES.create(struct + (long)ABSOLUTE);
    }

    public static void nnumlisteners(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUMLISTENERS, value);
    }

    public static void nrelative(long struct, FMOD_3D_ATTRIBUTES.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)RELATIVE, value.remaining() * FMOD_3D_ATTRIBUTES.SIZEOF);
    }

    public static void nrelative(long struct, int index, FMOD_3D_ATTRIBUTES value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RELATIVE + Checks.check(index, 8) * (long)FMOD_3D_ATTRIBUTES.SIZEOF, FMOD_3D_ATTRIBUTES.SIZEOF);
    }

    public static void nweight(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)WEIGHT, value.remaining() * 4);
    }

    public static void nweight(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)WEIGHT + Checks.check(index, 8) * 4L, value);
    }

    public static void nabsolute(long struct, FMOD_3D_ATTRIBUTES value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ABSOLUTE, FMOD_3D_ATTRIBUTES.SIZEOF);
    }

    static {
        Struct.Layout layout = FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__struct(FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__member(4), FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__array(FMOD_3D_ATTRIBUTES.SIZEOF, FMOD_3D_ATTRIBUTES.ALIGNOF, 8), FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__array(4, 8), FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.__member(FMOD_3D_ATTRIBUTES.SIZEOF, FMOD_3D_ATTRIBUTES.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMLISTENERS = layout.offsetof(0);
        RELATIVE = layout.offsetof(1);
        WEIGHT = layout.offsetof(2);
        ABSOLUTE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI, Buffer>
    implements NativeResource {
        private static final FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI ELEMENT_FACTORY = FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int numlisteners() {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nnumlisteners(this.address());
        }

        @NativeType(value="FMOD_3D_ATTRIBUTES[8]")
        public FMOD_3D_ATTRIBUTES.Buffer relative() {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address());
        }

        public FMOD_3D_ATTRIBUTES relative(int index) {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), index);
        }

        @NativeType(value="float[8]")
        public FloatBuffer weight() {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address());
        }

        public float weight(int index) {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), index);
        }

        public FMOD_3D_ATTRIBUTES absolute() {
            return FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nabsolute(this.address());
        }

        public Buffer numlisteners(int value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nnumlisteners(this.address(), value);
            return this;
        }

        public Buffer relative(@NativeType(value="FMOD_3D_ATTRIBUTES[8]") FMOD_3D_ATTRIBUTES.Buffer value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), value);
            return this;
        }

        public Buffer relative(int index, FMOD_3D_ATTRIBUTES value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nrelative(this.address(), index, value);
            return this;
        }

        public Buffer relative(Consumer<FMOD_3D_ATTRIBUTES.Buffer> consumer) {
            consumer.accept(this.relative());
            return this;
        }

        public Buffer relative(int index, Consumer<FMOD_3D_ATTRIBUTES> consumer) {
            consumer.accept(this.relative(index));
            return this;
        }

        public Buffer weight(@NativeType(value="float[8]") FloatBuffer value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), value);
            return this;
        }

        public Buffer weight(int index, float value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nweight(this.address(), index, value);
            return this;
        }

        public Buffer absolute(FMOD_3D_ATTRIBUTES value) {
            FMOD_DSP_PARAMETER_3DATTRIBUTES_MULTI.nabsolute(this.address(), value);
            return this;
        }

        public Buffer absolute(Consumer<FMOD_3D_ATTRIBUTES> consumer) {
            consumer.accept(this.absolute());
            return this;
        }
    }
}

