/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_DSP_PARAMETER_FFT
extends Struct<FMOD_DSP_PARAMETER_FFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int NUMCHANNELS;
    public static final int SPECTRUM;

    protected FMOD_DSP_PARAMETER_FFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_DSP_PARAMETER_FFT create(long address, @Nullable ByteBuffer container) {
        return new FMOD_DSP_PARAMETER_FFT(address, container);
    }

    public FMOD_DSP_PARAMETER_FFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_DSP_PARAMETER_FFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int length() {
        return FMOD_DSP_PARAMETER_FFT.nlength(this.address());
    }

    public int numchannels() {
        return FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address());
    }

    @NativeType(value="float *[32]")
    public PointerBuffer spectrum() {
        return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address());
    }

    @NativeType(value="float *")
    public long spectrum(int index) {
        return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index);
    }

    public FMOD_DSP_PARAMETER_FFT length(int value) {
        FMOD_DSP_PARAMETER_FFT.nlength(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT numchannels(int value) {
        FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT spectrum(@NativeType(value="float *[32]") PointerBuffer value) {
        FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), value);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT spectrum(int index, @NativeType(value="float *") FloatBuffer value) {
        FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index, MemoryUtil.memAddressSafe(value));
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT set(int length, int numchannels, PointerBuffer spectrum) {
        this.length(length);
        this.numchannels(numchannels);
        this.spectrum(spectrum);
        return this;
    }

    public FMOD_DSP_PARAMETER_FFT set(FMOD_DSP_PARAMETER_FFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_DSP_PARAMETER_FFT malloc() {
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT calloc() {
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_DSP_PARAMETER_FFT(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_DSP_PARAMETER_FFT create(long address) {
        return new FMOD_DSP_PARAMETER_FFT(address, null);
    }

    public static @Nullable FMOD_DSP_PARAMETER_FFT createSafe(long address) {
        return address == 0L ? null : new FMOD_DSP_PARAMETER_FFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_DSP_PARAMETER_FFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_DSP_PARAMETER_FFT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_DSP_PARAMETER_FFT malloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_FFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_DSP_PARAMETER_FFT calloc(MemoryStack stack) {
        return new FMOD_DSP_PARAMETER_FFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LENGTH);
    }

    public static int nnumchannels(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMCHANNELS);
    }

    public static PointerBuffer nspectrum(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)SPECTRUM, 32);
    }

    public static long nspectrum(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)SPECTRUM + Checks.check(index, 32) * (long)POINTER_SIZE);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LENGTH, value);
    }

    public static void nnumchannels(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUMCHANNELS, value);
    }

    public static void nspectrum(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 32);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SPECTRUM, value.remaining() * POINTER_SIZE);
    }

    public static void nspectrum(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)SPECTRUM + Checks.check(index, 32) * (long)POINTER_SIZE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SPECTRUM));
    }

    static {
        Struct.Layout layout = FMOD_DSP_PARAMETER_FFT.__struct(FMOD_DSP_PARAMETER_FFT.__member(4), FMOD_DSP_PARAMETER_FFT.__member(4), FMOD_DSP_PARAMETER_FFT.__array(POINTER_SIZE, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        NUMCHANNELS = layout.offsetof(1);
        SPECTRUM = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<FMOD_DSP_PARAMETER_FFT, Buffer>
    implements NativeResource {
        private static final FMOD_DSP_PARAMETER_FFT ELEMENT_FACTORY = FMOD_DSP_PARAMETER_FFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_DSP_PARAMETER_FFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int length() {
            return FMOD_DSP_PARAMETER_FFT.nlength(this.address());
        }

        public int numchannels() {
            return FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address());
        }

        @NativeType(value="float *[32]")
        public PointerBuffer spectrum() {
            return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address());
        }

        @NativeType(value="float *")
        public long spectrum(int index) {
            return FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index);
        }

        public Buffer length(int value) {
            FMOD_DSP_PARAMETER_FFT.nlength(this.address(), value);
            return this;
        }

        public Buffer numchannels(int value) {
            FMOD_DSP_PARAMETER_FFT.nnumchannels(this.address(), value);
            return this;
        }

        public Buffer spectrum(@NativeType(value="float *[32]") PointerBuffer value) {
            FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), value);
            return this;
        }

        public Buffer spectrum(int index, @NativeType(value="float *") FloatBuffer value) {
            FMOD_DSP_PARAMETER_FFT.nspectrum(this.address(), index, MemoryUtil.memAddressSafe(value));
            return this;
        }
    }
}

