/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_GUID
extends Struct<FMOD_GUID>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA1;
    public static final int DATA2;
    public static final int DATA3;
    public static final int DATA4;

    protected FMOD_GUID(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_GUID create(long address, @Nullable ByteBuffer container) {
        return new FMOD_GUID(address, container);
    }

    public FMOD_GUID(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_GUID.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int Data1() {
        return FMOD_GUID.nData1(this.address());
    }

    @NativeType(value="unsigned short")
    public short Data2() {
        return FMOD_GUID.nData2(this.address());
    }

    @NativeType(value="unsigned short")
    public short Data3() {
        return FMOD_GUID.nData3(this.address());
    }

    @NativeType(value="unsigned char[8]")
    public ByteBuffer Data4() {
        return FMOD_GUID.nData4(this.address());
    }

    @NativeType(value="unsigned char")
    public byte Data4(int index) {
        return FMOD_GUID.nData4(this.address(), index);
    }

    public FMOD_GUID Data1(@NativeType(value="unsigned int") int value) {
        FMOD_GUID.nData1(this.address(), value);
        return this;
    }

    public FMOD_GUID Data2(@NativeType(value="unsigned short") short value) {
        FMOD_GUID.nData2(this.address(), value);
        return this;
    }

    public FMOD_GUID Data3(@NativeType(value="unsigned short") short value) {
        FMOD_GUID.nData3(this.address(), value);
        return this;
    }

    public FMOD_GUID Data4(@NativeType(value="unsigned char[8]") ByteBuffer value) {
        FMOD_GUID.nData4(this.address(), value);
        return this;
    }

    public FMOD_GUID Data4(int index, @NativeType(value="unsigned char") byte value) {
        FMOD_GUID.nData4(this.address(), index, value);
        return this;
    }

    public FMOD_GUID set(int Data1, short Data2, short Data3, ByteBuffer Data4) {
        this.Data1(Data1);
        this.Data2(Data2);
        this.Data3(Data3);
        this.Data4(Data4);
        return this;
    }

    public FMOD_GUID set(FMOD_GUID src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_GUID malloc() {
        return new FMOD_GUID(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_GUID calloc() {
        return new FMOD_GUID(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_GUID create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_GUID(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_GUID create(long address) {
        return new FMOD_GUID(address, null);
    }

    public static @Nullable FMOD_GUID createSafe(long address) {
        return address == 0L ? null : new FMOD_GUID(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_GUID.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_GUID.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_GUID malloc(MemoryStack stack) {
        return new FMOD_GUID(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_GUID calloc(MemoryStack stack) {
        return new FMOD_GUID(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nData1(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DATA1);
    }

    public static short nData2(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DATA2);
    }

    public static short nData3(long struct) {
        return MemoryUtil.memGetShort(struct + (long)DATA3);
    }

    public static ByteBuffer nData4(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DATA4, 8);
    }

    public static byte nData4(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DATA4 + Checks.check(index, 8) * 1L);
    }

    public static void nData1(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DATA1, value);
    }

    public static void nData2(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)DATA2, value);
    }

    public static void nData3(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)DATA3, value);
    }

    public static void nData4(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DATA4, value.remaining() * 1);
    }

    public static void nData4(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)DATA4 + Checks.check(index, 8) * 1L, value);
    }

    static {
        Struct.Layout layout = FMOD_GUID.__struct(FMOD_GUID.__member(4), FMOD_GUID.__member(2), FMOD_GUID.__member(2), FMOD_GUID.__array(1, 8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA1 = layout.offsetof(0);
        DATA2 = layout.offsetof(1);
        DATA3 = layout.offsetof(2);
        DATA4 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<FMOD_GUID, Buffer>
    implements NativeResource {
        private static final FMOD_GUID ELEMENT_FACTORY = FMOD_GUID.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_GUID getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int Data1() {
            return FMOD_GUID.nData1(this.address());
        }

        @NativeType(value="unsigned short")
        public short Data2() {
            return FMOD_GUID.nData2(this.address());
        }

        @NativeType(value="unsigned short")
        public short Data3() {
            return FMOD_GUID.nData3(this.address());
        }

        @NativeType(value="unsigned char[8]")
        public ByteBuffer Data4() {
            return FMOD_GUID.nData4(this.address());
        }

        @NativeType(value="unsigned char")
        public byte Data4(int index) {
            return FMOD_GUID.nData4(this.address(), index);
        }

        public Buffer Data1(@NativeType(value="unsigned int") int value) {
            FMOD_GUID.nData1(this.address(), value);
            return this;
        }

        public Buffer Data2(@NativeType(value="unsigned short") short value) {
            FMOD_GUID.nData2(this.address(), value);
            return this;
        }

        public Buffer Data3(@NativeType(value="unsigned short") short value) {
            FMOD_GUID.nData3(this.address(), value);
            return this;
        }

        public Buffer Data4(@NativeType(value="unsigned char[8]") ByteBuffer value) {
            FMOD_GUID.nData4(this.address(), value);
            return this;
        }

        public Buffer Data4(int index, @NativeType(value="unsigned char") byte value) {
            FMOD_GUID.nData4(this.address(), index, value);
            return this;
        }
    }
}

