/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_PLUGINLIST
extends Struct<FMOD_PLUGINLIST>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DESCRIPTION;

    protected FMOD_PLUGINLIST(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_PLUGINLIST create(long address, @Nullable ByteBuffer container) {
        return new FMOD_PLUGINLIST(address, container);
    }

    public FMOD_PLUGINLIST(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_PLUGINLIST.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FMOD_PLUGINTYPE")
    public int type() {
        return FMOD_PLUGINLIST.ntype(this.address());
    }

    @NativeType(value="void *")
    public long description() {
        return FMOD_PLUGINLIST.ndescription(this.address());
    }

    public FMOD_PLUGINLIST type(@NativeType(value="FMOD_PLUGINTYPE") int value) {
        FMOD_PLUGINLIST.ntype(this.address(), value);
        return this;
    }

    public FMOD_PLUGINLIST description(@NativeType(value="void *") long value) {
        FMOD_PLUGINLIST.ndescription(this.address(), value);
        return this;
    }

    public FMOD_PLUGINLIST set(int type, long description) {
        this.type(type);
        this.description(description);
        return this;
    }

    public FMOD_PLUGINLIST set(FMOD_PLUGINLIST src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_PLUGINLIST malloc() {
        return new FMOD_PLUGINLIST(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_PLUGINLIST calloc() {
        return new FMOD_PLUGINLIST(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_PLUGINLIST create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_PLUGINLIST(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_PLUGINLIST create(long address) {
        return new FMOD_PLUGINLIST(address, null);
    }

    public static @Nullable FMOD_PLUGINLIST createSafe(long address) {
        return address == 0L ? null : new FMOD_PLUGINLIST(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_PLUGINLIST.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_PLUGINLIST.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_PLUGINLIST malloc(MemoryStack stack) {
        return new FMOD_PLUGINLIST(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_PLUGINLIST calloc(MemoryStack stack) {
        return new FMOD_PLUGINLIST(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long ndescription(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DESCRIPTION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndescription(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DESCRIPTION, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    static {
        Struct.Layout layout = FMOD_PLUGINLIST.__struct(FMOD_PLUGINLIST.__member(4), FMOD_PLUGINLIST.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DESCRIPTION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<FMOD_PLUGINLIST, Buffer>
    implements NativeResource {
        private static final FMOD_PLUGINLIST ELEMENT_FACTORY = FMOD_PLUGINLIST.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_PLUGINLIST getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FMOD_PLUGINTYPE")
        public int type() {
            return FMOD_PLUGINLIST.ntype(this.address());
        }

        @NativeType(value="void *")
        public long description() {
            return FMOD_PLUGINLIST.ndescription(this.address());
        }

        public Buffer type(@NativeType(value="FMOD_PLUGINTYPE") int value) {
            FMOD_PLUGINLIST.ntype(this.address(), value);
            return this;
        }

        public Buffer description(@NativeType(value="void *") long value) {
            FMOD_PLUGINLIST.ndescription(this.address(), value);
            return this;
        }
    }
}

