/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod.FMOD_GUID;
import org.lwjgl.fmod.FMOD_STUDIO_PARAMETER_ID;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_STUDIO_PARAMETER_DESCRIPTION
extends Struct<FMOD_STUDIO_PARAMETER_DESCRIPTION>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int ID;
    public static final int MINIMUM;
    public static final int MAXIMUM;
    public static final int DEFAULTVALUE;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int GUID;

    protected FMOD_STUDIO_PARAMETER_DESCRIPTION(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_STUDIO_PARAMETER_DESCRIPTION create(long address, @Nullable ByteBuffer container) {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(address, container);
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_STUDIO_PARAMETER_DESCRIPTION.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nnameString(this.address());
    }

    public FMOD_STUDIO_PARAMETER_ID id() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nid(this.address());
    }

    public float minimum() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nminimum(this.address());
    }

    public float maximum() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nmaximum(this.address());
    }

    public float defaultvalue() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.ndefaultvalue(this.address());
    }

    @NativeType(value="FMOD_STUDIO_PARAMETER_TYPE")
    public int type() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.ntype(this.address());
    }

    @NativeType(value="FMOD_STUDIO_PARAMETER_FLAGS")
    public int flags() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nflags(this.address());
    }

    public FMOD_GUID guid() {
        return FMOD_STUDIO_PARAMETER_DESCRIPTION.nguid(this.address());
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION name(@NativeType(value="char const *") ByteBuffer value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nname(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION id(FMOD_STUDIO_PARAMETER_ID value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nid(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION id(Consumer<FMOD_STUDIO_PARAMETER_ID> consumer) {
        consumer.accept(this.id());
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION minimum(float value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nminimum(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION maximum(float value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nmaximum(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION defaultvalue(float value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.ndefaultvalue(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION type(@NativeType(value="FMOD_STUDIO_PARAMETER_TYPE") int value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.ntype(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION flags(@NativeType(value="FMOD_STUDIO_PARAMETER_FLAGS") int value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nflags(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION guid(FMOD_GUID value) {
        FMOD_STUDIO_PARAMETER_DESCRIPTION.nguid(this.address(), value);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION guid(Consumer<FMOD_GUID> consumer) {
        consumer.accept(this.guid());
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION set(ByteBuffer name, FMOD_STUDIO_PARAMETER_ID id, float minimum, float maximum, float defaultvalue, int type, int flags, FMOD_GUID guid) {
        this.name(name);
        this.id(id);
        this.minimum(minimum);
        this.maximum(maximum);
        this.defaultvalue(defaultvalue);
        this.type(type);
        this.flags(flags);
        this.guid(guid);
        return this;
    }

    public FMOD_STUDIO_PARAMETER_DESCRIPTION set(FMOD_STUDIO_PARAMETER_DESCRIPTION src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION malloc() {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION calloc() {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION create(long address) {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(address, null);
    }

    public static @Nullable FMOD_STUDIO_PARAMETER_DESCRIPTION createSafe(long address) {
        return address == 0L ? null : new FMOD_STUDIO_PARAMETER_DESCRIPTION(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_STUDIO_PARAMETER_DESCRIPTION.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_STUDIO_PARAMETER_DESCRIPTION.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION malloc(MemoryStack stack) {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_STUDIO_PARAMETER_DESCRIPTION calloc(MemoryStack stack) {
        return new FMOD_STUDIO_PARAMETER_DESCRIPTION(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static FMOD_STUDIO_PARAMETER_ID nid(long struct) {
        return FMOD_STUDIO_PARAMETER_ID.create(struct + (long)ID);
    }

    public static float nminimum(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINIMUM);
    }

    public static float nmaximum(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXIMUM);
    }

    public static float ndefaultvalue(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEFAULTVALUE);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static FMOD_GUID nguid(long struct) {
        return FMOD_GUID.create(struct + (long)GUID);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void nid(long struct, FMOD_STUDIO_PARAMETER_ID value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ID, FMOD_STUDIO_PARAMETER_ID.SIZEOF);
    }

    public static void nminimum(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINIMUM, value);
    }

    public static void nmaximum(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXIMUM, value);
    }

    public static void ndefaultvalue(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEFAULTVALUE, value);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nguid(long struct, FMOD_GUID value) {
        MemoryUtil.memCopy(value.address(), struct + (long)GUID, FMOD_GUID.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = FMOD_STUDIO_PARAMETER_DESCRIPTION.__struct(FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(POINTER_SIZE), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(FMOD_STUDIO_PARAMETER_ID.SIZEOF, FMOD_STUDIO_PARAMETER_ID.ALIGNOF), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(4), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(4), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(4), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(4), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(4), FMOD_STUDIO_PARAMETER_DESCRIPTION.__member(FMOD_GUID.SIZEOF, FMOD_GUID.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        ID = layout.offsetof(1);
        MINIMUM = layout.offsetof(2);
        MAXIMUM = layout.offsetof(3);
        DEFAULTVALUE = layout.offsetof(4);
        TYPE = layout.offsetof(5);
        FLAGS = layout.offsetof(6);
        GUID = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<FMOD_STUDIO_PARAMETER_DESCRIPTION, Buffer>
    implements NativeResource {
        private static final FMOD_STUDIO_PARAMETER_DESCRIPTION ELEMENT_FACTORY = FMOD_STUDIO_PARAMETER_DESCRIPTION.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_STUDIO_PARAMETER_DESCRIPTION getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nnameString(this.address());
        }

        public FMOD_STUDIO_PARAMETER_ID id() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nid(this.address());
        }

        public float minimum() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nminimum(this.address());
        }

        public float maximum() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nmaximum(this.address());
        }

        public float defaultvalue() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.ndefaultvalue(this.address());
        }

        @NativeType(value="FMOD_STUDIO_PARAMETER_TYPE")
        public int type() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.ntype(this.address());
        }

        @NativeType(value="FMOD_STUDIO_PARAMETER_FLAGS")
        public int flags() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nflags(this.address());
        }

        public FMOD_GUID guid() {
            return FMOD_STUDIO_PARAMETER_DESCRIPTION.nguid(this.address());
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nname(this.address(), value);
            return this;
        }

        public Buffer id(FMOD_STUDIO_PARAMETER_ID value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nid(this.address(), value);
            return this;
        }

        public Buffer id(Consumer<FMOD_STUDIO_PARAMETER_ID> consumer) {
            consumer.accept(this.id());
            return this;
        }

        public Buffer minimum(float value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nminimum(this.address(), value);
            return this;
        }

        public Buffer maximum(float value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nmaximum(this.address(), value);
            return this;
        }

        public Buffer defaultvalue(float value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.ndefaultvalue(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="FMOD_STUDIO_PARAMETER_TYPE") int value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="FMOD_STUDIO_PARAMETER_FLAGS") int value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nflags(this.address(), value);
            return this;
        }

        public Buffer guid(FMOD_GUID value) {
            FMOD_STUDIO_PARAMETER_DESCRIPTION.nguid(this.address(), value);
            return this;
        }

        public Buffer guid(Consumer<FMOD_GUID> consumer) {
            consumer.accept(this.guid());
            return this;
        }
    }
}

