/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_TAG
extends Struct<FMOD_TAG>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DATATYPE;
    public static final int NAME;
    public static final int DATA;
    public static final int DATALEN;
    public static final int UPDATED;

    protected FMOD_TAG(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_TAG create(long address, @Nullable ByteBuffer container) {
        return new FMOD_TAG(address, container);
    }

    public FMOD_TAG(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_TAG.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FMOD_TAGTYPE")
    public int type() {
        return FMOD_TAG.ntype(this.address());
    }

    @NativeType(value="FMOD_TAGDATATYPE")
    public int datatype() {
        return FMOD_TAG.ndatatype(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer name() {
        return FMOD_TAG.nname(this.address());
    }

    @NativeType(value="char *")
    public String nameString() {
        return FMOD_TAG.nnameString(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer data() {
        return FMOD_TAG.ndata(this.address());
    }

    @NativeType(value="unsigned int")
    public int datalen() {
        return FMOD_TAG.ndatalen(this.address());
    }

    @NativeType(value="FMOD_BOOL")
    public int updated() {
        return FMOD_TAG.nupdated(this.address());
    }

    public FMOD_TAG type(@NativeType(value="FMOD_TAGTYPE") int value) {
        FMOD_TAG.ntype(this.address(), value);
        return this;
    }

    public FMOD_TAG datatype(@NativeType(value="FMOD_TAGDATATYPE") int value) {
        FMOD_TAG.ndatatype(this.address(), value);
        return this;
    }

    public FMOD_TAG name(@NativeType(value="char *") ByteBuffer value) {
        FMOD_TAG.nname(this.address(), value);
        return this;
    }

    public FMOD_TAG data(@NativeType(value="void *") ByteBuffer value) {
        FMOD_TAG.ndata(this.address(), value);
        return this;
    }

    public FMOD_TAG updated(@NativeType(value="FMOD_BOOL") int value) {
        FMOD_TAG.nupdated(this.address(), value);
        return this;
    }

    public FMOD_TAG set(int type, int datatype, ByteBuffer name, ByteBuffer data, int updated) {
        this.type(type);
        this.datatype(datatype);
        this.name(name);
        this.data(data);
        this.updated(updated);
        return this;
    }

    public FMOD_TAG set(FMOD_TAG src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_TAG malloc() {
        return new FMOD_TAG(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_TAG calloc() {
        return new FMOD_TAG(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_TAG create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_TAG(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_TAG create(long address) {
        return new FMOD_TAG(address, null);
    }

    public static @Nullable FMOD_TAG createSafe(long address) {
        return address == 0L ? null : new FMOD_TAG(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_TAG.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_TAG.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_TAG malloc(MemoryStack stack) {
        return new FMOD_TAG(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_TAG calloc(MemoryStack stack) {
        return new FMOD_TAG(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static int ndatatype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DATATYPE);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), FMOD_TAG.ndatalen(struct));
    }

    public static int ndatalen(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DATALEN);
    }

    public static int nupdated(long struct) {
        return MemoryUtil.memGetInt(struct + (long)UPDATED);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TYPE, value);
    }

    public static void ndatatype(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DATATYPE, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        FMOD_TAG.ndatalen(struct, value.remaining());
    }

    public static void ndatalen(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DATALEN, value);
    }

    public static void nupdated(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)UPDATED, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = FMOD_TAG.__struct(FMOD_TAG.__member(4), FMOD_TAG.__member(4), FMOD_TAG.__member(POINTER_SIZE), FMOD_TAG.__member(POINTER_SIZE), FMOD_TAG.__member(4), FMOD_TAG.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DATATYPE = layout.offsetof(1);
        NAME = layout.offsetof(2);
        DATA = layout.offsetof(3);
        DATALEN = layout.offsetof(4);
        UPDATED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<FMOD_TAG, Buffer>
    implements NativeResource {
        private static final FMOD_TAG ELEMENT_FACTORY = FMOD_TAG.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_TAG getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FMOD_TAGTYPE")
        public int type() {
            return FMOD_TAG.ntype(this.address());
        }

        @NativeType(value="FMOD_TAGDATATYPE")
        public int datatype() {
            return FMOD_TAG.ndatatype(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer name() {
            return FMOD_TAG.nname(this.address());
        }

        @NativeType(value="char *")
        public String nameString() {
            return FMOD_TAG.nnameString(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer data() {
            return FMOD_TAG.ndata(this.address());
        }

        @NativeType(value="unsigned int")
        public int datalen() {
            return FMOD_TAG.ndatalen(this.address());
        }

        @NativeType(value="FMOD_BOOL")
        public int updated() {
            return FMOD_TAG.nupdated(this.address());
        }

        public Buffer type(@NativeType(value="FMOD_TAGTYPE") int value) {
            FMOD_TAG.ntype(this.address(), value);
            return this;
        }

        public Buffer datatype(@NativeType(value="FMOD_TAGDATATYPE") int value) {
            FMOD_TAG.ndatatype(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char *") ByteBuffer value) {
            FMOD_TAG.nname(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="void *") ByteBuffer value) {
            FMOD_TAG.ndata(this.address(), value);
            return this;
        }

        public Buffer updated(@NativeType(value="FMOD_BOOL") int value) {
            FMOD_TAG.nupdated(this.address(), value);
            return this;
        }
    }
}

