/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_VECTOR
extends Struct<FMOD_VECTOR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected FMOD_VECTOR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FMOD_VECTOR create(long address, @Nullable ByteBuffer container) {
        return new FMOD_VECTOR(address, container);
    }

    public FMOD_VECTOR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), FMOD_VECTOR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return FMOD_VECTOR.nx(this.address());
    }

    public float y() {
        return FMOD_VECTOR.ny(this.address());
    }

    public float z() {
        return FMOD_VECTOR.nz(this.address());
    }

    public FMOD_VECTOR x(float value) {
        FMOD_VECTOR.nx(this.address(), value);
        return this;
    }

    public FMOD_VECTOR y(float value) {
        FMOD_VECTOR.ny(this.address(), value);
        return this;
    }

    public FMOD_VECTOR z(float value) {
        FMOD_VECTOR.nz(this.address(), value);
        return this;
    }

    public FMOD_VECTOR set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public FMOD_VECTOR set(FMOD_VECTOR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static FMOD_VECTOR malloc() {
        return new FMOD_VECTOR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static FMOD_VECTOR calloc() {
        return new FMOD_VECTOR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static FMOD_VECTOR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new FMOD_VECTOR(MemoryUtil.memAddress(container), container);
    }

    public static FMOD_VECTOR create(long address) {
        return new FMOD_VECTOR(address, null);
    }

    public static @Nullable FMOD_VECTOR createSafe(long address) {
        return address == 0L ? null : new FMOD_VECTOR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(FMOD_VECTOR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_VECTOR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_VECTOR malloc(MemoryStack stack) {
        return new FMOD_VECTOR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_VECTOR calloc(MemoryStack stack) {
        return new FMOD_VECTOR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = FMOD_VECTOR.__struct(FMOD_VECTOR.__member(4), FMOD_VECTOR.__member(4), FMOD_VECTOR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<FMOD_VECTOR, Buffer>
    implements NativeResource {
        private static final FMOD_VECTOR ELEMENT_FACTORY = FMOD_VECTOR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected FMOD_VECTOR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return FMOD_VECTOR.nx(this.address());
        }

        public float y() {
            return FMOD_VECTOR.ny(this.address());
        }

        public float z() {
            return FMOD_VECTOR.nz(this.address());
        }

        public Buffer x(float value) {
            FMOD_VECTOR.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            FMOD_VECTOR.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            FMOD_VECTOR.nz(this.address(), value);
            return this;
        }
    }
}

