/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCursor
extends Struct<CXCursor>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int XDATA;
    public static final int DATA;

    protected CXCursor(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXCursor create(long address, @Nullable ByteBuffer container) {
        return new CXCursor(address, container);
    }

    public CXCursor(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXCursor.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXCursorKind")
    public int kind() {
        return CXCursor.nkind(this.address());
    }

    public int xdata() {
        return CXCursor.nxdata(this.address());
    }

    @NativeType(value="void const *[3]")
    public PointerBuffer data() {
        return CXCursor.ndata(this.address());
    }

    @NativeType(value="void const *")
    public long data(int index) {
        return CXCursor.ndata(this.address(), index);
    }

    public static CXCursor malloc() {
        return new CXCursor(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXCursor calloc() {
        return new CXCursor(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXCursor create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXCursor(MemoryUtil.memAddress(container), container);
    }

    public static CXCursor create(long address) {
        return new CXCursor(address, null);
    }

    public static @Nullable CXCursor createSafe(long address) {
        return address == 0L ? null : new CXCursor(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXCursor.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCursor.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXCursor mallocStack() {
        return CXCursor.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursor callocStack() {
        return CXCursor.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCursor mallocStack(MemoryStack stack) {
        return CXCursor.malloc(stack);
    }

    @Deprecated
    public static CXCursor callocStack(MemoryStack stack) {
        return CXCursor.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCursor.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCursor.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCursor.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCursor.calloc(capacity, stack);
    }

    public static CXCursor malloc(MemoryStack stack) {
        return new CXCursor(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXCursor calloc(MemoryStack stack) {
        return new CXCursor(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KIND);
    }

    public static int nxdata(long struct) {
        return MemoryUtil.memGetInt(struct + (long)XDATA);
    }

    public static PointerBuffer ndata(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)DATA, 3);
    }

    public static long ndata(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)DATA + Checks.check(index, 3) * (long)POINTER_SIZE);
    }

    static {
        Struct.Layout layout = CXCursor.__struct(CXCursor.__member(4), CXCursor.__member(4), CXCursor.__array(POINTER_SIZE, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        XDATA = layout.offsetof(1);
        DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXCursor, Buffer>
    implements NativeResource {
        private static final CXCursor ELEMENT_FACTORY = CXCursor.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXCursor getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXCursorKind")
        public int kind() {
            return CXCursor.nkind(this.address());
        }

        public int xdata() {
            return CXCursor.nxdata(this.address());
        }

        @NativeType(value="void const *[3]")
        public PointerBuffer data() {
            return CXCursor.ndata(this.address());
        }

        @NativeType(value="void const *")
        public long data(int index) {
            return CXCursor.ndata(this.address(), index);
        }
    }
}

