/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxContainerInfo;
import org.lwjgl.llvm.CXIdxEntityInfo;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxDeclInfo
extends Struct<CXIdxDeclInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ENTITYINFO;
    public static final int CURSOR;
    public static final int LOC;
    public static final int SEMANTICCONTAINER;
    public static final int LEXICALCONTAINER;
    public static final int ISREDECLARATION;
    public static final int ISDEFINITION;
    public static final int ISCONTAINER;
    public static final int DECLASCONTAINER;
    public static final int ISIMPLICIT;
    public static final int ATTRIBUTES;
    public static final int NUMATTRIBUTES;
    public static final int FLAGS;

    protected CXIdxDeclInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxDeclInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxDeclInfo(address, container);
    }

    public CXIdxDeclInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxDeclInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityInfo const *")
    public CXIdxEntityInfo entityInfo() {
        return CXIdxDeclInfo.nentityInfo(this.address());
    }

    public CXCursor cursor() {
        return CXIdxDeclInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxDeclInfo.nloc(this.address());
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo semanticContainer() {
        return CXIdxDeclInfo.nsemanticContainer(this.address());
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo lexicalContainer() {
        return CXIdxDeclInfo.nlexicalContainer(this.address());
    }

    @NativeType(value="int")
    public boolean isRedeclaration() {
        return CXIdxDeclInfo.nisRedeclaration(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isDefinition() {
        return CXIdxDeclInfo.nisDefinition(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isContainer() {
        return CXIdxDeclInfo.nisContainer(this.address()) != 0;
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo declAsContainer() {
        return CXIdxDeclInfo.ndeclAsContainer(this.address());
    }

    @NativeType(value="int")
    public boolean isImplicit() {
        return CXIdxDeclInfo.nisImplicit(this.address()) != 0;
    }

    @NativeType(value="CXIdxAttrInfo const * const *")
    public PointerBuffer attributes() {
        return CXIdxDeclInfo.nattributes(this.address());
    }

    @NativeType(value="unsigned")
    public int numAttributes() {
        return CXIdxDeclInfo.nnumAttributes(this.address());
    }

    @NativeType(value="unsigned")
    public int flags() {
        return CXIdxDeclInfo.nflags(this.address());
    }

    public static CXIdxDeclInfo malloc() {
        return new CXIdxDeclInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXIdxDeclInfo calloc() {
        return new CXIdxDeclInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXIdxDeclInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXIdxDeclInfo(MemoryUtil.memAddress(container), container);
    }

    public static CXIdxDeclInfo create(long address) {
        return new CXIdxDeclInfo(address, null);
    }

    public static @Nullable CXIdxDeclInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxDeclInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXIdxDeclInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxDeclInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXIdxDeclInfo mallocStack() {
        return CXIdxDeclInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxDeclInfo callocStack() {
        return CXIdxDeclInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxDeclInfo mallocStack(MemoryStack stack) {
        return CXIdxDeclInfo.malloc(stack);
    }

    @Deprecated
    public static CXIdxDeclInfo callocStack(MemoryStack stack) {
        return CXIdxDeclInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxDeclInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxDeclInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxDeclInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxDeclInfo.calloc(capacity, stack);
    }

    public static CXIdxDeclInfo malloc(MemoryStack stack) {
        return new CXIdxDeclInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXIdxDeclInfo calloc(MemoryStack stack) {
        return new CXIdxDeclInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CXIdxEntityInfo nentityInfo(long struct) {
        return CXIdxEntityInfo.create(MemoryUtil.memGetAddress(struct + (long)ENTITYINFO));
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    public static CXIdxContainerInfo nsemanticContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress(struct + (long)SEMANTICCONTAINER));
    }

    public static CXIdxContainerInfo nlexicalContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress(struct + (long)LEXICALCONTAINER));
    }

    public static int nisRedeclaration(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISREDECLARATION);
    }

    public static int nisDefinition(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISDEFINITION);
    }

    public static int nisContainer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISCONTAINER);
    }

    public static CXIdxContainerInfo ndeclAsContainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress(struct + (long)DECLASCONTAINER));
    }

    public static int nisImplicit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISIMPLICIT);
    }

    public static PointerBuffer nattributes(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ATTRIBUTES), CXIdxDeclInfo.nnumAttributes(struct));
    }

    public static int nnumAttributes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMATTRIBUTES);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = CXIdxDeclInfo.__struct(CXIdxDeclInfo.__member(POINTER_SIZE), CXIdxDeclInfo.__member(CXCursor.SIZEOF, CXCursor.ALIGNOF), CXIdxDeclInfo.__member(CXIdxLoc.SIZEOF, CXIdxLoc.ALIGNOF), CXIdxDeclInfo.__member(POINTER_SIZE), CXIdxDeclInfo.__member(POINTER_SIZE), CXIdxDeclInfo.__member(4), CXIdxDeclInfo.__member(4), CXIdxDeclInfo.__member(4), CXIdxDeclInfo.__member(POINTER_SIZE), CXIdxDeclInfo.__member(4), CXIdxDeclInfo.__member(POINTER_SIZE), CXIdxDeclInfo.__member(4), CXIdxDeclInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ENTITYINFO = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
        SEMANTICCONTAINER = layout.offsetof(3);
        LEXICALCONTAINER = layout.offsetof(4);
        ISREDECLARATION = layout.offsetof(5);
        ISDEFINITION = layout.offsetof(6);
        ISCONTAINER = layout.offsetof(7);
        DECLASCONTAINER = layout.offsetof(8);
        ISIMPLICIT = layout.offsetof(9);
        ATTRIBUTES = layout.offsetof(10);
        NUMATTRIBUTES = layout.offsetof(11);
        FLAGS = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<CXIdxDeclInfo, Buffer>
    implements NativeResource {
        private static final CXIdxDeclInfo ELEMENT_FACTORY = CXIdxDeclInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxDeclInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityInfo const *")
        public CXIdxEntityInfo entityInfo() {
            return CXIdxDeclInfo.nentityInfo(this.address());
        }

        public CXCursor cursor() {
            return CXIdxDeclInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxDeclInfo.nloc(this.address());
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo semanticContainer() {
            return CXIdxDeclInfo.nsemanticContainer(this.address());
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo lexicalContainer() {
            return CXIdxDeclInfo.nlexicalContainer(this.address());
        }

        @NativeType(value="int")
        public boolean isRedeclaration() {
            return CXIdxDeclInfo.nisRedeclaration(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isDefinition() {
            return CXIdxDeclInfo.nisDefinition(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isContainer() {
            return CXIdxDeclInfo.nisContainer(this.address()) != 0;
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo declAsContainer() {
            return CXIdxDeclInfo.ndeclAsContainer(this.address());
        }

        @NativeType(value="int")
        public boolean isImplicit() {
            return CXIdxDeclInfo.nisImplicit(this.address()) != 0;
        }

        @NativeType(value="CXIdxAttrInfo const * const *")
        public PointerBuffer attributes() {
            return CXIdxDeclInfo.nattributes(this.address());
        }

        @NativeType(value="unsigned")
        public int numAttributes() {
            return CXIdxDeclInfo.nnumAttributes(this.address());
        }

        @NativeType(value="unsigned")
        public int flags() {
            return CXIdxDeclInfo.nflags(this.address());
        }
    }
}

