/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXCursor;
import org.lwjgl.llvm.CXIdxContainerInfo;
import org.lwjgl.llvm.CXIdxEntityInfo;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxEntityRefInfo
extends Struct<CXIdxEntityRefInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int CURSOR;
    public static final int LOC;
    public static final int REFERENCEDENTITY;
    public static final int PARENTENTITY;
    public static final int CONTAINER;
    public static final int ROLE;

    protected CXIdxEntityRefInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxEntityRefInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxEntityRefInfo(address, container);
    }

    public CXIdxEntityRefInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxEntityRefInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxEntityRefKind")
    public int kind() {
        return CXIdxEntityRefInfo.nkind(this.address());
    }

    public CXCursor cursor() {
        return CXIdxEntityRefInfo.ncursor(this.address());
    }

    public CXIdxLoc loc() {
        return CXIdxEntityRefInfo.nloc(this.address());
    }

    @NativeType(value="CXIdxEntityInfo const *")
    public CXIdxEntityInfo referencedEntity() {
        return CXIdxEntityRefInfo.nreferencedEntity(this.address());
    }

    @NativeType(value="CXIdxEntityInfo const *")
    public CXIdxEntityInfo parentEntity() {
        return CXIdxEntityRefInfo.nparentEntity(this.address());
    }

    @NativeType(value="CXIdxContainerInfo const *")
    public CXIdxContainerInfo container() {
        return CXIdxEntityRefInfo.ncontainer(this.address());
    }

    @NativeType(value="CXSymbolRole")
    public int role() {
        return CXIdxEntityRefInfo.nrole(this.address());
    }

    public static CXIdxEntityRefInfo create(long address) {
        return new CXIdxEntityRefInfo(address, null);
    }

    public static @Nullable CXIdxEntityRefInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxEntityRefInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nkind(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KIND);
    }

    public static CXCursor ncursor(long struct) {
        return CXCursor.create(struct + (long)CURSOR);
    }

    public static CXIdxLoc nloc(long struct) {
        return CXIdxLoc.create(struct + (long)LOC);
    }

    public static CXIdxEntityInfo nreferencedEntity(long struct) {
        return CXIdxEntityInfo.create(MemoryUtil.memGetAddress(struct + (long)REFERENCEDENTITY));
    }

    public static CXIdxEntityInfo nparentEntity(long struct) {
        return CXIdxEntityInfo.create(MemoryUtil.memGetAddress(struct + (long)PARENTENTITY));
    }

    public static CXIdxContainerInfo ncontainer(long struct) {
        return CXIdxContainerInfo.create(MemoryUtil.memGetAddress(struct + (long)CONTAINER));
    }

    public static int nrole(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ROLE);
    }

    static {
        Struct.Layout layout = CXIdxEntityRefInfo.__struct(CXIdxEntityRefInfo.__member(4), CXIdxEntityRefInfo.__member(CXCursor.SIZEOF, CXCursor.ALIGNOF), CXIdxEntityRefInfo.__member(CXIdxLoc.SIZEOF, CXIdxLoc.ALIGNOF), CXIdxEntityRefInfo.__member(POINTER_SIZE), CXIdxEntityRefInfo.__member(POINTER_SIZE), CXIdxEntityRefInfo.__member(POINTER_SIZE), CXIdxEntityRefInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        CURSOR = layout.offsetof(1);
        LOC = layout.offsetof(2);
        REFERENCEDENTITY = layout.offsetof(3);
        PARENTENTITY = layout.offsetof(4);
        CONTAINER = layout.offsetof(5);
        ROLE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<CXIdxEntityRefInfo, Buffer> {
        private static final CXIdxEntityRefInfo ELEMENT_FACTORY = CXIdxEntityRefInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxEntityRefInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxEntityRefKind")
        public int kind() {
            return CXIdxEntityRefInfo.nkind(this.address());
        }

        public CXCursor cursor() {
            return CXIdxEntityRefInfo.ncursor(this.address());
        }

        public CXIdxLoc loc() {
            return CXIdxEntityRefInfo.nloc(this.address());
        }

        @NativeType(value="CXIdxEntityInfo const *")
        public CXIdxEntityInfo referencedEntity() {
            return CXIdxEntityRefInfo.nreferencedEntity(this.address());
        }

        @NativeType(value="CXIdxEntityInfo const *")
        public CXIdxEntityInfo parentEntity() {
            return CXIdxEntityRefInfo.nparentEntity(this.address());
        }

        @NativeType(value="CXIdxContainerInfo const *")
        public CXIdxContainerInfo container() {
            return CXIdxEntityRefInfo.ncontainer(this.address());
        }

        @NativeType(value="CXSymbolRole")
        public int role() {
            return CXIdxEntityRefInfo.nrole(this.address());
        }
    }
}

