/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXIdxLoc;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxIncludedFileInfo
extends Struct<CXIdxIncludedFileInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASHLOC;
    public static final int FILENAME;
    public static final int FILE;
    public static final int ISIMPORT;
    public static final int ISANGLED;
    public static final int ISMODULEIMPORT;

    protected CXIdxIncludedFileInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxIncludedFileInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxIncludedFileInfo(address, container);
    }

    public CXIdxIncludedFileInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxIncludedFileInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public CXIdxLoc hashLoc() {
        return CXIdxIncludedFileInfo.nhashLoc(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer filename() {
        return CXIdxIncludedFileInfo.nfilename(this.address());
    }

    @NativeType(value="char const *")
    public String filenameString() {
        return CXIdxIncludedFileInfo.nfilenameString(this.address());
    }

    @NativeType(value="CXFile")
    public long file() {
        return CXIdxIncludedFileInfo.nfile(this.address());
    }

    @NativeType(value="int")
    public boolean isImport() {
        return CXIdxIncludedFileInfo.nisImport(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isAngled() {
        return CXIdxIncludedFileInfo.nisAngled(this.address()) != 0;
    }

    @NativeType(value="int")
    public boolean isModuleImport() {
        return CXIdxIncludedFileInfo.nisModuleImport(this.address()) != 0;
    }

    public static CXIdxIncludedFileInfo create(long address) {
        return new CXIdxIncludedFileInfo(address, null);
    }

    public static @Nullable CXIdxIncludedFileInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxIncludedFileInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CXIdxLoc nhashLoc(long struct) {
        return CXIdxLoc.create(struct + (long)HASHLOC);
    }

    public static ByteBuffer nfilename(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)FILENAME));
    }

    public static String nfilenameString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)FILENAME));
    }

    public static long nfile(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FILE);
    }

    public static int nisImport(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISIMPORT);
    }

    public static int nisAngled(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISANGLED);
    }

    public static int nisModuleImport(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ISMODULEIMPORT);
    }

    static {
        Struct.Layout layout = CXIdxIncludedFileInfo.__struct(CXIdxIncludedFileInfo.__member(CXIdxLoc.SIZEOF, CXIdxLoc.ALIGNOF), CXIdxIncludedFileInfo.__member(POINTER_SIZE), CXIdxIncludedFileInfo.__member(POINTER_SIZE), CXIdxIncludedFileInfo.__member(4), CXIdxIncludedFileInfo.__member(4), CXIdxIncludedFileInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASHLOC = layout.offsetof(0);
        FILENAME = layout.offsetof(1);
        FILE = layout.offsetof(2);
        ISIMPORT = layout.offsetof(3);
        ISANGLED = layout.offsetof(4);
        ISMODULEIMPORT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<CXIdxIncludedFileInfo, Buffer> {
        private static final CXIdxIncludedFileInfo ELEMENT_FACTORY = CXIdxIncludedFileInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxIncludedFileInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CXIdxLoc hashLoc() {
            return CXIdxIncludedFileInfo.nhashLoc(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer filename() {
            return CXIdxIncludedFileInfo.nfilename(this.address());
        }

        @NativeType(value="char const *")
        public String filenameString() {
            return CXIdxIncludedFileInfo.nfilenameString(this.address());
        }

        @NativeType(value="CXFile")
        public long file() {
            return CXIdxIncludedFileInfo.nfile(this.address());
        }

        @NativeType(value="int")
        public boolean isImport() {
            return CXIdxIncludedFileInfo.nisImport(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isAngled() {
            return CXIdxIncludedFileInfo.nisAngled(this.address()) != 0;
        }

        @NativeType(value="int")
        public boolean isModuleImport() {
            return CXIdxIncludedFileInfo.nisModuleImport(this.address()) != 0;
        }
    }
}

