/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.llvm.CXIdxDeclInfo;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxObjCContainerDeclInfo
extends Struct<CXIdxObjCContainerDeclInfo> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DECLINFO;
    public static final int KIND;

    protected CXIdxObjCContainerDeclInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXIdxObjCContainerDeclInfo create(long address, @Nullable ByteBuffer container) {
        return new CXIdxObjCContainerDeclInfo(address, container);
    }

    public CXIdxObjCContainerDeclInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXIdxObjCContainerDeclInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxDeclInfo const *")
    public CXIdxDeclInfo declInfo() {
        return CXIdxObjCContainerDeclInfo.ndeclInfo(this.address());
    }

    @NativeType(value="CXIdxObjCContainerKind")
    public int kind() {
        return CXIdxObjCContainerDeclInfo.nkind(this.address());
    }

    public static CXIdxObjCContainerDeclInfo create(long address) {
        return new CXIdxObjCContainerDeclInfo(address, null);
    }

    public static @Nullable CXIdxObjCContainerDeclInfo createSafe(long address) {
        return address == 0L ? null : new CXIdxObjCContainerDeclInfo(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static CXIdxDeclInfo ndeclInfo(long struct) {
        return CXIdxDeclInfo.create(MemoryUtil.memGetAddress(struct + (long)DECLINFO));
    }

    public static int nkind(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KIND);
    }

    static {
        Struct.Layout layout = CXIdxObjCContainerDeclInfo.__struct(CXIdxObjCContainerDeclInfo.__member(POINTER_SIZE), CXIdxObjCContainerDeclInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DECLINFO = layout.offsetof(0);
        KIND = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXIdxObjCContainerDeclInfo, Buffer> {
        private static final CXIdxObjCContainerDeclInfo ELEMENT_FACTORY = CXIdxObjCContainerDeclInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXIdxObjCContainerDeclInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxDeclInfo const *")
        public CXIdxDeclInfo declInfo() {
            return CXIdxObjCContainerDeclInfo.ndeclInfo(this.address());
        }

        @NativeType(value="CXIdxObjCContainerKind")
        public int kind() {
            return CXIdxObjCContainerDeclInfo.nkind(this.address());
        }
    }
}

