/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct CXUnsavedFile")
public class CXUnsavedFile
extends Struct<CXUnsavedFile>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FILENAME;
    public static final int CONTENTS;
    public static final int LENGTH;

    protected CXUnsavedFile(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected CXUnsavedFile create(long address, @Nullable ByteBuffer container) {
        return new CXUnsavedFile(address, container);
    }

    public CXUnsavedFile(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXUnsavedFile.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer Filename() {
        return CXUnsavedFile.nFilename(this.address());
    }

    @NativeType(value="char const *")
    public String FilenameString() {
        return CXUnsavedFile.nFilenameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer Contents() {
        return CXUnsavedFile.nContents(this.address());
    }

    @NativeType(value="unsigned long")
    public long Length() {
        return CXUnsavedFile.nLength(this.address());
    }

    public CXUnsavedFile Filename(@NativeType(value="char const *") ByteBuffer value) {
        CXUnsavedFile.nFilename(this.address(), value);
        return this;
    }

    public CXUnsavedFile Contents(@NativeType(value="char const *") ByteBuffer value) {
        CXUnsavedFile.nContents(this.address(), value);
        return this;
    }

    public CXUnsavedFile set(ByteBuffer Filename, ByteBuffer Contents) {
        this.Filename(Filename);
        this.Contents(Contents);
        return this;
    }

    public CXUnsavedFile set(CXUnsavedFile src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CXUnsavedFile malloc() {
        return new CXUnsavedFile(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CXUnsavedFile calloc() {
        return new CXUnsavedFile(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CXUnsavedFile create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new CXUnsavedFile(MemoryUtil.memAddress(container), container);
    }

    public static CXUnsavedFile create(long address) {
        return new CXUnsavedFile(address, null);
    }

    public static @Nullable CXUnsavedFile createSafe(long address) {
        return address == 0L ? null : new CXUnsavedFile(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CXUnsavedFile.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXUnsavedFile.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXUnsavedFile mallocStack() {
        return CXUnsavedFile.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXUnsavedFile callocStack() {
        return CXUnsavedFile.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXUnsavedFile mallocStack(MemoryStack stack) {
        return CXUnsavedFile.malloc(stack);
    }

    @Deprecated
    public static CXUnsavedFile callocStack(MemoryStack stack) {
        return CXUnsavedFile.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXUnsavedFile.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXUnsavedFile.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXUnsavedFile.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXUnsavedFile.calloc(capacity, stack);
    }

    public static CXUnsavedFile malloc(MemoryStack stack) {
        return new CXUnsavedFile(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXUnsavedFile calloc(MemoryStack stack) {
        return new CXUnsavedFile(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nFilename(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)FILENAME));
    }

    public static String nFilenameString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)FILENAME));
    }

    public static ByteBuffer nContents(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)CONTENTS), (int)CXUnsavedFile.nLength(struct));
    }

    public static long nLength(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)LENGTH);
    }

    public static void nFilename(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)FILENAME, MemoryUtil.memAddress(value));
    }

    public static void nContents(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)CONTENTS, MemoryUtil.memAddress(value));
        CXUnsavedFile.nLength(struct, value.remaining());
    }

    public static void nLength(long struct, long value) {
        MemoryUtil.memPutCLong(struct + (long)LENGTH, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)FILENAME));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CONTENTS));
    }

    static {
        Struct.Layout layout = CXUnsavedFile.__struct(CXUnsavedFile.__member(POINTER_SIZE), CXUnsavedFile.__member(POINTER_SIZE), CXUnsavedFile.__member(CLONG_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FILENAME = layout.offsetof(0);
        CONTENTS = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXUnsavedFile, Buffer>
    implements NativeResource {
        private static final CXUnsavedFile ELEMENT_FACTORY = CXUnsavedFile.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected CXUnsavedFile getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer Filename() {
            return CXUnsavedFile.nFilename(this.address());
        }

        @NativeType(value="char const *")
        public String FilenameString() {
            return CXUnsavedFile.nFilenameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer Contents() {
            return CXUnsavedFile.nContents(this.address());
        }

        @NativeType(value="unsigned long")
        public long Length() {
            return CXUnsavedFile.nLength(this.address());
        }

        public Buffer Filename(@NativeType(value="char const *") ByteBuffer value) {
            CXUnsavedFile.nFilename(this.address(), value);
            return this;
        }

        public Buffer Contents(@NativeType(value="char const *") ByteBuffer value) {
            CXUnsavedFile.nContents(this.address(), value);
            return this;
        }
    }
}

