/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMMCJITCompilerOptions;
import org.lwjgl.llvm.LLVMMemoryManagerAllocateCodeSectionCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerAllocateDataSectionCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerDestroyCallbackI;
import org.lwjgl.llvm.LLVMMemoryManagerFinalizeMemoryCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMExecutionEngine {
    protected LLVMExecutionEngine() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMLinkInMCJIT() {
        long __functionAddress = Functions.LinkInMCJIT;
        JNI.invokeV(__functionAddress);
    }

    public static void LLVMLinkInInterpreter() {
        long __functionAddress = Functions.LinkInInterpreter;
        JNI.invokeV(__functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfInt(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="unsigned long long") long N, @NativeType(value="LLVMBool") boolean IsSigned) {
        long __functionAddress = Functions.CreateGenericValueOfInt;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePJP(Ty, N, IsSigned ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfPointer(@NativeType(value="void *") long P) {
        long __functionAddress = Functions.CreateGenericValueOfPointer;
        if (Checks.CHECKS) {
            Checks.check(P);
        }
        return JNI.invokePP(P, __functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMCreateGenericValueOfFloat(@NativeType(value="LLVMTypeRef") long Ty, double N) {
        long __functionAddress = Functions.CreateGenericValueOfFloat;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, N, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGenericValueIntWidth(@NativeType(value="LLVMGenericValueRef") long GenValRef) {
        long __functionAddress = Functions.GenericValueIntWidth;
        if (Checks.CHECKS) {
            Checks.check(GenValRef);
        }
        return JNI.invokePI(GenValRef, __functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMGenericValueToInt(@NativeType(value="LLVMGenericValueRef") long GenVal, @NativeType(value="LLVMBool") boolean IsSigned) {
        long __functionAddress = Functions.GenericValueToInt;
        if (Checks.CHECKS) {
            Checks.check(GenVal);
        }
        return JNI.invokePJ(GenVal, IsSigned ? 1 : 0, __functionAddress);
    }

    @NativeType(value="void *")
    public static long LLVMGenericValueToPointer(@NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.GenericValueToPointer;
        if (Checks.CHECKS) {
            Checks.check(GenVal);
        }
        return JNI.invokePP(GenVal, __functionAddress);
    }

    public static double LLVMGenericValueToFloat(@NativeType(value="LLVMTypeRef") long TyRef, @NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.GenericValueToFloat;
        if (Checks.CHECKS) {
            Checks.check(TyRef);
            Checks.check(GenVal);
        }
        return JNI.invokePPD(TyRef, GenVal, __functionAddress);
    }

    public static void LLVMDisposeGenericValue(@NativeType(value="LLVMGenericValueRef") long GenVal) {
        long __functionAddress = Functions.DisposeGenericValue;
        if (Checks.CHECKS) {
            Checks.check(GenVal);
        }
        JNI.invokePV(GenVal, __functionAddress);
    }

    public static int nLLVMCreateExecutionEngineForModule(long OutEE, long M, long OutError) {
        long __functionAddress = Functions.CreateExecutionEngineForModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPPI(OutEE, M, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateExecutionEngineForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutEE, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutEE, 1);
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMCreateExecutionEngineForModule(MemoryUtil.memAddress(OutEE), M, MemoryUtil.memAddress(OutError)) != 0;
    }

    public static int nLLVMCreateInterpreterForModule(long OutInterp, long M, long OutError) {
        long __functionAddress = Functions.CreateInterpreterForModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPPI(OutInterp, M, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateInterpreterForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutInterp, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutInterp, 1);
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMCreateInterpreterForModule(MemoryUtil.memAddress(OutInterp), M, MemoryUtil.memAddress(OutError)) != 0;
    }

    public static int nLLVMCreateJITCompilerForModule(long OutJIT, long M, int OptLevel, long OutError) {
        long __functionAddress = Functions.CreateJITCompilerForModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPPI(OutJIT, M, OptLevel, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateJITCompilerForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutJIT, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="unsigned int") int OptLevel, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutJIT, 1);
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMCreateJITCompilerForModule(MemoryUtil.memAddress(OutJIT), M, OptLevel, MemoryUtil.memAddress(OutError)) != 0;
    }

    public static void nLLVMInitializeMCJITCompilerOptions(long Options, long SizeOfOptions) {
        long __functionAddress = Functions.InitializeMCJITCompilerOptions;
        JNI.invokePPV(Options, SizeOfOptions, __functionAddress);
    }

    public static void LLVMInitializeMCJITCompilerOptions(@NativeType(value="struct LLVMMCJITCompilerOptions *") LLVMMCJITCompilerOptions.Buffer Options) {
        LLVMExecutionEngine.nLLVMInitializeMCJITCompilerOptions(Options.address(), Options.remaining());
    }

    public static int nLLVMCreateMCJITCompilerForModule(long OutJIT, long M, long Options, long SizeOfOptions, long OutError) {
        long __functionAddress = Functions.CreateMCJITCompilerForModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPPPPI(OutJIT, M, Options, SizeOfOptions, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMCJITCompilerForModule(@NativeType(value="LLVMExecutionEngineRef *") PointerBuffer OutJIT, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="struct LLVMMCJITCompilerOptions *") LLVMMCJITCompilerOptions.Buffer Options, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutJIT, 1);
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMCreateMCJITCompilerForModule(MemoryUtil.memAddress(OutJIT), M, Options.address(), Options.remaining(), MemoryUtil.memAddress(OutError)) != 0;
    }

    public static void LLVMDisposeExecutionEngine(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.DisposeExecutionEngine;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        JNI.invokePV(EE, __functionAddress);
    }

    public static void LLVMRunStaticConstructors(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.RunStaticConstructors;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        JNI.invokePV(EE, __functionAddress);
    }

    public static void LLVMRunStaticDestructors(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.RunStaticDestructors;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        JNI.invokePV(EE, __functionAddress);
    }

    public static int nLLVMRunFunctionAsMain(long EE, long F, int ArgC, long ArgV, long EnvP) {
        long __functionAddress = Functions.RunFunctionAsMain;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(F);
        }
        return JNI.invokePPPPI(EE, F, ArgC, ArgV, EnvP, __functionAddress);
    }

    public static int LLVMRunFunctionAsMain(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F, @NativeType(value="char const * const *") PointerBuffer ArgV, @NativeType(value="char const * const *") PointerBuffer EnvP) {
        if (Checks.CHECKS) {
            Checks.checkNT(EnvP);
        }
        return LLVMExecutionEngine.nLLVMRunFunctionAsMain(EE, F, ArgV.remaining(), MemoryUtil.memAddress(ArgV), MemoryUtil.memAddress(EnvP));
    }

    public static long nLLVMRunFunction(long EE, long F, int NumArgs, long Args) {
        long __functionAddress = Functions.RunFunction;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(F);
        }
        return JNI.invokePPPP(EE, F, NumArgs, Args, __functionAddress);
    }

    @NativeType(value="LLVMGenericValueRef")
    public static long LLVMRunFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMGenericValueRef *") PointerBuffer Args) {
        return LLVMExecutionEngine.nLLVMRunFunction(EE, F, Args.remaining(), MemoryUtil.memAddress(Args));
    }

    public static void LLVMFreeMachineCodeForFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long F) {
        long __functionAddress = Functions.FreeMachineCodeForFunction;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(F);
        }
        JNI.invokePPV(EE, F, __functionAddress);
    }

    public static void LLVMAddModule(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.AddModule;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(M);
        }
        JNI.invokePPV(EE, M, __functionAddress);
    }

    public static int nLLVMRemoveModule(long EE, long M, long OutMod, long OutError) {
        long __functionAddress = Functions.RemoveModule;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(M);
        }
        return JNI.invokePPPPI(EE, M, OutMod, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRemoveModule(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleRef *") PointerBuffer OutMod, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutMod, 1);
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMRemoveModule(EE, M, MemoryUtil.memAddress(OutMod), MemoryUtil.memAddress(OutError)) != 0;
    }

    public static int nLLVMFindFunction(long EE, long Name4, long OutFn) {
        long __functionAddress = Functions.FindFunction;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        return JNI.invokePPPI(EE, Name4, OutFn, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMFindFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name4, @NativeType(value="LLVMValueRef *") PointerBuffer OutFn) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)Name4, 1);
            Checks.check(OutFn, 1);
        }
        return LLVMExecutionEngine.nLLVMFindFunction(EE, MemoryUtil.memAddress(Name4), MemoryUtil.memAddress(OutFn)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMFindFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name4, @NativeType(value="LLVMValueRef *") PointerBuffer OutFn) {
        if (Checks.CHECKS) {
            Checks.check(Name4, 1);
            Checks.check(OutFn, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name4, true);
            long NameEncoded = stack.getPointerAddress();
            boolean bl = LLVMExecutionEngine.nLLVMFindFunction(EE, NameEncoded, MemoryUtil.memAddress(OutFn)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void *")
    public static long LLVMRecompileAndRelinkFunction(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.RecompileAndRelinkFunction;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(Fn);
        }
        return JNI.invokePPP(EE, Fn, __functionAddress);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMGetExecutionEngineTargetData(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.GetExecutionEngineTargetData;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        return JNI.invokePP(EE, __functionAddress);
    }

    @NativeType(value="LLVMTargetMachineRef")
    public static long LLVMGetExecutionEngineTargetMachine(@NativeType(value="LLVMExecutionEngineRef") long EE) {
        long __functionAddress = Functions.GetExecutionEngineTargetMachine;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        return JNI.invokePP(EE, __functionAddress);
    }

    public static void LLVMAddGlobalMapping(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Global, @NativeType(value="void *") long Addr) {
        long __functionAddress = Functions.AddGlobalMapping;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(Global);
            Checks.check(Addr);
        }
        JNI.invokePPPV(EE, Global, Addr, __functionAddress);
    }

    @NativeType(value="void *")
    public static long LLVMGetPointerToGlobal(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetPointerToGlobal;
        if (Checks.CHECKS) {
            Checks.check(EE);
            Checks.check(Global);
        }
        return JNI.invokePPP(EE, Global, __functionAddress);
    }

    public static long nLLVMGetGlobalValueAddress(long EE, long Name4) {
        long __functionAddress = Functions.GetGlobalValueAddress;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        return JNI.invokePPJ(EE, Name4, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetGlobalValueAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name4) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name4);
        }
        return LLVMExecutionEngine.nLLVMGetGlobalValueAddress(EE, MemoryUtil.memAddress(Name4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long LLVMGetGlobalValueAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name4) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name4, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMExecutionEngine.nLLVMGetGlobalValueAddress(EE, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetFunctionAddress(long EE, long Name4) {
        long __functionAddress = Functions.GetFunctionAddress;
        if (Checks.CHECKS) {
            Checks.check(EE);
        }
        return JNI.invokePPJ(EE, Name4, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetFunctionAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") ByteBuffer Name4) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name4);
        }
        return LLVMExecutionEngine.nLLVMGetFunctionAddress(EE, MemoryUtil.memAddress(Name4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long LLVMGetFunctionAddress(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char const *") CharSequence Name4) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name4, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMExecutionEngine.nLLVMGetFunctionAddress(EE, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMExecutionEngineGetErrMsg(long EE, long OutError) {
        long __functionAddress = Functions.ExecutionEngineGetErrMsg;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(EE);
        }
        return JNI.invokePPI(EE, OutError, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMExecutionEngineGetErrMsg(@NativeType(value="LLVMExecutionEngineRef") long EE, @NativeType(value="char **") PointerBuffer OutError) {
        if (Checks.CHECKS) {
            Checks.check(OutError, 1);
        }
        return LLVMExecutionEngine.nLLVMExecutionEngineGetErrMsg(EE, MemoryUtil.memAddress(OutError)) != 0;
    }

    public static long nLLVMCreateSimpleMCJITMemoryManager(long Opaque, long AllocateCodeSection, long AllocateDataSection, long FinalizeMemory, long Destroy) {
        long __functionAddress = Functions.CreateSimpleMCJITMemoryManager;
        if (Checks.CHECKS) {
            Checks.check(Opaque);
        }
        return JNI.invokePPPPPP(Opaque, AllocateCodeSection, AllocateDataSection, FinalizeMemory, Destroy, __functionAddress);
    }

    @NativeType(value="LLVMMCJITMemoryManagerRef")
    public static long LLVMCreateSimpleMCJITMemoryManager(@NativeType(value="void *") long Opaque, @NativeType(value="uint8_t * (*) (void *, uintptr_t, unsigned int, unsigned int, char const *)") LLVMMemoryManagerAllocateCodeSectionCallbackI AllocateCodeSection, @NativeType(value="uint8_t * (*) (void *, uintptr_t, unsigned int, unsigned int, char const *, LLVMBool)") LLVMMemoryManagerAllocateDataSectionCallbackI AllocateDataSection, @NativeType(value="LLVMBool (*) (void *, char **)") LLVMMemoryManagerFinalizeMemoryCallbackI FinalizeMemory, @NativeType(value="void (*) (void *)") LLVMMemoryManagerDestroyCallbackI Destroy) {
        return LLVMExecutionEngine.nLLVMCreateSimpleMCJITMemoryManager(Opaque, AllocateCodeSection.address(), AllocateDataSection.address(), FinalizeMemory.address(), Destroy.address());
    }

    public static void LLVMDisposeMCJITMemoryManager(@NativeType(value="LLVMMCJITMemoryManagerRef") long MM) {
        long __functionAddress = Functions.DisposeMCJITMemoryManager;
        if (Checks.CHECKS) {
            Checks.check(MM);
        }
        JNI.invokePV(MM, __functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateGDBRegistrationListener() {
        long __functionAddress = Functions.CreateGDBRegistrationListener;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateIntelJITEventListener() {
        long __functionAddress = Functions.CreateIntelJITEventListener;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreateOProfileJITEventListener() {
        long __functionAddress = Functions.CreateOProfileJITEventListener;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMJITEventListenerRef")
    public static long LLVMCreatePerfJITEventListener() {
        long __functionAddress = Functions.CreatePerfJITEventListener;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    public static final class Functions {
        public static final long LinkInMCJIT = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMLinkInMCJIT");
        public static final long LinkInInterpreter = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMLinkInInterpreter");
        public static final long CreateGenericValueOfInt = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateGenericValueOfInt");
        public static final long CreateGenericValueOfPointer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateGenericValueOfPointer");
        public static final long CreateGenericValueOfFloat = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateGenericValueOfFloat");
        public static final long GenericValueIntWidth = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGenericValueIntWidth");
        public static final long GenericValueToInt = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGenericValueToInt");
        public static final long GenericValueToPointer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGenericValueToPointer");
        public static final long GenericValueToFloat = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGenericValueToFloat");
        public static final long DisposeGenericValue = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeGenericValue");
        public static final long CreateExecutionEngineForModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateExecutionEngineForModule");
        public static final long CreateInterpreterForModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateInterpreterForModule");
        public static final long CreateJITCompilerForModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateJITCompilerForModule");
        public static final long InitializeMCJITCompilerOptions = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMInitializeMCJITCompilerOptions");
        public static final long CreateMCJITCompilerForModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateMCJITCompilerForModule");
        public static final long DisposeExecutionEngine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeExecutionEngine");
        public static final long RunStaticConstructors = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRunStaticConstructors");
        public static final long RunStaticDestructors = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRunStaticDestructors");
        public static final long RunFunctionAsMain = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRunFunctionAsMain");
        public static final long RunFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRunFunction");
        public static final long FreeMachineCodeForFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMFreeMachineCodeForFunction");
        public static final long AddModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddModule");
        public static final long RemoveModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRemoveModule");
        public static final long FindFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMFindFunction");
        public static final long RecompileAndRelinkFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMRecompileAndRelinkFunction");
        public static final long GetExecutionEngineTargetData = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetExecutionEngineTargetData");
        public static final long GetExecutionEngineTargetMachine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetExecutionEngineTargetMachine");
        public static final long AddGlobalMapping = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMAddGlobalMapping");
        public static final long GetPointerToGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetPointerToGlobal");
        public static final long GetGlobalValueAddress = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetGlobalValueAddress");
        public static final long GetFunctionAddress = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetFunctionAddress");
        public static final long ExecutionEngineGetErrMsg = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMExecutionEngineGetErrMsg");
        public static final long CreateSimpleMCJITMemoryManager = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateSimpleMCJITMemoryManager");
        public static final long DisposeMCJITMemoryManager = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeMCJITMemoryManager");
        public static final long CreateGDBRegistrationListener = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreateGDBRegistrationListener");
        public static final long CreateIntelJITEventListener = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreateIntelJITEventListener");
        public static final long CreateOProfileJITEventListener = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreateOProfileJITEventListener");
        public static final long CreatePerfJITEventListener = APIUtil.apiGetFunctionAddressOptional(LLVMCore.getLibrary(), "LLVMCreatePerfJITEventListener");

        private Functions() {
        }
    }
}

