/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LTODiagnosticHandlerI;
import org.lwjgl.llvm.LTOObjectBuffer;
import org.lwjgl.llvm.LibLLVM;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMLTO {
    private static final SharedLibrary LTO;
    public static final int LTOAPI_VERSION = 29;
    public static final int LTOSYMBOL_ALIGNMENT_MASK = 31;
    public static final int LTOSYMBOL_PERMISSIONS_MASK = 224;
    public static final int LTOSYMBOL_PERMISSIONS_CODE = 160;
    public static final int LTOSYMBOL_PERMISSIONS_DATA = 192;
    public static final int LTOSYMBOL_PERMISSIONS_RODATA = 128;
    public static final int LTOSYMBOL_DEFINITION_MASK = 1792;
    public static final int LTOSYMBOL_DEFINITION_REGULAR = 256;
    public static final int LTOSYMBOL_DEFINITION_TENTATIVE = 512;
    public static final int LTOSYMBOL_DEFINITION_WEAK = 768;
    public static final int LTOSYMBOL_DEFINITION_UNDEFINED = 1024;
    public static final int LTOSYMBOL_DEFINITION_WEAKUNDEF = 1280;
    public static final int LTOSYMBOL_SCOPE_MASK = 14336;
    public static final int LTOSYMBOL_SCOPE_INTERNAL = 2048;
    public static final int LTOSYMBOL_SCOPE_HIDDEN = 4096;
    public static final int LTOSYMBOL_SCOPE_PROTECTED = 8192;
    public static final int LTOSYMBOL_SCOPE_DEFAULT = 6144;
    public static final int LTOSYMBOL_SCOPE_DEFAULT_CAN_BE_HIDDEN = 10240;
    public static final int LTOSYMBOL_COMDAT = 16384;
    public static final int LTOSYMBOL_ALIAS = 32768;
    public static final int LTODEBUG_MODEL_NONE = 0;
    public static final int LTODEBUG_MODEL_DWARF = 1;
    public static final int LTOCODEGEN_PIC_MODEL_STATIC = 0;
    public static final int LTOCODEGEN_PIC_MODEL_DYNAMIC = 1;
    public static final int LTOCODEGEN_PIC_MODEL_DYNAMIC_NO_PIC = 2;
    public static final int LTOCODEGEN_PIC_MODEL_DEFAULT = 3;
    public static final int LTODS_ERROR = 0;
    public static final int LTODS_WARNING = 1;
    public static final int LTODS_REMARK = 3;
    public static final int LTODS_NOTE = 2;

    public static SharedLibrary getLibrary() {
        return LTO;
    }

    protected LLVMLTO() {
        throw new UnsupportedOperationException();
    }

    public static long nlto_get_version() {
        long __functionAddress = Functions.get_version;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const *")
    public static String lto_get_version() {
        long __result = LLVMLTO.nlto_get_version();
        return MemoryUtil.memUTF8(__result);
    }

    public static long nlto_get_error_message() {
        long __functionAddress = Functions.get_error_message;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String lto_get_error_message() {
        long __result = LLVMLTO.nlto_get_error_message();
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static boolean nlto_module_is_object_file(long path) {
        long __functionAddress = Functions.module_is_object_file;
        return JNI.invokePZ(path, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file(@NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_is_object_file(MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file(@NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = LLVMLTO.nlto_module_is_object_file(pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nlto_module_is_object_file_for_target(long path, long target_triple_prefix) {
        long __functionAddress = Functions.module_is_object_file_for_target;
        return JNI.invokePPZ(path, target_triple_prefix, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file_for_target(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="char const *") ByteBuffer target_triple_prefix) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
            Checks.checkNT1(target_triple_prefix);
        }
        return LLVMLTO.nlto_module_is_object_file_for_target(MemoryUtil.memAddress(path), MemoryUtil.memAddress(target_triple_prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file_for_target(@NativeType(value="char const *") CharSequence path, @NativeType(value="char const *") CharSequence target_triple_prefix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            stack.nUTF8(target_triple_prefix, true);
            long target_triple_prefixEncoded = stack.getPointerAddress();
            boolean bl = LLVMLTO.nlto_module_is_object_file_for_target(pathEncoded, target_triple_prefixEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nlto_module_has_objc_category(long mem, long length) {
        long __functionAddress = Functions.module_has_objc_category;
        return JNI.invokePPZ(mem, length, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_has_objc_category(@NativeType(value="void const *") ByteBuffer mem) {
        return LLVMLTO.nlto_module_has_objc_category(MemoryUtil.memAddress(mem), mem.remaining());
    }

    public static boolean nlto_module_is_object_file_in_memory(long mem, long length) {
        long __functionAddress = Functions.module_is_object_file_in_memory;
        return JNI.invokePPZ(mem, length, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file_in_memory(@NativeType(value="void const *") ByteBuffer mem) {
        return LLVMLTO.nlto_module_is_object_file_in_memory(MemoryUtil.memAddress(mem), mem.remaining());
    }

    public static boolean nlto_module_is_object_file_in_memory_for_target(long mem, long length, long target_triple_prefix) {
        long __functionAddress = Functions.module_is_object_file_in_memory_for_target;
        return JNI.invokePPPZ(mem, length, target_triple_prefix, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file_in_memory_for_target(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") ByteBuffer target_triple_prefix) {
        if (Checks.CHECKS) {
            Checks.checkNT1(target_triple_prefix);
        }
        return LLVMLTO.nlto_module_is_object_file_in_memory_for_target(MemoryUtil.memAddress(mem), mem.remaining(), MemoryUtil.memAddress(target_triple_prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_object_file_in_memory_for_target(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") CharSequence target_triple_prefix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(target_triple_prefix, true);
            long target_triple_prefixEncoded = stack.getPointerAddress();
            boolean bl = LLVMLTO.nlto_module_is_object_file_in_memory_for_target(MemoryUtil.memAddress(mem), mem.remaining(), target_triple_prefixEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create(long path) {
        long __functionAddress = Functions.module_create;
        return JNI.invokePP(path, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create(@NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create(MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create(@NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create(pathEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create_from_memory(long mem, long length) {
        long __functionAddress = Functions.module_create_from_memory;
        return JNI.invokePPP(mem, length, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_memory(@NativeType(value="void const *") ByteBuffer mem) {
        return LLVMLTO.nlto_module_create_from_memory(MemoryUtil.memAddress(mem), mem.remaining());
    }

    public static long nlto_module_create_from_memory_with_path(long mem, long length, long path) {
        long __functionAddress = Functions.module_create_from_memory_with_path;
        return JNI.invokePPPP(mem, length, path, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_memory_with_path(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create_from_memory_with_path(MemoryUtil.memAddress(mem), mem.remaining(), MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_memory_with_path(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create_from_memory_with_path(MemoryUtil.memAddress(mem), mem.remaining(), pathEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create_in_local_context(long mem, long length, long path) {
        long __functionAddress = Functions.module_create_in_local_context;
        return JNI.invokePPPP(mem, length, path, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_in_local_context(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create_in_local_context(MemoryUtil.memAddress(mem), mem.remaining(), MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create_in_local_context(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create_in_local_context(MemoryUtil.memAddress(mem), mem.remaining(), pathEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create_in_codegen_context(long mem, long length, long path, long cg) {
        long __functionAddress = Functions.module_create_in_codegen_context;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePPPPP(mem, length, path, cg, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_in_codegen_context(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="lto_code_gen_t") long cg) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create_in_codegen_context(MemoryUtil.memAddress(mem), mem.remaining(), MemoryUtil.memAddress(path), cg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create_in_codegen_context(@NativeType(value="void const *") ByteBuffer mem, @NativeType(value="char const *") CharSequence path, @NativeType(value="lto_code_gen_t") long cg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create_in_codegen_context(MemoryUtil.memAddress(mem), mem.remaining(), pathEncoded, cg);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create_from_fd(int fd, long path, long file_size) {
        long __functionAddress = Functions.module_create_from_fd;
        return JNI.invokePPP(fd, path, file_size, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_fd(int fd, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="size_t") long file_size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create_from_fd(fd, MemoryUtil.memAddress(path), file_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_fd(int fd, @NativeType(value="char const *") CharSequence path, @NativeType(value="size_t") long file_size) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create_from_fd(fd, pathEncoded, file_size);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_module_create_from_fd_at_offset(int fd, long path, long file_size, long map_size, long offset) {
        long __functionAddress = Functions.module_create_from_fd_at_offset;
        return JNI.invokePPPJP(fd, path, file_size, map_size, offset, __functionAddress);
    }

    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_fd_at_offset(int fd, @NativeType(value="char const *") ByteBuffer path, @NativeType(value="size_t") long file_size, @NativeType(value="size_t") long map_size, @NativeType(value="off_t") long offset) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_module_create_from_fd_at_offset(fd, MemoryUtil.memAddress(path), file_size, map_size, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_module_t")
    public static long lto_module_create_from_fd_at_offset(int fd, @NativeType(value="char const *") CharSequence path, @NativeType(value="size_t") long file_size, @NativeType(value="size_t") long map_size, @NativeType(value="off_t") long offset) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_module_create_from_fd_at_offset(fd, pathEncoded, file_size, map_size, offset);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void lto_module_dispose(@NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.module_dispose;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        JNI.invokePV(mod, __functionAddress);
    }

    public static long nlto_module_get_target_triple(long mod) {
        long __functionAddress = Functions.module_get_target_triple;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePP(mod, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String lto_module_get_target_triple(@NativeType(value="lto_module_t") long mod) {
        long __result = LLVMLTO.nlto_module_get_target_triple(mod);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void nlto_module_set_target_triple(long mod, long triple) {
        long __functionAddress = Functions.module_set_target_triple;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        JNI.invokePPV(mod, triple, __functionAddress);
    }

    public static void lto_module_set_target_triple(@NativeType(value="lto_module_t") long mod, @NativeType(value="char const *") ByteBuffer triple) {
        if (Checks.CHECKS) {
            Checks.checkNT1(triple);
        }
        LLVMLTO.nlto_module_set_target_triple(mod, MemoryUtil.memAddress(triple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lto_module_set_target_triple(@NativeType(value="lto_module_t") long mod, @NativeType(value="char const *") CharSequence triple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(triple, true);
            long tripleEncoded = stack.getPointerAddress();
            LLVMLTO.nlto_module_set_target_triple(mod, tripleEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int lto_module_get_num_symbols(@NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.module_get_num_symbols;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePI(mod, __functionAddress);
    }

    public static long nlto_module_get_symbol_name(long mod, int index) {
        long __functionAddress = Functions.module_get_symbol_name;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePP(mod, index, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String lto_module_get_symbol_name(@NativeType(value="lto_module_t") long mod, @NativeType(value="unsigned int") int index) {
        long __result = LLVMLTO.nlto_module_get_symbol_name(mod, index);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="lto_symbol_attributes")
    public static int lto_module_get_symbol_attribute(@NativeType(value="lto_module_t") long mod, @NativeType(value="unsigned int") int index) {
        long __functionAddress = Functions.module_get_symbol_attribute;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePI(mod, index, __functionAddress);
    }

    public static long nlto_module_get_linkeropts(long mod) {
        long __functionAddress = Functions.module_get_linkeropts;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePP(mod, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String lto_module_get_linkeropts(@NativeType(value="lto_module_t") long mod) {
        long __result = LLVMLTO.nlto_module_get_linkeropts(mod);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static boolean nlto_module_get_macho_cputype(long mod, long out_cputype, long out_cpusubtype) {
        long __functionAddress = Functions.module_get_macho_cputype;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(mod);
        }
        return JNI.invokePPPZ(mod, out_cputype, out_cpusubtype, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_get_macho_cputype(@NativeType(value="lto_module_t") long mod, @NativeType(value="unsigned int *") IntBuffer out_cputype, @NativeType(value="unsigned int *") IntBuffer out_cpusubtype) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)out_cputype, 1);
            Checks.check((Buffer)out_cpusubtype, 1);
        }
        return LLVMLTO.nlto_module_get_macho_cputype(mod, MemoryUtil.memAddress(out_cputype), MemoryUtil.memAddress(out_cpusubtype));
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_has_ctor_dtor(@NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.module_has_ctor_dtor;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(mod);
        }
        return JNI.invokePZ(mod, __functionAddress);
    }

    public static void nlto_codegen_set_diagnostic_handler(long cg, long handler, long ctxt) {
        long __functionAddress = Functions.codegen_set_diagnostic_handler;
        if (Checks.CHECKS) {
            Checks.check(cg);
            Checks.check(ctxt);
        }
        JNI.invokePPPV(cg, handler, ctxt, __functionAddress);
    }

    public static void lto_codegen_set_diagnostic_handler(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="void (*) (lto_codegen_diagnostic_severity_t, char const *, void *)") LTODiagnosticHandlerI handler, @NativeType(value="void *") long ctxt) {
        LLVMLTO.nlto_codegen_set_diagnostic_handler(cg, handler.address(), ctxt);
    }

    @NativeType(value="lto_code_gen_t")
    public static long lto_codegen_create() {
        long __functionAddress = Functions.codegen_create;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="lto_code_gen_t")
    public static long lto_codegen_create_in_local_context() {
        long __functionAddress = Functions.codegen_create_in_local_context;
        return JNI.invokeP(__functionAddress);
    }

    public static void lto_codegen_dispose(@NativeType(value="lto_code_gen_t") long cg) {
        long __functionAddress = Functions.codegen_dispose;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_add_module(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.codegen_add_module;
        if (Checks.CHECKS) {
            Checks.check(cg);
            Checks.check(mod);
        }
        return JNI.invokePPZ(cg, mod, __functionAddress);
    }

    public static void lto_codegen_set_module(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.codegen_set_module;
        if (Checks.CHECKS) {
            Checks.check(cg);
            Checks.check(mod);
        }
        JNI.invokePPV(cg, mod, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_set_debug_model(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_debug_model") int model) {
        long __functionAddress = Functions.codegen_set_debug_model;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePZ(cg, model, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_set_pic_model(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_codegen_model") int model) {
        long __functionAddress = Functions.codegen_set_pic_model;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePZ(cg, model, __functionAddress);
    }

    public static void nlto_codegen_set_cpu(long cg, long cpu) {
        long __functionAddress = Functions.codegen_set_cpu;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, cpu, __functionAddress);
    }

    public static void lto_codegen_set_cpu(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer cpu) {
        if (Checks.CHECKS) {
            Checks.checkNT1(cpu);
        }
        LLVMLTO.nlto_codegen_set_cpu(cg, MemoryUtil.memAddress(cpu));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lto_codegen_set_cpu(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence cpu) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(cpu, true);
            long cpuEncoded = stack.getPointerAddress();
            LLVMLTO.nlto_codegen_set_cpu(cg, cpuEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nlto_codegen_set_assembler_path(long cg, long path) {
        long __functionAddress = Functions.codegen_set_assembler_path;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, path, __functionAddress);
    }

    public static void lto_codegen_set_assembler_path(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        LLVMLTO.nlto_codegen_set_assembler_path(cg, MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lto_codegen_set_assembler_path(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            LLVMLTO.nlto_codegen_set_assembler_path(cg, pathEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nlto_codegen_set_assembler_args(long cg, long args, int nargs) {
        long __functionAddress = Functions.codegen_set_assembler_args;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, args, nargs, __functionAddress);
    }

    public static void lto_codegen_set_assembler_args(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const **") PointerBuffer args) {
        LLVMLTO.nlto_codegen_set_assembler_args(cg, MemoryUtil.memAddress(args), args.remaining());
    }

    public static void nlto_codegen_add_must_preserve_symbol(long cg, long symbol) {
        long __functionAddress = Functions.codegen_add_must_preserve_symbol;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, symbol, __functionAddress);
    }

    public static void lto_codegen_add_must_preserve_symbol(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer symbol) {
        if (Checks.CHECKS) {
            Checks.checkNT1(symbol);
        }
        LLVMLTO.nlto_codegen_add_must_preserve_symbol(cg, MemoryUtil.memAddress(symbol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lto_codegen_add_must_preserve_symbol(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence symbol) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(symbol, true);
            long symbolEncoded = stack.getPointerAddress();
            LLVMLTO.nlto_codegen_add_must_preserve_symbol(cg, symbolEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nlto_codegen_write_merged_modules(long cg, long path) {
        long __functionAddress = Functions.codegen_write_merged_modules;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePPZ(cg, path, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_write_merged_modules(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_codegen_write_merged_modules(cg, MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_write_merged_modules(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            boolean bl = LLVMLTO.nlto_codegen_write_merged_modules(cg, pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_codegen_compile(long cg, long length) {
        long __functionAddress = Functions.codegen_compile;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePPP(cg, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void const *")
    public static @Nullable ByteBuffer lto_codegen_compile(@NativeType(value="lto_code_gen_t") long cg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer length = stack.callocPointer(1);
        try {
            long __result = LLVMLTO.nlto_codegen_compile(cg, MemoryUtil.memAddress(length));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe(__result, (int)length.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nlto_codegen_compile_to_file(long cg, long name) {
        long __functionAddress = Functions.codegen_compile_to_file;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePPZ(cg, name, __functionAddress);
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_compile_to_file(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const **") PointerBuffer name) {
        if (Checks.CHECKS) {
            Checks.check(name, 1);
        }
        return LLVMLTO.nlto_codegen_compile_to_file(cg, MemoryUtil.memAddress(name));
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_codegen_optimize(@NativeType(value="lto_code_gen_t") long cg) {
        long __functionAddress = Functions.codegen_optimize;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePZ(cg, __functionAddress);
    }

    public static long nlto_codegen_compile_optimized(long cg, long length) {
        long __functionAddress = Functions.codegen_compile_optimized;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePPP(cg, length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void const *")
    public static @Nullable ByteBuffer lto_codegen_compile_optimized(@NativeType(value="lto_code_gen_t") long cg) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer length = stack.callocPointer(1);
        try {
            long __result = LLVMLTO.nlto_codegen_compile_optimized(cg, MemoryUtil.memAddress(length));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe(__result, (int)length.get(0));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int lto_api_version() {
        long __functionAddress = Functions.api_version;
        return JNI.invokeI(__functionAddress);
    }

    public static void nlto_set_debug_options(long options, int number) {
        long __functionAddress = Functions.set_debug_options;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePV(options, number, __functionAddress);
    }

    public static void lto_set_debug_options(@NativeType(value="char const * const *") PointerBuffer options) {
        LLVMLTO.nlto_set_debug_options(MemoryUtil.memAddress(options), options.remaining());
    }

    public static void nlto_codegen_debug_options(long cg, long options) {
        long __functionAddress = Functions.codegen_debug_options;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, options, __functionAddress);
    }

    public static void lto_codegen_debug_options(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer options) {
        if (Checks.CHECKS) {
            Checks.checkNT1(options);
        }
        LLVMLTO.nlto_codegen_debug_options(cg, MemoryUtil.memAddress(options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lto_codegen_debug_options(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence options) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(options, true);
            long optionsEncoded = stack.getPointerAddress();
            LLVMLTO.nlto_codegen_debug_options(cg, optionsEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nlto_codegen_debug_options_array(long cg, long options, int number) {
        long __functionAddress = Functions.codegen_debug_options_array;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(cg);
        }
        JNI.invokePPV(cg, options, number, __functionAddress);
    }

    public static void lto_codegen_debug_options_array(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="char const * const *") PointerBuffer options) {
        LLVMLTO.nlto_codegen_debug_options_array(cg, MemoryUtil.memAddress(options), options.remaining());
    }

    public static void lto_initialize_disassembler() {
        long __functionAddress = Functions.initialize_disassembler;
        JNI.invokeV(__functionAddress);
    }

    public static void lto_codegen_set_should_internalize(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_bool_t") boolean ShouldInternalize) {
        long __functionAddress = Functions.codegen_set_should_internalize;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, ShouldInternalize, __functionAddress);
    }

    public static void lto_codegen_set_should_embed_uselists(@NativeType(value="lto_code_gen_t") long cg, @NativeType(value="lto_bool_t") boolean ShouldEmbedUselists) {
        long __functionAddress = Functions.codegen_set_should_embed_uselists;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, ShouldEmbedUselists, __functionAddress);
    }

    public static long nlto_input_create(long buffer, long buffer_size, long path) {
        long __functionAddress = Functions.input_create;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePPPP(buffer, buffer_size, path, __functionAddress);
    }

    @NativeType(value="lto_input_t")
    public static long lto_input_create(@NativeType(value="void const *") ByteBuffer buffer, @NativeType(value="char const *") ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1(path);
        }
        return LLVMLTO.nlto_input_create(MemoryUtil.memAddress(buffer), buffer.remaining(), MemoryUtil.memAddress(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="lto_input_t")
    public static long lto_input_create(@NativeType(value="void const *") ByteBuffer buffer, @NativeType(value="char const *") CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(path, true);
            long pathEncoded = stack.getPointerAddress();
            long l = LLVMLTO.nlto_input_create(MemoryUtil.memAddress(buffer), buffer.remaining(), pathEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void lto_input_dispose(@NativeType(value="lto_input_t") long input) {
        long __functionAddress = Functions.input_dispose;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(input);
        }
        JNI.invokePV(input, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int lto_input_get_num_dependent_libraries(@NativeType(value="lto_input_t") long input) {
        long __functionAddress = Functions.input_get_num_dependent_libraries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(input);
        }
        return JNI.invokePI(input, __functionAddress);
    }

    public static long nlto_input_get_dependent_library(long input, long index, long size) {
        long __functionAddress = Functions.input_get_dependent_library;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(input);
        }
        return JNI.invokePPPP(input, index, size, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String lto_input_get_dependent_library(@NativeType(value="lto_input_t") long input, @NativeType(value="size_t") long index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer size = stack.callocPointer(1);
            long __result = LLVMLTO.nlto_input_get_dependent_library(input, index, MemoryUtil.memAddress(size));
            String string = MemoryUtil.memUTF8Safe(__result, (int)size.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nlto_runtime_lib_symbols_list(long size) {
        long __functionAddress = Functions.runtime_lib_symbols_list;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(size, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const * const *")
    public static @Nullable PointerBuffer lto_runtime_lib_symbols_list() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer size = stack.callocPointer(1);
        try {
            long __result = LLVMLTO.nlto_runtime_lib_symbols_list(MemoryUtil.memAddress(size));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, (int)size.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="thinlto_code_gen_t")
    public static long thinlto_create_codegen() {
        long __functionAddress = Functions.thinlto_create_codegen;
        return JNI.invokeP(__functionAddress);
    }

    public static void thinlto_codegen_dispose(@NativeType(value="thinlto_code_gen_t") long cg) {
        long __functionAddress = Functions.thinlto_codegen_dispose;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, __functionAddress);
    }

    public static void nthinlto_codegen_add_module(long cg, long identifier, long data, int length) {
        long __functionAddress = Functions.thinlto_codegen_add_module;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPPV(cg, identifier, data, length, __functionAddress);
    }

    public static void thinlto_codegen_add_module(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer identifier, @NativeType(value="char const *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(identifier);
        }
        LLVMLTO.nthinlto_codegen_add_module(cg, MemoryUtil.memAddress(identifier), MemoryUtil.memAddress(data), data.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_add_module(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence identifier, @NativeType(value="char const *") ByteBuffer data) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(identifier, true);
            long identifierEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_add_module(cg, identifierEncoded, MemoryUtil.memAddress(data), data.remaining());
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void thinlto_codegen_process(@NativeType(value="thinlto_code_gen_t") long cg) {
        long __functionAddress = Functions.thinlto_codegen_process;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int thinlto_module_get_num_objects(@NativeType(value="thinlto_code_gen_t") long cg) {
        long __functionAddress = Functions.thinlto_module_get_num_objects;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePI(cg, __functionAddress);
    }

    public static native void nthinlto_module_get_object(long var0, int var2, long var3, long var5);

    public static void nthinlto_module_get_object(long cg, int index, long __result) {
        long __functionAddress = Functions.thinlto_module_get_object;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        LLVMLTO.nthinlto_module_get_object(cg, index, __functionAddress, __result);
    }

    public static LTOObjectBuffer thinlto_module_get_object(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int index, LTOObjectBuffer __result) {
        LLVMLTO.nthinlto_module_get_object(cg, index, __result.address());
        return __result;
    }

    @NativeType(value="unsigned int")
    public static int thinlto_module_get_num_object_files(@NativeType(value="thinlto_code_gen_t") long cg) {
        long __functionAddress = Functions.thinlto_module_get_num_object_files;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePI(cg, __functionAddress);
    }

    public static long nthinlto_module_get_object_file(long cg, int index) {
        long __functionAddress = Functions.thinlto_module_get_object_file;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePP(cg, index, __functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String thinlto_module_get_object_file(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int index) {
        long __result = LLVMLTO.nthinlto_module_get_object_file(cg, index);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="lto_bool_t")
    public static boolean thinlto_codegen_set_pic_model(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="lto_codegen_model") int model) {
        long __functionAddress = Functions.thinlto_codegen_set_pic_model;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        return JNI.invokePZ(cg, model, __functionAddress);
    }

    public static void nthinlto_codegen_set_savetemps_dir(long cg, long save_temps_dir) {
        long __functionAddress = Functions.thinlto_codegen_set_savetemps_dir;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, save_temps_dir, __functionAddress);
    }

    public static void thinlto_codegen_set_savetemps_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer save_temps_dir) {
        if (Checks.CHECKS) {
            Checks.checkNT1(save_temps_dir);
        }
        LLVMLTO.nthinlto_codegen_set_savetemps_dir(cg, MemoryUtil.memAddress(save_temps_dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_set_savetemps_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence save_temps_dir) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(save_temps_dir, true);
            long save_temps_dirEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_set_savetemps_dir(cg, save_temps_dirEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nthinlto_set_generated_objects_dir(long cg, long save_temps_dir) {
        long __functionAddress = Functions.thinlto_set_generated_objects_dir;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, save_temps_dir, __functionAddress);
    }

    public static void thinlto_set_generated_objects_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer save_temps_dir) {
        if (Checks.CHECKS) {
            Checks.checkNT1(save_temps_dir);
        }
        LLVMLTO.nthinlto_set_generated_objects_dir(cg, MemoryUtil.memAddress(save_temps_dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_set_generated_objects_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence save_temps_dir) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(save_temps_dir, true);
            long save_temps_dirEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_set_generated_objects_dir(cg, save_temps_dirEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nthinlto_codegen_set_cpu(long cg, long cpu) {
        long __functionAddress = Functions.thinlto_codegen_set_cpu;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, cpu, __functionAddress);
    }

    public static void thinlto_codegen_set_cpu(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer cpu) {
        if (Checks.CHECKS) {
            Checks.checkNT1(cpu);
        }
        LLVMLTO.nthinlto_codegen_set_cpu(cg, MemoryUtil.memAddress(cpu));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_set_cpu(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence cpu) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(cpu, true);
            long cpuEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_set_cpu(cg, cpuEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void thinlto_codegen_disable_codegen(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="lto_bool_t") boolean disable) {
        long __functionAddress = Functions.thinlto_codegen_disable_codegen;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, disable, __functionAddress);
    }

    public static void thinlto_codegen_set_codegen_only(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="lto_bool_t") boolean codegen_only) {
        long __functionAddress = Functions.thinlto_codegen_set_codegen_only;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, codegen_only, __functionAddress);
    }

    public static void nthinlto_debug_options(long options, int number) {
        long __functionAddress = Functions.thinlto_debug_options;
        JNI.invokePV(options, number, __functionAddress);
    }

    public static void thinlto_debug_options(@NativeType(value="char const * const *") PointerBuffer options) {
        LLVMLTO.nthinlto_debug_options(MemoryUtil.memAddress(options), options.remaining());
    }

    @NativeType(value="lto_bool_t")
    public static boolean lto_module_is_thinlto(@NativeType(value="lto_module_t") long mod) {
        long __functionAddress = Functions.module_is_thinlto;
        if (Checks.CHECKS) {
            Checks.check(mod);
        }
        return JNI.invokePZ(mod, __functionAddress);
    }

    public static void nthinlto_codegen_add_must_preserve_symbol(long cg, long name, int length) {
        long __functionAddress = Functions.thinlto_codegen_add_must_preserve_symbol;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, name, length, __functionAddress);
    }

    public static void thinlto_codegen_add_must_preserve_symbol(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer name) {
        LLVMLTO.nthinlto_codegen_add_must_preserve_symbol(cg, MemoryUtil.memAddress(name), name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_add_must_preserve_symbol(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int nameEncodedLength = stack.nUTF8(name, false);
            long nameEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_add_must_preserve_symbol(cg, nameEncoded, nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nthinlto_codegen_add_cross_referenced_symbol(long cg, long name, int length) {
        long __functionAddress = Functions.thinlto_codegen_add_cross_referenced_symbol;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, name, length, __functionAddress);
    }

    public static void thinlto_codegen_add_cross_referenced_symbol(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer name) {
        LLVMLTO.nthinlto_codegen_add_cross_referenced_symbol(cg, MemoryUtil.memAddress(name), name.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_add_cross_referenced_symbol(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int nameEncodedLength = stack.nUTF8(name, false);
            long nameEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_add_cross_referenced_symbol(cg, nameEncoded, nameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nthinlto_codegen_set_cache_dir(long cg, long cache_dir) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_dir;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePPV(cg, cache_dir, __functionAddress);
    }

    public static void thinlto_codegen_set_cache_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") ByteBuffer cache_dir) {
        if (Checks.CHECKS) {
            Checks.checkNT1(cache_dir);
        }
        LLVMLTO.nthinlto_codegen_set_cache_dir(cg, MemoryUtil.memAddress(cache_dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void thinlto_codegen_set_cache_dir(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="char const *") CharSequence cache_dir) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(cache_dir, true);
            long cache_dirEncoded = stack.getPointerAddress();
            LLVMLTO.nthinlto_codegen_set_cache_dir(cg, cache_dirEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void thinlto_codegen_set_cache_pruning_interval(@NativeType(value="thinlto_code_gen_t") long cg, int interval) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_pruning_interval;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, interval, __functionAddress);
    }

    public static void thinlto_codegen_set_final_cache_size_relative_to_available_space(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int percentage) {
        long __functionAddress = Functions.thinlto_codegen_set_final_cache_size_relative_to_available_space;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, percentage, __functionAddress);
    }

    public static void thinlto_codegen_set_cache_entry_expiration(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int expiration) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_entry_expiration;
        if (Checks.CHECKS) {
            Checks.check(cg);
        }
        JNI.invokePV(cg, expiration, __functionAddress);
    }

    public static void thinlto_codegen_set_cache_size_bytes(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int max_size_bytes) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_size_bytes;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(cg);
        }
        JNI.invokePV(cg, max_size_bytes, __functionAddress);
    }

    public static void thinlto_codegen_set_cache_size_megabytes(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int max_size_megabytes) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_size_megabytes;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(cg);
        }
        JNI.invokePV(cg, max_size_megabytes, __functionAddress);
    }

    public static void thinlto_codegen_set_cache_size_files(@NativeType(value="thinlto_code_gen_t") long cg, @NativeType(value="unsigned int") int max_size_files) {
        long __functionAddress = Functions.thinlto_codegen_set_cache_size_files;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(cg);
        }
        JNI.invokePV(cg, max_size_files, __functionAddress);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return LTO;
    }

    static {
        LibLLVM.initialize();
        LTO = Library.loadNative(LLVMLTO.class, "org.lwjgl.llvm", Configuration.LLVM_LTO_LIBRARY_NAME, "LTO");
    }

    public static final class Functions {
        public static final long get_version = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_get_version");
        public static final long get_error_message = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_get_error_message");
        public static final long module_is_object_file = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_is_object_file");
        public static final long module_is_object_file_for_target = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_is_object_file_for_target");
        public static final long module_has_objc_category = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_has_objc_category");
        public static final long module_is_object_file_in_memory = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_is_object_file_in_memory");
        public static final long module_is_object_file_in_memory_for_target = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_is_object_file_in_memory_for_target");
        public static final long module_create = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create");
        public static final long module_create_from_memory = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_from_memory");
        public static final long module_create_from_memory_with_path = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_from_memory_with_path");
        public static final long module_create_in_local_context = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_in_local_context");
        public static final long module_create_in_codegen_context = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_in_codegen_context");
        public static final long module_create_from_fd = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_from_fd");
        public static final long module_create_from_fd_at_offset = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_create_from_fd_at_offset");
        public static final long module_dispose = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_dispose");
        public static final long module_get_target_triple = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_get_target_triple");
        public static final long module_set_target_triple = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_set_target_triple");
        public static final long module_get_num_symbols = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_get_num_symbols");
        public static final long module_get_symbol_name = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_get_symbol_name");
        public static final long module_get_symbol_attribute = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_get_symbol_attribute");
        public static final long module_get_linkeropts = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_get_linkeropts");
        public static final long module_get_macho_cputype = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_module_get_macho_cputype");
        public static final long module_has_ctor_dtor = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_module_has_ctor_dtor");
        public static final long codegen_set_diagnostic_handler = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_diagnostic_handler");
        public static final long codegen_create = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_create");
        public static final long codegen_create_in_local_context = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_create_in_local_context");
        public static final long codegen_dispose = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_dispose");
        public static final long codegen_add_module = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_add_module");
        public static final long codegen_set_module = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_module");
        public static final long codegen_set_debug_model = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_debug_model");
        public static final long codegen_set_pic_model = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_pic_model");
        public static final long codegen_set_cpu = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_cpu");
        public static final long codegen_set_assembler_path = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_assembler_path");
        public static final long codegen_set_assembler_args = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_assembler_args");
        public static final long codegen_add_must_preserve_symbol = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_add_must_preserve_symbol");
        public static final long codegen_write_merged_modules = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_write_merged_modules");
        public static final long codegen_compile = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_compile");
        public static final long codegen_compile_to_file = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_compile_to_file");
        public static final long codegen_optimize = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_optimize");
        public static final long codegen_compile_optimized = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_compile_optimized");
        public static final long api_version = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_api_version");
        public static final long set_debug_options = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_set_debug_options");
        public static final long codegen_debug_options = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_debug_options");
        public static final long codegen_debug_options_array = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_codegen_debug_options_array");
        public static final long initialize_disassembler = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_initialize_disassembler");
        public static final long codegen_set_should_internalize = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_should_internalize");
        public static final long codegen_set_should_embed_uselists = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_codegen_set_should_embed_uselists");
        public static final long input_create = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_input_create");
        public static final long input_dispose = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_input_dispose");
        public static final long input_get_num_dependent_libraries = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_input_get_num_dependent_libraries");
        public static final long input_get_dependent_library = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_input_get_dependent_library");
        public static final long runtime_lib_symbols_list = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "lto_runtime_lib_symbols_list");
        public static final long thinlto_create_codegen = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_create_codegen");
        public static final long thinlto_codegen_dispose = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_dispose");
        public static final long thinlto_codegen_add_module = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_add_module");
        public static final long thinlto_codegen_process = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_process");
        public static final long thinlto_module_get_num_objects = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_module_get_num_objects");
        public static final long thinlto_module_get_object = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_module_get_object");
        public static final long thinlto_module_get_num_object_files = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_module_get_num_object_files");
        public static final long thinlto_module_get_object_file = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_module_get_object_file");
        public static final long thinlto_codegen_set_pic_model = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_pic_model");
        public static final long thinlto_codegen_set_savetemps_dir = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_savetemps_dir");
        public static final long thinlto_set_generated_objects_dir = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_set_generated_objects_dir");
        public static final long thinlto_codegen_set_cpu = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_cpu");
        public static final long thinlto_codegen_disable_codegen = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_disable_codegen");
        public static final long thinlto_codegen_set_codegen_only = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_codegen_only");
        public static final long thinlto_debug_options = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_debug_options");
        public static final long module_is_thinlto = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "lto_module_is_thinlto");
        public static final long thinlto_codegen_add_must_preserve_symbol = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_add_must_preserve_symbol");
        public static final long thinlto_codegen_add_cross_referenced_symbol = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_add_cross_referenced_symbol");
        public static final long thinlto_codegen_set_cache_dir = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_cache_dir");
        public static final long thinlto_codegen_set_cache_pruning_interval = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_cache_pruning_interval");
        public static final long thinlto_codegen_set_final_cache_size_relative_to_available_space = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_final_cache_size_relative_to_available_space");
        public static final long thinlto_codegen_set_cache_entry_expiration = APIUtil.apiGetFunctionAddress(LLVMLTO.access$000(), "thinlto_codegen_set_cache_entry_expiration");
        public static final long thinlto_codegen_set_cache_size_bytes = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "thinlto_codegen_set_cache_size_bytes");
        public static final long thinlto_codegen_set_cache_size_megabytes = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "thinlto_codegen_set_cache_size_megabytes");
        public static final long thinlto_codegen_set_cache_size_files = APIUtil.apiGetFunctionAddressOptional(LLVMLTO.access$000(), "thinlto_codegen_set_cache_size_files");

        private Functions() {
        }
    }
}

