/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LLVMOpInfoSymbol1")
public class LLVMOpInfoSymbol1
extends Struct<LLVMOpInfoSymbol1>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PRESENT;
    public static final int NAME;
    public static final int VALUE;

    protected LLVMOpInfoSymbol1(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOpInfoSymbol1 create(long address, @Nullable ByteBuffer container) {
        return new LLVMOpInfoSymbol1(address, container);
    }

    public LLVMOpInfoSymbol1(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOpInfoSymbol1.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long Present() {
        return LLVMOpInfoSymbol1.nPresent(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer Name() {
        return LLVMOpInfoSymbol1.nName(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String NameString() {
        return LLVMOpInfoSymbol1.nNameString(this.address());
    }

    @NativeType(value="uint64_t")
    public long Value() {
        return LLVMOpInfoSymbol1.nValue(this.address());
    }

    public LLVMOpInfoSymbol1 Present(@NativeType(value="uint64_t") long value) {
        LLVMOpInfoSymbol1.nPresent(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 Name(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        LLVMOpInfoSymbol1.nName(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 Value(@NativeType(value="uint64_t") long value) {
        LLVMOpInfoSymbol1.nValue(this.address(), value);
        return this;
    }

    public LLVMOpInfoSymbol1 set(long Present, @Nullable ByteBuffer Name4, long Value2) {
        this.Present(Present);
        this.Name(Name4);
        this.Value(Value2);
        return this;
    }

    public LLVMOpInfoSymbol1 set(LLVMOpInfoSymbol1 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOpInfoSymbol1 malloc() {
        return new LLVMOpInfoSymbol1(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 calloc() {
        return new LLVMOpInfoSymbol1(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOpInfoSymbol1(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOpInfoSymbol1 create(long address) {
        return new LLVMOpInfoSymbol1(address, null);
    }

    public static @Nullable LLVMOpInfoSymbol1 createSafe(long address) {
        return address == 0L ? null : new LLVMOpInfoSymbol1(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOpInfoSymbol1.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOpInfoSymbol1.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 mallocStack() {
        return LLVMOpInfoSymbol1.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 callocStack() {
        return LLVMOpInfoSymbol1.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 mallocStack(MemoryStack stack) {
        return LLVMOpInfoSymbol1.malloc(stack);
    }

    @Deprecated
    public static LLVMOpInfoSymbol1 callocStack(MemoryStack stack) {
        return LLVMOpInfoSymbol1.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LLVMOpInfoSymbol1.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LLVMOpInfoSymbol1.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfoSymbol1.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LLVMOpInfoSymbol1.calloc(capacity, stack);
    }

    public static LLVMOpInfoSymbol1 malloc(MemoryStack stack) {
        return new LLVMOpInfoSymbol1(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOpInfoSymbol1 calloc(MemoryStack stack) {
        return new LLVMOpInfoSymbol1(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nPresent(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PRESENT);
    }

    public static @Nullable ByteBuffer nName(long struct) {
        return MemoryUtil.memByteBufferNT1Safe(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static @Nullable String nNameString(long struct) {
        return MemoryUtil.memUTF8Safe(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static long nValue(long struct) {
        return MemoryUtil.memGetLong(struct + (long)VALUE);
    }

    public static void nPresent(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PRESENT, value);
    }

    public static void nName(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddressSafe(value));
    }

    public static void nValue(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)VALUE, value);
    }

    static {
        Struct.Layout layout = LLVMOpInfoSymbol1.__struct(LLVMOpInfoSymbol1.__member(8), LLVMOpInfoSymbol1.__member(POINTER_SIZE), LLVMOpInfoSymbol1.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PRESENT = layout.offsetof(0);
        NAME = layout.offsetof(1);
        VALUE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOpInfoSymbol1, Buffer>
    implements NativeResource {
        private static final LLVMOpInfoSymbol1 ELEMENT_FACTORY = LLVMOpInfoSymbol1.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOpInfoSymbol1 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long Present() {
            return LLVMOpInfoSymbol1.nPresent(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer Name() {
            return LLVMOpInfoSymbol1.nName(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String NameString() {
            return LLVMOpInfoSymbol1.nNameString(this.address());
        }

        @NativeType(value="uint64_t")
        public long Value() {
            return LLVMOpInfoSymbol1.nValue(this.address());
        }

        public Buffer Present(@NativeType(value="uint64_t") long value) {
            LLVMOpInfoSymbol1.nPresent(this.address(), value);
            return this;
        }

        public Buffer Name(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            LLVMOpInfoSymbol1.nName(this.address(), value);
            return this;
        }

        public Buffer Value(@NativeType(value="uint64_t") long value) {
            LLVMOpInfoSymbol1.nValue(this.address(), value);
            return this;
        }
    }
}

