/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCJITDylibSearchOrderElement
extends Struct<LLVMOrcCJITDylibSearchOrderElement>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JD;
    public static final int JDLOOKUPFLAGS;

    protected LLVMOrcCJITDylibSearchOrderElement(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCJITDylibSearchOrderElement create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCJITDylibSearchOrderElement(address, container);
    }

    public LLVMOrcCJITDylibSearchOrderElement(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCJITDylibSearchOrderElement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public long JD() {
        return LLVMOrcCJITDylibSearchOrderElement.nJD(this.address());
    }

    @NativeType(value="LLVMOrcJITDylibLookupFlags")
    public int JDLookupFlags() {
        return LLVMOrcCJITDylibSearchOrderElement.nJDLookupFlags(this.address());
    }

    public LLVMOrcCJITDylibSearchOrderElement JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
        LLVMOrcCJITDylibSearchOrderElement.nJD(this.address(), value);
        return this;
    }

    public LLVMOrcCJITDylibSearchOrderElement JDLookupFlags(@NativeType(value="LLVMOrcJITDylibLookupFlags") int value) {
        LLVMOrcCJITDylibSearchOrderElement.nJDLookupFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCJITDylibSearchOrderElement set(long JD, int JDLookupFlags) {
        this.JD(JD);
        this.JDLookupFlags(JDLookupFlags);
        return this;
    }

    public LLVMOrcCJITDylibSearchOrderElement set(LLVMOrcCJITDylibSearchOrderElement src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCJITDylibSearchOrderElement malloc() {
        return new LLVMOrcCJITDylibSearchOrderElement(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCJITDylibSearchOrderElement calloc() {
        return new LLVMOrcCJITDylibSearchOrderElement(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCJITDylibSearchOrderElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCJITDylibSearchOrderElement(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCJITDylibSearchOrderElement create(long address) {
        return new LLVMOrcCJITDylibSearchOrderElement(address, null);
    }

    public static @Nullable LLVMOrcCJITDylibSearchOrderElement createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCJITDylibSearchOrderElement(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCJITDylibSearchOrderElement.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCJITDylibSearchOrderElement.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCJITDylibSearchOrderElement malloc(MemoryStack stack) {
        return new LLVMOrcCJITDylibSearchOrderElement(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCJITDylibSearchOrderElement calloc(MemoryStack stack) {
        return new LLVMOrcCJITDylibSearchOrderElement(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nJD(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)JD);
    }

    public static int nJDLookupFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)JDLOOKUPFLAGS);
    }

    public static void nJD(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)JD, Checks.check(value));
    }

    public static void nJDLookupFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)JDLOOKUPFLAGS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JD));
    }

    static {
        Struct.Layout layout = LLVMOrcCJITDylibSearchOrderElement.__struct(LLVMOrcCJITDylibSearchOrderElement.__member(POINTER_SIZE), LLVMOrcCJITDylibSearchOrderElement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JD = layout.offsetof(0);
        JDLOOKUPFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCJITDylibSearchOrderElement, Buffer>
    implements NativeResource {
        private static final LLVMOrcCJITDylibSearchOrderElement ELEMENT_FACTORY = LLVMOrcCJITDylibSearchOrderElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCJITDylibSearchOrderElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcJITDylibRef")
        public long JD() {
            return LLVMOrcCJITDylibSearchOrderElement.nJD(this.address());
        }

        @NativeType(value="LLVMOrcJITDylibLookupFlags")
        public int JDLookupFlags() {
            return LLVMOrcCJITDylibSearchOrderElement.nJDLookupFlags(this.address());
        }

        public Buffer JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
            LLVMOrcCJITDylibSearchOrderElement.nJD(this.address(), value);
            return this;
        }

        public Buffer JDLookupFlags(@NativeType(value="LLVMOrcJITDylibLookupFlags") int value) {
            LLVMOrcCJITDylibSearchOrderElement.nJDLookupFlags(this.address(), value);
            return this;
        }
    }
}

