/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCLookupSetElement
extends Struct<LLVMOrcCLookupSetElement>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int LOOKUPFLAGS;

    protected LLVMOrcCLookupSetElement(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCLookupSetElement create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCLookupSetElement(address, container);
    }

    public LLVMOrcCLookupSetElement(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCLookupSetElement.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCLookupSetElement.nName(this.address());
    }

    @NativeType(value="LLVMOrcSymbolLookupFlags")
    public int LookupFlags() {
        return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
    }

    public LLVMOrcCLookupSetElement Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCLookupSetElement.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
        LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCLookupSetElement set(long Name4, int LookupFlags) {
        this.Name(Name4);
        this.LookupFlags(LookupFlags);
        return this;
    }

    public LLVMOrcCLookupSetElement set(LLVMOrcCLookupSetElement src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCLookupSetElement malloc() {
        return new LLVMOrcCLookupSetElement(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement calloc() {
        return new LLVMOrcCLookupSetElement(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCLookupSetElement(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCLookupSetElement create(long address) {
        return new LLVMOrcCLookupSetElement(address, null);
    }

    public static @Nullable LLVMOrcCLookupSetElement createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCLookupSetElement(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCLookupSetElement.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCLookupSetElement.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCLookupSetElement malloc(MemoryStack stack) {
        return new LLVMOrcCLookupSetElement(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCLookupSetElement calloc(MemoryStack stack) {
        return new LLVMOrcCLookupSetElement(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static int nLookupFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOOKUPFLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nLookupFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOOKUPFLAGS, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMOrcCLookupSetElement.__struct(LLVMOrcCLookupSetElement.__member(POINTER_SIZE), LLVMOrcCLookupSetElement.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        LOOKUPFLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCLookupSetElement, Buffer>
    implements NativeResource {
        private static final LLVMOrcCLookupSetElement ELEMENT_FACTORY = LLVMOrcCLookupSetElement.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCLookupSetElement getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCLookupSetElement.nName(this.address());
        }

        @NativeType(value="LLVMOrcSymbolLookupFlags")
        public int LookupFlags() {
            return LLVMOrcCLookupSetElement.nLookupFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCLookupSetElement.nName(this.address(), value);
            return this;
        }

        public Buffer LookupFlags(@NativeType(value="LLVMOrcSymbolLookupFlags") int value) {
            LLVMOrcCLookupSetElement.nLookupFlags(this.address(), value);
            return this;
        }
    }
}

