/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCDependenceMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolsList;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolDependenceGroup
extends Struct<LLVMOrcCSymbolDependenceGroup>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SYMBOLS;
    public static final int DEPENDENCIES;
    public static final int NUMDEPENDENCIES;

    protected LLVMOrcCSymbolDependenceGroup(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCSymbolDependenceGroup create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolDependenceGroup(address, container);
    }

    public LLVMOrcCSymbolDependenceGroup(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolDependenceGroup.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public LLVMOrcCSymbolsList Symbols() {
        return LLVMOrcCSymbolDependenceGroup.nSymbols(this.address());
    }

    @NativeType(value="LLVMOrcCDependenceMapPairs")
    public LLVMOrcCDependenceMapPair.Buffer Dependencies() {
        return LLVMOrcCSymbolDependenceGroup.nDependencies(this.address());
    }

    @NativeType(value="size_t")
    public long NumDependencies() {
        return LLVMOrcCSymbolDependenceGroup.nNumDependencies(this.address());
    }

    public LLVMOrcCSymbolDependenceGroup Symbols(LLVMOrcCSymbolsList value) {
        LLVMOrcCSymbolDependenceGroup.nSymbols(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup Symbols(Consumer<LLVMOrcCSymbolsList> consumer) {
        consumer.accept(this.Symbols());
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup Dependencies(@NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer value) {
        LLVMOrcCSymbolDependenceGroup.nDependencies(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup set(LLVMOrcCSymbolsList Symbols, LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        this.Symbols(Symbols);
        this.Dependencies(Dependencies);
        return this;
    }

    public LLVMOrcCSymbolDependenceGroup set(LLVMOrcCSymbolDependenceGroup src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolDependenceGroup malloc() {
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup calloc() {
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCSymbolDependenceGroup(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolDependenceGroup create(long address) {
        return new LLVMOrcCSymbolDependenceGroup(address, null);
    }

    public static @Nullable LLVMOrcCSymbolDependenceGroup createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolDependenceGroup(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolDependenceGroup.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolDependenceGroup.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolDependenceGroup malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolDependenceGroup(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolDependenceGroup calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolDependenceGroup(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LLVMOrcCSymbolsList nSymbols(long struct) {
        return LLVMOrcCSymbolsList.create(struct + (long)SYMBOLS);
    }

    public static LLVMOrcCDependenceMapPair.Buffer nDependencies(long struct) {
        return LLVMOrcCDependenceMapPair.create(MemoryUtil.memGetAddress(struct + (long)DEPENDENCIES), (int)LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct));
    }

    public static long nNumDependencies(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NUMDEPENDENCIES);
    }

    public static void nSymbols(long struct, LLVMOrcCSymbolsList value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYMBOLS, LLVMOrcCSymbolsList.SIZEOF);
    }

    public static void nDependencies(long struct, LLVMOrcCDependenceMapPair.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)DEPENDENCIES, value.address());
        LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct, value.remaining());
    }

    public static void nNumDependencies(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NUMDEPENDENCIES, value);
    }

    public static void validate(long struct) {
        LLVMOrcCSymbolsList.validate(struct + (long)SYMBOLS);
        long NumDependencies = LLVMOrcCSymbolDependenceGroup.nNumDependencies(struct);
        long Dependencies = MemoryUtil.memGetAddress(struct + (long)DEPENDENCIES);
        Checks.check(Dependencies);
        LLVMOrcCSymbolDependenceGroup.validate(Dependencies, NumDependencies, LLVMOrcCDependenceMapPair.SIZEOF, LLVMOrcCDependenceMapPair::validate);
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolDependenceGroup.__struct(LLVMOrcCSymbolDependenceGroup.__member(LLVMOrcCSymbolsList.SIZEOF, LLVMOrcCSymbolsList.ALIGNOF), LLVMOrcCSymbolDependenceGroup.__member(POINTER_SIZE), LLVMOrcCSymbolDependenceGroup.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SYMBOLS = layout.offsetof(0);
        DEPENDENCIES = layout.offsetof(1);
        NUMDEPENDENCIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolDependenceGroup, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolDependenceGroup ELEMENT_FACTORY = LLVMOrcCSymbolDependenceGroup.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCSymbolDependenceGroup getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public LLVMOrcCSymbolsList Symbols() {
            return LLVMOrcCSymbolDependenceGroup.nSymbols(this.address());
        }

        @NativeType(value="LLVMOrcCDependenceMapPairs")
        public LLVMOrcCDependenceMapPair.Buffer Dependencies() {
            return LLVMOrcCSymbolDependenceGroup.nDependencies(this.address());
        }

        @NativeType(value="size_t")
        public long NumDependencies() {
            return LLVMOrcCSymbolDependenceGroup.nNumDependencies(this.address());
        }

        public Buffer Symbols(LLVMOrcCSymbolsList value) {
            LLVMOrcCSymbolDependenceGroup.nSymbols(this.address(), value);
            return this;
        }

        public Buffer Symbols(Consumer<LLVMOrcCSymbolsList> consumer) {
            consumer.accept(this.Symbols());
            return this;
        }

        public Buffer Dependencies(@NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer value) {
            LLVMOrcCSymbolDependenceGroup.nDependencies(this.address(), value);
            return this;
        }
    }
}

