/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITSymbolFlags;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolFlagsMapPair
extends Struct<LLVMOrcCSymbolFlagsMapPair>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int FLAGS;

    protected LLVMOrcCSymbolFlagsMapPair(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCSymbolFlagsMapPair create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolFlagsMapPair(address, container);
    }

    public LLVMOrcCSymbolFlagsMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolFlagsMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolFlagsMapPair.nName(this.address());
    }

    public LLVMJITSymbolFlags Flags() {
        return LLVMOrcCSymbolFlagsMapPair.nFlags(this.address());
    }

    public LLVMOrcCSymbolFlagsMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolFlagsMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair Flags(LLVMJITSymbolFlags value) {
        LLVMOrcCSymbolFlagsMapPair.nFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair Flags(Consumer<LLVMJITSymbolFlags> consumer) {
        consumer.accept(this.Flags());
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair set(long Name4, LLVMJITSymbolFlags Flags2) {
        this.Name(Name4);
        this.Flags(Flags2);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair set(LLVMOrcCSymbolFlagsMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolFlagsMapPair malloc() {
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair calloc() {
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolFlagsMapPair create(long address) {
        return new LLVMOrcCSymbolFlagsMapPair(address, null);
    }

    public static @Nullable LLVMOrcCSymbolFlagsMapPair createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolFlagsMapPair(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolFlagsMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolFlagsMapPair.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolFlagsMapPair malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolFlagsMapPair(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolFlagsMapPair(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static LLVMJITSymbolFlags nFlags(long struct) {
        return LLVMJITSymbolFlags.create(struct + (long)FLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nFlags(long struct, LLVMJITSymbolFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, LLVMJITSymbolFlags.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolFlagsMapPair.__struct(LLVMOrcCSymbolFlagsMapPair.__member(POINTER_SIZE), LLVMOrcCSymbolFlagsMapPair.__member(LLVMJITSymbolFlags.SIZEOF, LLVMJITSymbolFlags.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolFlagsMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolFlagsMapPair ELEMENT_FACTORY = LLVMOrcCSymbolFlagsMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCSymbolFlagsMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolFlagsMapPair.nName(this.address());
        }

        public LLVMJITSymbolFlags Flags() {
            return LLVMOrcCSymbolFlagsMapPair.nFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolFlagsMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Flags(LLVMJITSymbolFlags value) {
            LLVMOrcCSymbolFlagsMapPair.nFlags(this.address(), value);
            return this;
        }

        public Buffer Flags(Consumer<LLVMJITSymbolFlags> consumer) {
            consumer.accept(this.Flags());
            return this;
        }
    }
}

