/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolsList
extends Struct<LLVMOrcCSymbolsList>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SYMBOLS;
    public static final int LENGTH;

    protected LLVMOrcCSymbolsList(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected LLVMOrcCSymbolsList create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolsList(address, container);
    }

    public LLVMOrcCSymbolsList(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCSymbolsList.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
    public PointerBuffer Symbols() {
        return LLVMOrcCSymbolsList.nSymbols(this.address());
    }

    @NativeType(value="size_t")
    public long Length() {
        return LLVMOrcCSymbolsList.nLength(this.address());
    }

    public LLVMOrcCSymbolsList Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
        LLVMOrcCSymbolsList.nSymbols(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolsList set(LLVMOrcCSymbolsList src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolsList malloc() {
        return new LLVMOrcCSymbolsList(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LLVMOrcCSymbolsList calloc() {
        return new LLVMOrcCSymbolsList(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LLVMOrcCSymbolsList create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new LLVMOrcCSymbolsList(MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCSymbolsList create(long address) {
        return new LLVMOrcCSymbolsList(address, null);
    }

    public static @Nullable LLVMOrcCSymbolsList createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolsList(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(LLVMOrcCSymbolsList.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolsList.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolsList malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolsList(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolsList calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolsList(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nSymbols(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)SYMBOLS), (int)LLVMOrcCSymbolsList.nLength(struct));
    }

    public static long nLength(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LENGTH);
    }

    public static void nSymbols(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SYMBOLS, MemoryUtil.memAddress(value));
        LLVMOrcCSymbolsList.nLength(struct, value.remaining());
    }

    public static void nLength(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LENGTH, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)SYMBOLS));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolsList.__struct(LLVMOrcCSymbolsList.__member(POINTER_SIZE), LLVMOrcCSymbolsList.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SYMBOLS = layout.offsetof(0);
        LENGTH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolsList, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolsList ELEMENT_FACTORY = LLVMOrcCSymbolsList.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected LLVMOrcCSymbolsList getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
        public PointerBuffer Symbols() {
            return LLVMOrcCSymbolsList.nSymbols(this.address());
        }

        @NativeType(value="size_t")
        public long Length() {
            return LLVMOrcCSymbolsList.nLength(this.address());
        }

        public Buffer Symbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer value) {
            LLVMOrcCSymbolsList.nSymbols(this.address(), value);
            return this;
        }
    }
}

