/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct NSVGpath")
public class NSVGPath
extends Struct<NSVGPath> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTS;
    public static final int NPTS;
    public static final int CLOSED;
    public static final int BOUNDS;
    public static final int NEXT;

    protected NSVGPath(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NSVGPath create(long address, @Nullable ByteBuffer container) {
        return new NSVGPath(address, container);
    }

    public NSVGPath(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NSVGPath.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer pts() {
        return NSVGPath.npts(this.address());
    }

    public int npts() {
        return NSVGPath.nnpts(this.address());
    }

    @NativeType(value="char")
    public byte closed() {
        return NSVGPath.nclosed(this.address());
    }

    @NativeType(value="float[4]")
    public FloatBuffer bounds() {
        return NSVGPath.nbounds(this.address());
    }

    public float bounds(int index) {
        return NSVGPath.nbounds(this.address(), index);
    }

    @NativeType(value="NSVGpath *")
    public NSVGPath next() {
        return NSVGPath.nnext(this.address());
    }

    public static NSVGPath create(long address) {
        return new NSVGPath(address, null);
    }

    public static @Nullable NSVGPath createSafe(long address) {
        return address == 0L ? null : new NSVGPath(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FloatBuffer npts(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)PTS), NSVGPath.nnpts(struct) << 1);
    }

    public static int nnpts(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NPTS);
    }

    public static byte nclosed(long struct) {
        return MemoryUtil.memGetByte(struct + (long)CLOSED);
    }

    public static FloatBuffer nbounds(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)BOUNDS, 4);
    }

    public static float nbounds(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)BOUNDS + Checks.check(index, 4) * 4L);
    }

    public static NSVGPath nnext(long struct) {
        return NSVGPath.create(MemoryUtil.memGetAddress(struct + (long)NEXT));
    }

    static {
        Struct.Layout layout = NSVGPath.__struct(NSVGPath.__member(POINTER_SIZE), NSVGPath.__member(4), NSVGPath.__member(1), NSVGPath.__array(4, 4), NSVGPath.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTS = layout.offsetof(0);
        NPTS = layout.offsetof(1);
        CLOSED = layout.offsetof(2);
        BOUNDS = layout.offsetof(3);
        NEXT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NSVGPath, Buffer> {
        private static final NSVGPath ELEMENT_FACTORY = NSVGPath.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NSVGPath getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer pts() {
            return NSVGPath.npts(this.address());
        }

        public int npts() {
            return NSVGPath.nnpts(this.address());
        }

        @NativeType(value="char")
        public byte closed() {
            return NSVGPath.nclosed(this.address());
        }

        @NativeType(value="float[4]")
        public FloatBuffer bounds() {
            return NSVGPath.nbounds(this.address());
        }

        public float bounds(int index) {
            return NSVGPath.nbounds(this.address(), index);
        }

        @NativeType(value="NSVGpath *")
        public NSVGPath next() {
            return NSVGPath.nnext(this.address());
        }
    }
}

