/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkAllocator;
import org.lwjgl.nuklear.NkCursor;
import org.lwjgl.nuklear.NkFont;
import org.lwjgl.nuklear.NkFontConfig;
import org.lwjgl.nuklear.NkFontGlyph;
import org.lwjgl.nuklear.NkRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_font_atlas")
public class NkFontAtlas
extends Struct<NkFontAtlas>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXEL;
    public static final int TEX_WIDTH;
    public static final int TEX_HEIGHT;
    public static final int PERMANENT;
    public static final int TEMPORARY;
    public static final int CUSTOM;
    public static final int CURSORS;
    public static final int GLYPH_COUNT;
    public static final int GLYPHS;
    public static final int DEFAULT_FONT;
    public static final int FONTS;
    public static final int CONFIG;
    public static final int FONT_NUM;

    protected NkFontAtlas(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkFontAtlas create(long address, @Nullable ByteBuffer container) {
        return new NkFontAtlas(address, container);
    }

    public NkFontAtlas(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkFontAtlas.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer pixel() {
        return NkFontAtlas.npixel(this.address());
    }

    public int tex_width() {
        return NkFontAtlas.ntex_width(this.address());
    }

    public int tex_height() {
        return NkFontAtlas.ntex_height(this.address());
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator permanent() {
        return NkFontAtlas.npermanent(this.address());
    }

    @NativeType(value="struct nk_allocator")
    public NkAllocator temporary() {
        return NkFontAtlas.ntemporary(this.address());
    }

    @NativeType(value="struct nk_recti")
    public NkRecti custom() {
        return NkFontAtlas.ncustom(this.address());
    }

    @NativeType(value="struct nk_cursor[7]")
    public NkCursor.Buffer cursors() {
        return NkFontAtlas.ncursors(this.address());
    }

    @NativeType(value="struct nk_cursor")
    public NkCursor cursors(int index) {
        return NkFontAtlas.ncursors(this.address(), index);
    }

    public int glyph_count() {
        return NkFontAtlas.nglyph_count(this.address());
    }

    @NativeType(value="struct nk_font_glyph *")
    public @Nullable NkFontGlyph.Buffer glyphs() {
        return NkFontAtlas.nglyphs(this.address());
    }

    @NativeType(value="struct nk_font *")
    public @Nullable NkFont default_font() {
        return NkFontAtlas.ndefault_font(this.address());
    }

    @NativeType(value="struct nk_font *")
    public @Nullable NkFont fonts() {
        return NkFontAtlas.nfonts(this.address());
    }

    @NativeType(value="struct nk_font_config *")
    public @Nullable NkFontConfig config() {
        return NkFontAtlas.nconfig(this.address());
    }

    public int font_num() {
        return NkFontAtlas.nfont_num(this.address());
    }

    public NkFontAtlas pixel(@NativeType(value="void *") @Nullable ByteBuffer value) {
        NkFontAtlas.npixel(this.address(), value);
        return this;
    }

    public NkFontAtlas tex_width(int value) {
        NkFontAtlas.ntex_width(this.address(), value);
        return this;
    }

    public NkFontAtlas tex_height(int value) {
        NkFontAtlas.ntex_height(this.address(), value);
        return this;
    }

    public NkFontAtlas permanent(@NativeType(value="struct nk_allocator") NkAllocator value) {
        NkFontAtlas.npermanent(this.address(), value);
        return this;
    }

    public NkFontAtlas permanent(Consumer<NkAllocator> consumer) {
        consumer.accept(this.permanent());
        return this;
    }

    public NkFontAtlas temporary(@NativeType(value="struct nk_allocator") NkAllocator value) {
        NkFontAtlas.ntemporary(this.address(), value);
        return this;
    }

    public NkFontAtlas temporary(Consumer<NkAllocator> consumer) {
        consumer.accept(this.temporary());
        return this;
    }

    public NkFontAtlas custom(@NativeType(value="struct nk_recti") NkRecti value) {
        NkFontAtlas.ncustom(this.address(), value);
        return this;
    }

    public NkFontAtlas custom(Consumer<NkRecti> consumer) {
        consumer.accept(this.custom());
        return this;
    }

    public NkFontAtlas cursors(@NativeType(value="struct nk_cursor[7]") NkCursor.Buffer value) {
        NkFontAtlas.ncursors(this.address(), value);
        return this;
    }

    public NkFontAtlas cursors(int index, @NativeType(value="struct nk_cursor") NkCursor value) {
        NkFontAtlas.ncursors(this.address(), index, value);
        return this;
    }

    public NkFontAtlas cursors(Consumer<NkCursor.Buffer> consumer) {
        consumer.accept(this.cursors());
        return this;
    }

    public NkFontAtlas cursors(int index, Consumer<NkCursor> consumer) {
        consumer.accept(this.cursors(index));
        return this;
    }

    public NkFontAtlas glyph_count(int value) {
        NkFontAtlas.nglyph_count(this.address(), value);
        return this;
    }

    public NkFontAtlas glyphs(@NativeType(value="struct nk_font_glyph *") @Nullable NkFontGlyph.Buffer value) {
        NkFontAtlas.nglyphs(this.address(), value);
        return this;
    }

    public NkFontAtlas default_font(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
        NkFontAtlas.ndefault_font(this.address(), value);
        return this;
    }

    public NkFontAtlas fonts(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
        NkFontAtlas.nfonts(this.address(), value);
        return this;
    }

    public NkFontAtlas config(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
        NkFontAtlas.nconfig(this.address(), value);
        return this;
    }

    public NkFontAtlas font_num(int value) {
        NkFontAtlas.nfont_num(this.address(), value);
        return this;
    }

    public NkFontAtlas set(@Nullable ByteBuffer pixel, int tex_width, int tex_height, NkAllocator permanent, NkAllocator temporary, NkRecti custom, NkCursor.Buffer cursors, int glyph_count, @Nullable NkFontGlyph.Buffer glyphs, @Nullable NkFont default_font, @Nullable NkFont fonts, @Nullable NkFontConfig config, int font_num) {
        this.pixel(pixel);
        this.tex_width(tex_width);
        this.tex_height(tex_height);
        this.permanent(permanent);
        this.temporary(temporary);
        this.custom(custom);
        this.cursors(cursors);
        this.glyph_count(glyph_count);
        this.glyphs(glyphs);
        this.default_font(default_font);
        this.fonts(fonts);
        this.config(config);
        this.font_num(font_num);
        return this;
    }

    public NkFontAtlas set(NkFontAtlas src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkFontAtlas malloc() {
        return new NkFontAtlas(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkFontAtlas calloc() {
        return new NkFontAtlas(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkFontAtlas create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkFontAtlas(MemoryUtil.memAddress(container), container);
    }

    public static NkFontAtlas create(long address) {
        return new NkFontAtlas(address, null);
    }

    public static @Nullable NkFontAtlas createSafe(long address) {
        return address == 0L ? null : new NkFontAtlas(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkFontAtlas.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkFontAtlas.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkFontAtlas malloc(MemoryStack stack) {
        return new NkFontAtlas(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkFontAtlas calloc(MemoryStack stack) {
        return new NkFontAtlas(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static @Nullable ByteBuffer npixel(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PIXEL), NkFontAtlas.ntex_width(struct) * NkFontAtlas.ntex_height(struct));
    }

    public static int ntex_width(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEX_WIDTH);
    }

    public static int ntex_height(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEX_HEIGHT);
    }

    public static NkAllocator npermanent(long struct) {
        return NkAllocator.create(struct + (long)PERMANENT);
    }

    public static NkAllocator ntemporary(long struct) {
        return NkAllocator.create(struct + (long)TEMPORARY);
    }

    public static NkRecti ncustom(long struct) {
        return NkRecti.create(struct + (long)CUSTOM);
    }

    public static NkCursor.Buffer ncursors(long struct) {
        return NkCursor.create(struct + (long)CURSORS, 7);
    }

    public static NkCursor ncursors(long struct, int index) {
        return NkCursor.create(struct + (long)CURSORS + Checks.check(index, 7) * (long)NkCursor.SIZEOF);
    }

    public static int nglyph_count(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GLYPH_COUNT);
    }

    public static @Nullable NkFontGlyph.Buffer nglyphs(long struct) {
        return NkFontGlyph.createSafe(MemoryUtil.memGetAddress(struct + (long)GLYPHS), NkFontAtlas.nglyph_count(struct));
    }

    public static @Nullable NkFont ndefault_font(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress(struct + (long)DEFAULT_FONT));
    }

    public static @Nullable NkFont nfonts(long struct) {
        return NkFont.createSafe(MemoryUtil.memGetAddress(struct + (long)FONTS));
    }

    public static @Nullable NkFontConfig nconfig(long struct) {
        return NkFontConfig.createSafe(MemoryUtil.memGetAddress(struct + (long)CONFIG));
    }

    public static int nfont_num(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FONT_NUM);
    }

    public static void npixel(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIXEL, MemoryUtil.memAddressSafe(value));
        NkFontAtlas.ntex_width(struct, value == null ? 0 : value.remaining());
    }

    public static void ntex_width(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEX_WIDTH, value);
    }

    public static void ntex_height(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TEX_HEIGHT, value);
    }

    public static void npermanent(long struct, NkAllocator value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PERMANENT, NkAllocator.SIZEOF);
    }

    public static void ntemporary(long struct, NkAllocator value) {
        MemoryUtil.memCopy(value.address(), struct + (long)TEMPORARY, NkAllocator.SIZEOF);
    }

    public static void ncustom(long struct, NkRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CUSTOM, NkRecti.SIZEOF);
    }

    public static void ncursors(long struct, NkCursor.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)CURSORS, value.remaining() * NkCursor.SIZEOF);
    }

    public static void ncursors(long struct, int index, NkCursor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)CURSORS + Checks.check(index, 7) * (long)NkCursor.SIZEOF, NkCursor.SIZEOF);
    }

    public static void nglyph_count(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GLYPH_COUNT, value);
    }

    public static void nglyphs(long struct, @Nullable NkFontGlyph.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)GLYPHS, MemoryUtil.memAddressSafe(value));
        NkFontAtlas.nglyph_count(struct, value == null ? 0 : value.remaining());
    }

    public static void ndefault_font(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress(struct + (long)DEFAULT_FONT, MemoryUtil.memAddressSafe(value));
    }

    public static void nfonts(long struct, @Nullable NkFont value) {
        MemoryUtil.memPutAddress(struct + (long)FONTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nconfig(long struct, @Nullable NkFontConfig value) {
        MemoryUtil.memPutAddress(struct + (long)CONFIG, MemoryUtil.memAddressSafe(value));
    }

    public static void nfont_num(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FONT_NUM, value);
    }

    static {
        Struct.Layout layout = NkFontAtlas.__struct(NkFontAtlas.__member(POINTER_SIZE), NkFontAtlas.__member(4), NkFontAtlas.__member(4), NkFontAtlas.__member(NkAllocator.SIZEOF, NkAllocator.ALIGNOF), NkFontAtlas.__member(NkAllocator.SIZEOF, NkAllocator.ALIGNOF), NkFontAtlas.__member(NkRecti.SIZEOF, NkRecti.ALIGNOF), NkFontAtlas.__array(NkCursor.SIZEOF, NkCursor.ALIGNOF, 7), NkFontAtlas.__member(4), NkFontAtlas.__member(POINTER_SIZE), NkFontAtlas.__member(POINTER_SIZE), NkFontAtlas.__member(POINTER_SIZE), NkFontAtlas.__member(POINTER_SIZE), NkFontAtlas.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXEL = layout.offsetof(0);
        TEX_WIDTH = layout.offsetof(1);
        TEX_HEIGHT = layout.offsetof(2);
        PERMANENT = layout.offsetof(3);
        TEMPORARY = layout.offsetof(4);
        CUSTOM = layout.offsetof(5);
        CURSORS = layout.offsetof(6);
        GLYPH_COUNT = layout.offsetof(7);
        GLYPHS = layout.offsetof(8);
        DEFAULT_FONT = layout.offsetof(9);
        FONTS = layout.offsetof(10);
        CONFIG = layout.offsetof(11);
        FONT_NUM = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<NkFontAtlas, Buffer>
    implements NativeResource {
        private static final NkFontAtlas ELEMENT_FACTORY = NkFontAtlas.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkFontAtlas getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer pixel() {
            return NkFontAtlas.npixel(this.address());
        }

        public int tex_width() {
            return NkFontAtlas.ntex_width(this.address());
        }

        public int tex_height() {
            return NkFontAtlas.ntex_height(this.address());
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator permanent() {
            return NkFontAtlas.npermanent(this.address());
        }

        @NativeType(value="struct nk_allocator")
        public NkAllocator temporary() {
            return NkFontAtlas.ntemporary(this.address());
        }

        @NativeType(value="struct nk_recti")
        public NkRecti custom() {
            return NkFontAtlas.ncustom(this.address());
        }

        @NativeType(value="struct nk_cursor[7]")
        public NkCursor.Buffer cursors() {
            return NkFontAtlas.ncursors(this.address());
        }

        @NativeType(value="struct nk_cursor")
        public NkCursor cursors(int index) {
            return NkFontAtlas.ncursors(this.address(), index);
        }

        public int glyph_count() {
            return NkFontAtlas.nglyph_count(this.address());
        }

        @NativeType(value="struct nk_font_glyph *")
        public @Nullable NkFontGlyph.Buffer glyphs() {
            return NkFontAtlas.nglyphs(this.address());
        }

        @NativeType(value="struct nk_font *")
        public @Nullable NkFont default_font() {
            return NkFontAtlas.ndefault_font(this.address());
        }

        @NativeType(value="struct nk_font *")
        public @Nullable NkFont fonts() {
            return NkFontAtlas.nfonts(this.address());
        }

        @NativeType(value="struct nk_font_config *")
        public @Nullable NkFontConfig config() {
            return NkFontAtlas.nconfig(this.address());
        }

        public int font_num() {
            return NkFontAtlas.nfont_num(this.address());
        }

        public Buffer pixel(@NativeType(value="void *") @Nullable ByteBuffer value) {
            NkFontAtlas.npixel(this.address(), value);
            return this;
        }

        public Buffer tex_width(int value) {
            NkFontAtlas.ntex_width(this.address(), value);
            return this;
        }

        public Buffer tex_height(int value) {
            NkFontAtlas.ntex_height(this.address(), value);
            return this;
        }

        public Buffer permanent(@NativeType(value="struct nk_allocator") NkAllocator value) {
            NkFontAtlas.npermanent(this.address(), value);
            return this;
        }

        public Buffer permanent(Consumer<NkAllocator> consumer) {
            consumer.accept(this.permanent());
            return this;
        }

        public Buffer temporary(@NativeType(value="struct nk_allocator") NkAllocator value) {
            NkFontAtlas.ntemporary(this.address(), value);
            return this;
        }

        public Buffer temporary(Consumer<NkAllocator> consumer) {
            consumer.accept(this.temporary());
            return this;
        }

        public Buffer custom(@NativeType(value="struct nk_recti") NkRecti value) {
            NkFontAtlas.ncustom(this.address(), value);
            return this;
        }

        public Buffer custom(Consumer<NkRecti> consumer) {
            consumer.accept(this.custom());
            return this;
        }

        public Buffer cursors(@NativeType(value="struct nk_cursor[7]") NkCursor.Buffer value) {
            NkFontAtlas.ncursors(this.address(), value);
            return this;
        }

        public Buffer cursors(int index, @NativeType(value="struct nk_cursor") NkCursor value) {
            NkFontAtlas.ncursors(this.address(), index, value);
            return this;
        }

        public Buffer cursors(Consumer<NkCursor.Buffer> consumer) {
            consumer.accept(this.cursors());
            return this;
        }

        public Buffer cursors(int index, Consumer<NkCursor> consumer) {
            consumer.accept(this.cursors(index));
            return this;
        }

        public Buffer glyph_count(int value) {
            NkFontAtlas.nglyph_count(this.address(), value);
            return this;
        }

        public Buffer glyphs(@NativeType(value="struct nk_font_glyph *") @Nullable NkFontGlyph.Buffer value) {
            NkFontAtlas.nglyphs(this.address(), value);
            return this;
        }

        public Buffer default_font(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
            NkFontAtlas.ndefault_font(this.address(), value);
            return this;
        }

        public Buffer fonts(@NativeType(value="struct nk_font *") @Nullable NkFont value) {
            NkFontAtlas.nfonts(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="struct nk_font_config *") @Nullable NkFontConfig value) {
            NkFontAtlas.nconfig(this.address(), value);
            return this;
        }

        public Buffer font_num(int value) {
            NkFontAtlas.nfont_num(this.address(), value);
            return this;
        }
    }
}

