/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_memory_status")
public class NkMemoryStatus
extends Struct<NkMemoryStatus>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORY;
    public static final int TYPE;
    public static final int SIZE;
    public static final int ALLOCATED;
    public static final int NEEDED;
    public static final int CALLS;

    protected NkMemoryStatus(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkMemoryStatus create(long address, @Nullable ByteBuffer container) {
        return new NkMemoryStatus(address, container);
    }

    public NkMemoryStatus(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkMemoryStatus.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer memory() {
        return NkMemoryStatus.nmemory(this.address());
    }

    @NativeType(value="unsigned int")
    public int type() {
        return NkMemoryStatus.ntype(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkMemoryStatus.nsize(this.address());
    }

    @NativeType(value="nk_size")
    public long allocated() {
        return NkMemoryStatus.nallocated(this.address());
    }

    @NativeType(value="nk_size")
    public long needed() {
        return NkMemoryStatus.nneeded(this.address());
    }

    @NativeType(value="nk_size")
    public long calls() {
        return NkMemoryStatus.ncalls(this.address());
    }

    public static NkMemoryStatus malloc() {
        return new NkMemoryStatus(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkMemoryStatus calloc() {
        return new NkMemoryStatus(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkMemoryStatus create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkMemoryStatus(MemoryUtil.memAddress(container), container);
    }

    public static NkMemoryStatus create(long address) {
        return new NkMemoryStatus(address, null);
    }

    public static @Nullable NkMemoryStatus createSafe(long address) {
        return address == 0L ? null : new NkMemoryStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkMemoryStatus.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkMemoryStatus.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkMemoryStatus mallocStack() {
        return NkMemoryStatus.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkMemoryStatus callocStack() {
        return NkMemoryStatus.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkMemoryStatus mallocStack(MemoryStack stack) {
        return NkMemoryStatus.malloc(stack);
    }

    @Deprecated
    public static NkMemoryStatus callocStack(MemoryStack stack) {
        return NkMemoryStatus.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkMemoryStatus.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkMemoryStatus.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkMemoryStatus.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkMemoryStatus.calloc(capacity, stack);
    }

    public static NkMemoryStatus malloc(MemoryStack stack) {
        return new NkMemoryStatus(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkMemoryStatus calloc(MemoryStack stack) {
        return new NkMemoryStatus(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nmemory(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MEMORY), (int)NkMemoryStatus.nsize(struct));
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static long nallocated(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ALLOCATED);
    }

    public static long nneeded(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEEDED);
    }

    public static long ncalls(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CALLS);
    }

    static {
        Struct.Layout layout = NkMemoryStatus.__struct(NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(4), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE), NkMemoryStatus.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORY = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
        ALLOCATED = layout.offsetof(3);
        NEEDED = layout.offsetof(4);
        CALLS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkMemoryStatus, Buffer>
    implements NativeResource {
        private static final NkMemoryStatus ELEMENT_FACTORY = NkMemoryStatus.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkMemoryStatus getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer memory() {
            return NkMemoryStatus.nmemory(this.address());
        }

        @NativeType(value="unsigned int")
        public int type() {
            return NkMemoryStatus.ntype(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkMemoryStatus.nsize(this.address());
        }

        @NativeType(value="nk_size")
        public long allocated() {
            return NkMemoryStatus.nallocated(this.address());
        }

        @NativeType(value="nk_size")
        public long needed() {
            return NkMemoryStatus.nneeded(this.address());
        }

        @NativeType(value="nk_size")
        public long calls() {
            return NkMemoryStatus.ncalls(this.address());
        }
    }
}

