/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_nine_slice")
public class NkNineSlice
extends Struct<NkNineSlice>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMG;
    public static final int L;
    public static final int T;
    public static final int R;
    public static final int B;

    protected NkNineSlice(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkNineSlice create(long address, @Nullable ByteBuffer container) {
        return new NkNineSlice(address, container);
    }

    public NkNineSlice(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkNineSlice.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_image")
    public NkImage img() {
        return NkNineSlice.nimg(this.address());
    }

    @NativeType(value="nk_ushort")
    public short l() {
        return NkNineSlice.nl(this.address());
    }

    @NativeType(value="nk_ushort")
    public short t() {
        return NkNineSlice.nt(this.address());
    }

    @NativeType(value="nk_ushort")
    public short r() {
        return NkNineSlice.nr(this.address());
    }

    @NativeType(value="nk_ushort")
    public short b() {
        return NkNineSlice.nb(this.address());
    }

    public NkNineSlice img(@NativeType(value="struct nk_image") NkImage value) {
        NkNineSlice.nimg(this.address(), value);
        return this;
    }

    public NkNineSlice img(Consumer<NkImage> consumer) {
        consumer.accept(this.img());
        return this;
    }

    public NkNineSlice l(@NativeType(value="nk_ushort") short value) {
        NkNineSlice.nl(this.address(), value);
        return this;
    }

    public NkNineSlice t(@NativeType(value="nk_ushort") short value) {
        NkNineSlice.nt(this.address(), value);
        return this;
    }

    public NkNineSlice r(@NativeType(value="nk_ushort") short value) {
        NkNineSlice.nr(this.address(), value);
        return this;
    }

    public NkNineSlice b(@NativeType(value="nk_ushort") short value) {
        NkNineSlice.nb(this.address(), value);
        return this;
    }

    public NkNineSlice set(NkImage img, short l, short t, short r, short b) {
        this.img(img);
        this.l(l);
        this.t(t);
        this.r(r);
        this.b(b);
        return this;
    }

    public NkNineSlice set(NkNineSlice src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkNineSlice malloc() {
        return new NkNineSlice(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkNineSlice calloc() {
        return new NkNineSlice(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkNineSlice create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkNineSlice(MemoryUtil.memAddress(container), container);
    }

    public static NkNineSlice create(long address) {
        return new NkNineSlice(address, null);
    }

    public static @Nullable NkNineSlice createSafe(long address) {
        return address == 0L ? null : new NkNineSlice(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkNineSlice.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkNineSlice.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkNineSlice malloc(MemoryStack stack) {
        return new NkNineSlice(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkNineSlice calloc(MemoryStack stack) {
        return new NkNineSlice(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkImage nimg(long struct) {
        return NkImage.create(struct + (long)IMG);
    }

    public static short nl(long struct) {
        return MemoryUtil.memGetShort(struct + (long)L);
    }

    public static short nt(long struct) {
        return MemoryUtil.memGetShort(struct + (long)T);
    }

    public static short nr(long struct) {
        return MemoryUtil.memGetShort(struct + (long)R);
    }

    public static short nb(long struct) {
        return MemoryUtil.memGetShort(struct + (long)B);
    }

    public static void nimg(long struct, NkImage value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMG, NkImage.SIZEOF);
    }

    public static void nl(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)L, value);
    }

    public static void nt(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)T, value);
    }

    public static void nr(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)R, value);
    }

    public static void nb(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)B, value);
    }

    static {
        Struct.Layout layout = NkNineSlice.__struct(NkNineSlice.__member(NkImage.SIZEOF, NkImage.ALIGNOF), NkNineSlice.__member(2), NkNineSlice.__member(2), NkNineSlice.__member(2), NkNineSlice.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMG = layout.offsetof(0);
        L = layout.offsetof(1);
        T = layout.offsetof(2);
        R = layout.offsetof(3);
        B = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<NkNineSlice, Buffer>
    implements NativeResource {
        private static final NkNineSlice ELEMENT_FACTORY = NkNineSlice.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkNineSlice getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_image")
        public NkImage img() {
            return NkNineSlice.nimg(this.address());
        }

        @NativeType(value="nk_ushort")
        public short l() {
            return NkNineSlice.nl(this.address());
        }

        @NativeType(value="nk_ushort")
        public short t() {
            return NkNineSlice.nt(this.address());
        }

        @NativeType(value="nk_ushort")
        public short r() {
            return NkNineSlice.nr(this.address());
        }

        @NativeType(value="nk_ushort")
        public short b() {
            return NkNineSlice.nb(this.address());
        }

        public Buffer img(@NativeType(value="struct nk_image") NkImage value) {
            NkNineSlice.nimg(this.address(), value);
            return this;
        }

        public Buffer img(Consumer<NkImage> consumer) {
            consumer.accept(this.img());
            return this;
        }

        public Buffer l(@NativeType(value="nk_ushort") short value) {
            NkNineSlice.nl(this.address(), value);
            return this;
        }

        public Buffer t(@NativeType(value="nk_ushort") short value) {
            NkNineSlice.nt(this.address(), value);
            return this;
        }

        public Buffer r(@NativeType(value="nk_ushort") short value) {
            NkNineSlice.nr(this.address(), value);
            return this;
        }

        public Buffer b(@NativeType(value="nk_ushort") short value) {
            NkNineSlice.nb(this.address(), value);
            return this;
        }
    }
}

