/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_recti")
public class NkRecti
extends Struct<NkRecti>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    protected NkRecti(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkRecti create(long address, @Nullable ByteBuffer container) {
        return new NkRecti(address, container);
    }

    public NkRecti(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkRecti.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short x() {
        return NkRecti.nx(this.address());
    }

    public short y() {
        return NkRecti.ny(this.address());
    }

    public short w() {
        return NkRecti.nw(this.address());
    }

    public short h() {
        return NkRecti.nh(this.address());
    }

    public NkRecti x(short value) {
        NkRecti.nx(this.address(), value);
        return this;
    }

    public NkRecti y(short value) {
        NkRecti.ny(this.address(), value);
        return this;
    }

    public NkRecti w(short value) {
        NkRecti.nw(this.address(), value);
        return this;
    }

    public NkRecti h(short value) {
        NkRecti.nh(this.address(), value);
        return this;
    }

    public NkRecti set(short x, short y, short w, short h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public NkRecti set(NkRecti src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkRecti malloc() {
        return new NkRecti(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkRecti calloc() {
        return new NkRecti(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkRecti create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkRecti(MemoryUtil.memAddress(container), container);
    }

    public static NkRecti create(long address) {
        return new NkRecti(address, null);
    }

    public static @Nullable NkRecti createSafe(long address) {
        return address == 0L ? null : new NkRecti(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkRecti.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkRecti.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static NkRecti malloc(MemoryStack stack) {
        return new NkRecti(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkRecti calloc(MemoryStack stack) {
        return new NkRecti(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X);
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y);
    }

    public static short nw(long struct) {
        return MemoryUtil.memGetShort(struct + (long)W);
    }

    public static short nh(long struct) {
        return MemoryUtil.memGetShort(struct + (long)H);
    }

    public static void nx(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)X, value);
    }

    public static void ny(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)Y, value);
    }

    public static void nw(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)W, value);
    }

    public static void nh(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = NkRecti.__struct(NkRecti.__member(2), NkRecti.__member(2), NkRecti.__member(2), NkRecti.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkRecti, Buffer>
    implements NativeResource {
        private static final NkRecti ELEMENT_FACTORY = NkRecti.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkRecti getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public short x() {
            return NkRecti.nx(this.address());
        }

        public short y() {
            return NkRecti.ny(this.address());
        }

        public short w() {
            return NkRecti.nw(this.address());
        }

        public short h() {
            return NkRecti.nh(this.address());
        }

        public Buffer x(short value) {
            NkRecti.nx(this.address(), value);
            return this;
        }

        public Buffer y(short value) {
            NkRecti.ny(this.address(), value);
            return this;
        }

        public Buffer w(short value) {
            NkRecti.nw(this.address(), value);
            return this;
        }

        public Buffer h(short value) {
            NkRecti.nh(this.address(), value);
            return this;
        }
    }
}

