/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkStyleItem;
import org.lwjgl.nuklear.NkVec2;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_style_chart")
public class NkStyleChart
extends Struct<NkStyleChart>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BACKGROUND;
    public static final int BORDER_COLOR;
    public static final int SELECTED_COLOR;
    public static final int COLOR;
    public static final int BORDER;
    public static final int ROUNDING;
    public static final int PADDING;
    public static final int COLOR_FACTOR;
    public static final int DISABLED_FACTOR;
    public static final int SHOW_MARKERS;

    protected NkStyleChart(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected NkStyleChart create(long address, @Nullable ByteBuffer container) {
        return new NkStyleChart(address, container);
    }

    public NkStyleChart(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NkStyleChart.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_style_item")
    public NkStyleItem background() {
        return NkStyleChart.nbackground(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor border_color() {
        return NkStyleChart.nborder_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor selected_color() {
        return NkStyleChart.nselected_color(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleChart.ncolor(this.address());
    }

    public float border() {
        return NkStyleChart.nborder(this.address());
    }

    public float rounding() {
        return NkStyleChart.nrounding(this.address());
    }

    @NativeType(value="struct nk_vec2")
    public NkVec2 padding() {
        return NkStyleChart.npadding(this.address());
    }

    public float color_factor() {
        return NkStyleChart.ncolor_factor(this.address());
    }

    public float disabled_factor() {
        return NkStyleChart.ndisabled_factor(this.address());
    }

    @NativeType(value="nk_bool")
    public boolean show_markers() {
        return NkStyleChart.nshow_markers(this.address());
    }

    public NkStyleChart background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
        NkStyleChart.nbackground(this.address(), value);
        return this;
    }

    public NkStyleChart background(Consumer<NkStyleItem> consumer) {
        consumer.accept(this.background());
        return this;
    }

    public NkStyleChart border_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nborder_color(this.address(), value);
        return this;
    }

    public NkStyleChart border_color(Consumer<NkColor> consumer) {
        consumer.accept(this.border_color());
        return this;
    }

    public NkStyleChart selected_color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.nselected_color(this.address(), value);
        return this;
    }

    public NkStyleChart selected_color(Consumer<NkColor> consumer) {
        consumer.accept(this.selected_color());
        return this;
    }

    public NkStyleChart color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleChart.ncolor(this.address(), value);
        return this;
    }

    public NkStyleChart color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleChart border(float value) {
        NkStyleChart.nborder(this.address(), value);
        return this;
    }

    public NkStyleChart rounding(float value) {
        NkStyleChart.nrounding(this.address(), value);
        return this;
    }

    public NkStyleChart padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
        NkStyleChart.npadding(this.address(), value);
        return this;
    }

    public NkStyleChart padding(Consumer<NkVec2> consumer) {
        consumer.accept(this.padding());
        return this;
    }

    public NkStyleChart color_factor(float value) {
        NkStyleChart.ncolor_factor(this.address(), value);
        return this;
    }

    public NkStyleChart disabled_factor(float value) {
        NkStyleChart.ndisabled_factor(this.address(), value);
        return this;
    }

    public NkStyleChart show_markers(@NativeType(value="nk_bool") boolean value) {
        NkStyleChart.nshow_markers(this.address(), value);
        return this;
    }

    public NkStyleChart set(NkStyleItem background, NkColor border_color, NkColor selected_color, NkColor color, float border, float rounding, NkVec2 padding, float color_factor, float disabled_factor, boolean show_markers) {
        this.background(background);
        this.border_color(border_color);
        this.selected_color(selected_color);
        this.color(color);
        this.border(border);
        this.rounding(rounding);
        this.padding(padding);
        this.color_factor(color_factor);
        this.disabled_factor(disabled_factor);
        this.show_markers(show_markers);
        return this;
    }

    public NkStyleChart set(NkStyleChart src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static NkStyleChart malloc() {
        return new NkStyleChart(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static NkStyleChart calloc() {
        return new NkStyleChart(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static NkStyleChart create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new NkStyleChart(MemoryUtil.memAddress(container), container);
    }

    public static NkStyleChart create(long address) {
        return new NkStyleChart(address, null);
    }

    public static @Nullable NkStyleChart createSafe(long address) {
        return address == 0L ? null : new NkStyleChart(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(NkStyleChart.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleChart.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static NkStyleChart mallocStack() {
        return NkStyleChart.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleChart callocStack() {
        return NkStyleChart.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkStyleChart mallocStack(MemoryStack stack) {
        return NkStyleChart.malloc(stack);
    }

    @Deprecated
    public static NkStyleChart callocStack(MemoryStack stack) {
        return NkStyleChart.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkStyleChart.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkStyleChart.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkStyleChart.calloc(capacity, stack);
    }

    public static NkStyleChart malloc(MemoryStack stack) {
        return new NkStyleChart(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static NkStyleChart calloc(MemoryStack stack) {
        return new NkStyleChart(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static NkStyleItem nbackground(long struct) {
        return NkStyleItem.create(struct + (long)BACKGROUND);
    }

    public static NkColor nborder_color(long struct) {
        return NkColor.create(struct + (long)BORDER_COLOR);
    }

    public static NkColor nselected_color(long struct) {
        return NkColor.create(struct + (long)SELECTED_COLOR);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static float nborder(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)BORDER);
    }

    public static float nrounding(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)ROUNDING);
    }

    public static NkVec2 npadding(long struct) {
        return NkVec2.create(struct + (long)PADDING);
    }

    public static float ncolor_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)COLOR_FACTOR);
    }

    public static float ndisabled_factor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISABLED_FACTOR);
    }

    public static boolean nshow_markers(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SHOW_MARKERS) != 0;
    }

    public static void nbackground(long struct, NkStyleItem value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BACKGROUND, NkStyleItem.SIZEOF);
    }

    public static void nborder_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)BORDER_COLOR, NkColor.SIZEOF);
    }

    public static void nselected_color(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SELECTED_COLOR, NkColor.SIZEOF);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, NkColor.SIZEOF);
    }

    public static void nborder(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)BORDER, value);
    }

    public static void nrounding(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)ROUNDING, value);
    }

    public static void npadding(long struct, NkVec2 value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PADDING, NkVec2.SIZEOF);
    }

    public static void ncolor_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)COLOR_FACTOR, value);
    }

    public static void ndisabled_factor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DISABLED_FACTOR, value);
    }

    public static void nshow_markers(long struct, boolean value) {
        MemoryUtil.memPutByte(struct + (long)SHOW_MARKERS, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = NkStyleChart.__struct(NkStyleChart.__member(NkStyleItem.SIZEOF, NkStyleItem.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(NkColor.SIZEOF, NkColor.ALIGNOF), NkStyleChart.__member(4), NkStyleChart.__member(4), NkStyleChart.__member(NkVec2.SIZEOF, NkVec2.ALIGNOF), NkStyleChart.__member(4), NkStyleChart.__member(4), NkStyleChart.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BACKGROUND = layout.offsetof(0);
        BORDER_COLOR = layout.offsetof(1);
        SELECTED_COLOR = layout.offsetof(2);
        COLOR = layout.offsetof(3);
        BORDER = layout.offsetof(4);
        ROUNDING = layout.offsetof(5);
        PADDING = layout.offsetof(6);
        COLOR_FACTOR = layout.offsetof(7);
        DISABLED_FACTOR = layout.offsetof(8);
        SHOW_MARKERS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<NkStyleChart, Buffer>
    implements NativeResource {
        private static final NkStyleChart ELEMENT_FACTORY = NkStyleChart.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected NkStyleChart getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_style_item")
        public NkStyleItem background() {
            return NkStyleChart.nbackground(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor border_color() {
            return NkStyleChart.nborder_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor selected_color() {
            return NkStyleChart.nselected_color(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleChart.ncolor(this.address());
        }

        public float border() {
            return NkStyleChart.nborder(this.address());
        }

        public float rounding() {
            return NkStyleChart.nrounding(this.address());
        }

        @NativeType(value="struct nk_vec2")
        public NkVec2 padding() {
            return NkStyleChart.npadding(this.address());
        }

        public float color_factor() {
            return NkStyleChart.ncolor_factor(this.address());
        }

        public float disabled_factor() {
            return NkStyleChart.ndisabled_factor(this.address());
        }

        @NativeType(value="nk_bool")
        public boolean show_markers() {
            return NkStyleChart.nshow_markers(this.address());
        }

        public Buffer background(@NativeType(value="struct nk_style_item") NkStyleItem value) {
            NkStyleChart.nbackground(this.address(), value);
            return this;
        }

        public Buffer background(Consumer<NkStyleItem> consumer) {
            consumer.accept(this.background());
            return this;
        }

        public Buffer border_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nborder_color(this.address(), value);
            return this;
        }

        public Buffer border_color(Consumer<NkColor> consumer) {
            consumer.accept(this.border_color());
            return this;
        }

        public Buffer selected_color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.nselected_color(this.address(), value);
            return this;
        }

        public Buffer selected_color(Consumer<NkColor> consumer) {
            consumer.accept(this.selected_color());
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleChart.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer border(float value) {
            NkStyleChart.nborder(this.address(), value);
            return this;
        }

        public Buffer rounding(float value) {
            NkStyleChart.nrounding(this.address(), value);
            return this;
        }

        public Buffer padding(@NativeType(value="struct nk_vec2") NkVec2 value) {
            NkStyleChart.npadding(this.address(), value);
            return this;
        }

        public Buffer padding(Consumer<NkVec2> consumer) {
            consumer.accept(this.padding());
            return this;
        }

        public Buffer color_factor(float value) {
            NkStyleChart.ncolor_factor(this.address(), value);
            return this;
        }

        public Buffer disabled_factor(float value) {
            NkStyleChart.ndisabled_factor(this.address(), value);
            return this;
        }

        public Buffer show_markers(@NativeType(value="nk_bool") boolean value) {
            NkStyleChart.nshow_markers(this.address(), value);
            return this;
        }
    }
}

