/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.odbc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SQL_NUMERIC_STRUCT
extends Struct<SQL_NUMERIC_STRUCT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PRECISION;
    public static final int SCALE;
    public static final int SIGN;
    public static final int VAL;

    protected SQL_NUMERIC_STRUCT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected SQL_NUMERIC_STRUCT create(long address, @Nullable ByteBuffer container) {
        return new SQL_NUMERIC_STRUCT(address, container);
    }

    public SQL_NUMERIC_STRUCT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SQL_NUMERIC_STRUCT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SQLCHAR")
    public byte precision() {
        return SQL_NUMERIC_STRUCT.nprecision(this.address());
    }

    @NativeType(value="SQLSCHAR")
    public byte scale() {
        return SQL_NUMERIC_STRUCT.nscale(this.address());
    }

    @NativeType(value="SQLCHAR")
    public byte sign() {
        return SQL_NUMERIC_STRUCT.nsign(this.address());
    }

    @NativeType(value="SQLCHAR[SQL_MAX_NUMERIC_LEN]")
    public ByteBuffer val() {
        return SQL_NUMERIC_STRUCT.nval(this.address());
    }

    @NativeType(value="SQLCHAR")
    public byte val(int index) {
        return SQL_NUMERIC_STRUCT.nval(this.address(), index);
    }

    public SQL_NUMERIC_STRUCT precision(@NativeType(value="SQLCHAR") byte value) {
        SQL_NUMERIC_STRUCT.nprecision(this.address(), value);
        return this;
    }

    public SQL_NUMERIC_STRUCT scale(@NativeType(value="SQLSCHAR") byte value) {
        SQL_NUMERIC_STRUCT.nscale(this.address(), value);
        return this;
    }

    public SQL_NUMERIC_STRUCT sign(@NativeType(value="SQLCHAR") byte value) {
        SQL_NUMERIC_STRUCT.nsign(this.address(), value);
        return this;
    }

    public SQL_NUMERIC_STRUCT val(@NativeType(value="SQLCHAR[SQL_MAX_NUMERIC_LEN]") ByteBuffer value) {
        SQL_NUMERIC_STRUCT.nval(this.address(), value);
        return this;
    }

    public SQL_NUMERIC_STRUCT val(int index, @NativeType(value="SQLCHAR") byte value) {
        SQL_NUMERIC_STRUCT.nval(this.address(), index, value);
        return this;
    }

    public SQL_NUMERIC_STRUCT set(byte precision, byte scale, byte sign, ByteBuffer val) {
        this.precision(precision);
        this.scale(scale);
        this.sign(sign);
        this.val(val);
        return this;
    }

    public SQL_NUMERIC_STRUCT set(SQL_NUMERIC_STRUCT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SQL_NUMERIC_STRUCT malloc() {
        return new SQL_NUMERIC_STRUCT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static SQL_NUMERIC_STRUCT calloc() {
        return new SQL_NUMERIC_STRUCT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static SQL_NUMERIC_STRUCT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new SQL_NUMERIC_STRUCT(MemoryUtil.memAddress(container), container);
    }

    public static SQL_NUMERIC_STRUCT create(long address) {
        return new SQL_NUMERIC_STRUCT(address, null);
    }

    public static @Nullable SQL_NUMERIC_STRUCT createSafe(long address) {
        return address == 0L ? null : new SQL_NUMERIC_STRUCT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(SQL_NUMERIC_STRUCT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SQL_NUMERIC_STRUCT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static SQL_NUMERIC_STRUCT mallocStack() {
        return SQL_NUMERIC_STRUCT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static SQL_NUMERIC_STRUCT callocStack() {
        return SQL_NUMERIC_STRUCT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static SQL_NUMERIC_STRUCT mallocStack(MemoryStack stack) {
        return SQL_NUMERIC_STRUCT.malloc(stack);
    }

    @Deprecated
    public static SQL_NUMERIC_STRUCT callocStack(MemoryStack stack) {
        return SQL_NUMERIC_STRUCT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return SQL_NUMERIC_STRUCT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return SQL_NUMERIC_STRUCT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return SQL_NUMERIC_STRUCT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return SQL_NUMERIC_STRUCT.calloc(capacity, stack);
    }

    public static SQL_NUMERIC_STRUCT malloc(MemoryStack stack) {
        return new SQL_NUMERIC_STRUCT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SQL_NUMERIC_STRUCT calloc(MemoryStack stack) {
        return new SQL_NUMERIC_STRUCT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nprecision(long struct) {
        return MemoryUtil.memGetByte(struct + (long)PRECISION);
    }

    public static byte nscale(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SCALE);
    }

    public static byte nsign(long struct) {
        return MemoryUtil.memGetByte(struct + (long)SIGN);
    }

    public static ByteBuffer nval(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)VAL, 16);
    }

    public static byte nval(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)VAL + Checks.check(index, 16) * 1L);
    }

    public static void nprecision(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)PRECISION, value);
    }

    public static void nscale(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)SCALE, value);
    }

    public static void nsign(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)SIGN, value);
    }

    public static void nval(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)VAL, value.remaining() * 1);
    }

    public static void nval(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)VAL + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = SQL_NUMERIC_STRUCT.__struct(SQL_NUMERIC_STRUCT.__member(1), SQL_NUMERIC_STRUCT.__member(1), SQL_NUMERIC_STRUCT.__member(1), SQL_NUMERIC_STRUCT.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PRECISION = layout.offsetof(0);
        SCALE = layout.offsetof(1);
        SIGN = layout.offsetof(2);
        VAL = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SQL_NUMERIC_STRUCT, Buffer>
    implements NativeResource {
        private static final SQL_NUMERIC_STRUCT ELEMENT_FACTORY = SQL_NUMERIC_STRUCT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected SQL_NUMERIC_STRUCT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SQLCHAR")
        public byte precision() {
            return SQL_NUMERIC_STRUCT.nprecision(this.address());
        }

        @NativeType(value="SQLSCHAR")
        public byte scale() {
            return SQL_NUMERIC_STRUCT.nscale(this.address());
        }

        @NativeType(value="SQLCHAR")
        public byte sign() {
            return SQL_NUMERIC_STRUCT.nsign(this.address());
        }

        @NativeType(value="SQLCHAR[SQL_MAX_NUMERIC_LEN]")
        public ByteBuffer val() {
            return SQL_NUMERIC_STRUCT.nval(this.address());
        }

        @NativeType(value="SQLCHAR")
        public byte val(int index) {
            return SQL_NUMERIC_STRUCT.nval(this.address(), index);
        }

        public Buffer precision(@NativeType(value="SQLCHAR") byte value) {
            SQL_NUMERIC_STRUCT.nprecision(this.address(), value);
            return this;
        }

        public Buffer scale(@NativeType(value="SQLSCHAR") byte value) {
            SQL_NUMERIC_STRUCT.nscale(this.address(), value);
            return this;
        }

        public Buffer sign(@NativeType(value="SQLCHAR") byte value) {
            SQL_NUMERIC_STRUCT.nsign(this.address(), value);
            return this;
        }

        public Buffer val(@NativeType(value="SQLCHAR[SQL_MAX_NUMERIC_LEN]") ByteBuffer value) {
            SQL_NUMERIC_STRUCT.nval(this.address(), value);
            return this;
        }

        public Buffer val(int index, @NativeType(value="SQLCHAR") byte value) {
            SQL_NUMERIC_STRUCT.nval(this.address(), index, value);
            return this;
        }
    }
}

